<?php $__env->startSection('title', trans('general.title.edit', ['type' => trans_choice('general.items', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('items/items')); ?>" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.items', 1) . ' List'); ?> </a>

<a href="<?php echo e(url('items/items/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Products and Services (Items)"><i class="material-icons left">add</i><?php echo e(trans_choice('general.items', 2)); ?></a>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Default box -->
<div class="card">
    <?php echo Form::model($item, [
        'method' => 'PATCH',
        'files' => true,
        'url' => ['items/items', $item->id],
        'role' => 'form'
    ]); ?>


    <div class="row">
		<div class="col-md-3">
            <?php echo e(Form::selectGroup('source_type', trans_choice('general.items', 1), $product_serve, $item->source_type, ['required'=>'required'])); ?>

        </div>

        <div class="col-md-3">
            <?php echo e(Form::textGroup('name', trans('general.name'), null)); ?>

        </div>
        
        <div class="col-md-3">
            <?php echo e(Form::numberGroup('sale_price', trans('items.sales_price'), null)); ?>

        </div>

        

         <div class="col-lg-3 col-md-4 col-sm-6  ">
            <small><?php echo e(trans_choice('general.income_account', 1)); ?> <span class="RED-Star">*</span></small>               
            <select  id="income_account" class="selectpicker" data-live-search="true" name="income_account" tabindex="-1" aria-hidden="true" required="required"  onchange="addChartofAccount(event)">
                 <?php echo loopChartData($account_details_name , $prefix = '',$item->income_account); ?> 
            </select>
        </div>

        
        <div class="col-lg-3 col-md-4 col-sm-6">
                <small>Sub <?php echo e(trans_choice('general.items', 1)); ?></small>
                <select id="subitem" name="subitem" data-live-search="true" class="selectpicker" disabled="disabled">

                    <?php echo $__env->make('accounts.common.subloop', ['customers' => $items ,'customer_id' => $item->subitem ,'name' => trans('general.form.select.field', ['field' => 'Product Service'])    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </select>
            
                <div class="help-block">
                <div class="custom-controls-stacked d-block">
                    <label class="custom-control overflow-checkbox" >
                    <input type="checkbox"  name="sub_item" id="sub_item" value="1" class="overflow-control-input" <?php echo e(($item->subitem) ? 'checked="checked" ' : ''); ?>>
                    <span class="overflow-control-indicator"></span> <span class="overflow-control-description"> Is Product and Service</span> </label>
                </div> 
            </div>
        </div>
        

        
        
        <div class="col-md-3">
            <?php echo e(Form::textareaGroup('sales_information', trans('general.sales_information'), $item->sales_information)); ?>

        </div>
        <div class="col-md-3">
            <?php echo e(Form::radioGroup('enabled', trans('general.enabled'))); ?>

        </div>
    </div>
    <!-- /.box-body -->
    <div class="box-footer">
        <?php echo e(Form::saveButton('Update items/items')); ?>

    </div>
    <!-- /.box-footer -->
    
    <?php echo Form::close(); ?>


    <?php echo $__env->make('accounts/common/models/chartofaccount', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
<script  src="<?php echo e(asset('accounts/chartofaccounts/accounting.js')); ?>">  </script>
    <script type="text/javascript">
        var text_yes = '<?php echo e(trans('general.yes')); ?>';
        var text_no = '<?php echo e(trans('general.no')); ?>';
       

            $(window).on("load", function(){
               if($('#sub_item').is(':checked') == true){
                      $('#subitem').removeAttr('disabled');
                }
            });
        $(document).ready(function(){



             $("#sub_item").change(function() {
                if(this.checked) {
                  $('#subitem').removeAttr('disabled'); 
                } 
                else{
                   $('#subitem').attr('disabled','disabled');
                }    
                $('#subitem').selectpicker('refresh');
            });
        });

    $(document).on('click', '#button-account-create', function (e) { 
     $('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');    
        $.ajax({
            url: '<?php echo e(url("accounting/chartofaccounts_model_data")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-account-create").serialize(),
             
            success: function(data) {
                $('#span-loader').remove(); 

                $('#close-modal-create-account').trigger('click');
                $("#"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
                $("#"+ data.present_value_of_dropdown).selectpicker('refresh');

            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
                // $('#close-modal-create-account').trigger('click'); 

            }
        }); 
    }); 
        
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/items/items/edit.blade.php ENDPATH**/ ?>