<button class="btn btn-primary d-none" id="modalButton" data-toggle="modal" data-target="#modalDiv">Click Me</button>

<div class="modal fade" id="modalDiv" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
     <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add New Comment</h4>
                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="col-md-12 height-overflow" id="commentsDiv"></div>
                <div class="clearfix"></div>
                <div class="col-md-12">
                    <?php echo Form::hidden('consultant_id', '', ['id'=>'consultant_id']); ?>

                    <?php echo e(Form::textareaGroup('comment', 'Enter Comment', '', ['id'=>'comment'])); ?>

                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" type="button" onclick="saveComment()">Add</button>
                <button type="button" id="closeModal" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    /* Adding Comment To Employee */
function addComment(id) {
    $("#comment").val('');
    $("#consultant_id").val('');
    $("#consultant_id").val(id);
    $("#modalButton").trigger('click');
    
    /* Get Previous Comments */
    $.ajax({
        url: '/save_comments',
        data: { 'comment': '', 'consultant_id': id },
        success: function(result) {
            $("#commentsDiv").html('');
            $("#commentsDiv").append(result);
            $("#commentsDiv").animate({ scrollTop: $('#commentsDiv').prop("scrollHeight") }, 1000);
        }
    })
}

/* Saving Comment */
function saveComment() {
    var consultant_id = $("#consultant_id").val();
    var comment = $("#comment").val();
    if(comment!='') {
        $.ajax({
            url: '/save_comments',
            data: { 'comment': comment, 'consultant_id': consultant_id },
            success: function(result) {
                $("#comment").val('');
                $("#commentsDiv").html('');
                $("#commentsDiv").append(result);
                $("#commentsDiv").animate({ scrollTop: $('#commentsDiv').prop("scrollHeight") }, 1000);
            }
        });
    } else {
        swal({
            text: 'Please Enter Something in Comment Box',
            timer: 1000
        });
    }
}
</script><?php /**PATH C:\xampp\testing\resources\views/includes/new-comment.blade.php ENDPATH**/ ?>