<?php $__env->startSection('title', trans('general.title.edit', ['type' => trans_choice('general.bills', 1)])); ?>

<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('expenses/bills')); ?>" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.bills', 1) . ' List'); ?> </a>

<a href="<?php echo e(url('expenses/bills/'.$bill->id)); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">remove_red_eye</i>show</a>
<a href="<?php echo e(url('expenses/bills/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"  data-toggle="tooltip" title="Create Bills"><i class="material-icons left">add</i> <?php echo e(trans_choice('general.bills', 2)); ?></a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Default box -->
    <?php echo Form::model($bill, ['method' => 'PATCH', 'files' => true, 'url' => ['expenses/bills', $bill->id], 'role' => 'form']); ?>

    <div class="card">
        <div class="row">
            <div class="col-md-3">
                <?php echo e(Form::selectGroup('vendor_id', trans_choice('general.vendors', 1), $vendors, null, ['data-live-search'=>"true"])); ?>

            </div>

            <div class="col-md-3">
                <?php echo e(Form::textGroup('vendor_email', trans('general.email'), null, [])); ?>

            </div>

            <?php echo e(Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code'])); ?>


            <div class="col-lg-3 col-md-4 col-sm-6 required <?php echo e($errors->has('net_term') ? 'has-error' : ''); ?>">
                <div class="row">
                    <div class="col-md-10 pr-0">
                        <div class="add-cust">
                        <small><?php echo e(trans_choice('general.net_term', 1)); ?></small>
                        <?php echo Form::select('net_term', $terms, setting('general.default_netterm'), array_merge(['class' => 'selectpicker','id'=>'net_term','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])); ?>

                        <?php echo $errors->first('net_term', '<p class="help-block">:message</p>'); ?>

                        </div> 
                    </div> 
                    <div class="col-md-2 pl-0 pr-0">
                        <div class="add-bttn">
                         <button type="button" data-toggle="modal" data-target="#modal-create-term"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;padding:0px;">add </i></button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <?php echo e(Form::textGroup('billed_at', trans('invoices.invoice_date'), Date::parse($bill->billed_at)->format('Y-m-d'), ['id' => 'billed_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?> 
            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('due_at', 'Due at', Date::parse($bill->due_at)->format('Y-m-d'), ['id' => 'due_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

            </div>
            
            <div class="col-md-3">
                <?php echo e(Form::textGroup('bill_number', trans('bills.bill_number'), null)); ?>

            </div>
            
            <div class="col-md-3">
                <?php echo e(Form::textGroup('order_number', trans('bills.order_number'), null, [])); ?>

            </div>

            <div class=" col-md-12">
                <div class="form-groupTextArea ">
                <textarea class="form-ControlTextArea" placeholder="Enter Billing Address" rows="3" name="address" cols="50" id="address"><?php echo e($bill->vendor_address); ?></textarea>
                <label for="address" class="form-label"><?php echo e(trans('general.billingaddress')); ?></label>
                 <span class="form-controlBrd"></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <h3>Account Details</h3>
        <table class="table table-bordered tabl-input table-striped" id="account">
            <thead>
                <tr style="background-color: #f9f9f9;">
                    <th width="5%"><?php echo e(trans('general.actions')); ?></th>
                    <th width="30%"><?php echo e(trans_choice('general.accounting',1)); ?></th>
                    <th width="20%"><?php echo e(trans('general.description')); ?></th>
                    <th width="15%"><?php echo e(trans('general.quantity')); ?></th>
                    <th width="15%"><?php echo e(trans('bills.price')); ?></th>
                    <th width="15%"><?php echo e(trans('bills.total')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $account_row = 0; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $bill->account_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr id="account-row-<?php echo e($account_row); ?>">
                        <td width="5%">
                            <button type="button" onclick="$('#account-row-<?php echo e($account_row); ?>').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
                        </td>
                        <td width="30%">
                            <select onchange="nameofAccount(<?php echo e($account_row); ?>);addChartofAccount(event)" id="account-id-<?php echo e($account_row); ?>" class="selectpicker" data-live-search="true" name="account[<?php echo e($account_row); ?>][account_id]" tabindex="-1" aria-hidden="true">
                                <?php echo loopChartData($account_details_name , $prefix = '',$item->account_type_id); ?> 
                            </select>
                        
                            <input class="form-control"  name="account[<?php echo e($account_row); ?>][name]" value="<?php echo e($item->name); ?>" type="hidden" id="account-name-<?php echo e($account_row); ?>">

                        </td>

                        <td width="20%">
                            <div class="form-group"><input class="form-control " value="<?php echo e($item->description); ?>"  name="account[<?php echo e($account_row); ?>][description]" type="text" id="account-description-<?php echo e($account_row); ?>">
                                <label class="form-label"><?php echo e(trans('general.description')); ?></label>
                                <span class="form-controlBrd"></span>
                                </div>
                        </td>
                        <td width="15%">
                            <div class="form-group">
                                <input class="form-control quantity" required="required" name="account[<?php echo e($account_row); ?>][quantity]"
                                    type="text" id="account-quantity-<?php echo e($account_row); ?>" value="<?php echo e($item->quantity); ?>" min="1">
                                <label class="form-label">Quantity</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td width="15%">
                            <div class="form-group"><input value="<?php echo e($item->price); ?>" class="form-control" required="required" name="account[<?php echo e($account_row); ?>][price]" type="text" id="account-price-<?php echo e($account_row); ?>"><label class="form-label">Price</label>
                                <span class="form-controlBrd"></span>
                                </div>
                        </td>
                        <td width="25%">
                            <span id="account-total-<?php echo e($account_row); ?>">0</span>
                        </td>
                    </tr>
                    <?php $account_row++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?> 
                    <tr id="account-row-<?php echo e($account_row); ?>">
                        <td  style="vertical-align: middle;">
                            <button type="button" onclick="$('#account-row-<?php echo e($account_row); ?>').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
                        </td>
                        <td>
                            <select onchange="nameofAccount(<?php echo e($account_row); ?>);addChartofAccount(event)" id="account-id-<?php echo e($account_row); ?>" class="selectpicker" data-live-search="true" name="account[<?php echo e($account_row); ?>][account_id]" tabindex="-1" aria-hidden="true">
                                <?php echo Cache::get('account_details_option'); ?>

                            </select>

                                <input class="form-control"  name="account[<?php echo e($account_row); ?>][name]" type="hidden" id="account-name-<?php echo e($account_row); ?>">

                            <input class="form-control" name="account[<?php echo e($account_row); ?>][quantity]" type="hidden" value="1" id="account-quantity-<?php echo e($account_row); ?>">
                        </td>

                        <td>
                            <div class="form-group">
                            <input class="form-control "  name="account[<?php echo e($account_row); ?>][description]" type="text" id="account-description-<?php echo e($account_row); ?>">
                            <label class="form-label"><?php echo e(trans('general.description')); ?></label>
                            <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control quantity" required="required" name="account[<?php echo e($account_row); ?>][quantity]" type="text" id="account-quantity-<?php echo e($account_row); ?>" value="1" min="1">
                                <label class="form-label">Quantity</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                            <input class="form-control" required="required" name="account[<?php echo e($account_row); ?>][price]" type="text" id="account-price-<?php echo e($account_row); ?>">
                            <label class="form-label">Price</label>
                            <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        
                        <td style="vertical-align: middle;">
                            <span id="account-total-<?php echo e($account_row); ?>">0</span>
                        </td>
                    </tr>
                <?php endif; ?>
                <?php $account_row++; ?>
                <tr id="addAccount">
                    <td><button type="button" onclick="addAccount();" data-toggle="tooltip" title="<?php echo e(trans('general.add')); ?>" class="btn btn-xs  btn-outline-primary btn-circle-iconic btn34" data-original-title="<?php echo e(trans('general.add')); ?>"><i class="material-icons">add</i></button></td>
                    <td class="text-right" colspan="5"></td>
                </tr>
                    <tr>
                    <td class="text-right" colspan="5"><strong><?php echo e(trans('bills.sub_total')); ?></strong></td>
                    <td class="text-right"><span id="sub-total">0</span></td>
                </tr>
                
                <tr>
                    <td class="text-right" colspan="5"><strong><?php echo e(trans('bills.total')); ?></strong></td>
                    <td class="text-right"><span id="grand-total">0</span></td>
                </tr>
            </tbody>
        </table>
    </div>
        
        <!-- /.box-body -->
    <div class="col-md-12">
        <div class="col-md-6">
            <?php echo e(Form::fileGroup('attachment', trans('general.attachment'))); ?>

        </div>    
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
          <?php echo e(Form::textareaGroup('notes', trans_choice('general.notes', 2))); ?>

        </div>

        <div class="col-lg-3 col-md-3 col-sm-6 mrg-top-5">      
            <?php echo e(Form::saveButton('update expenses/bills')); ?>

        </div>
    </div>
    
    <!-- /.box-footer -->
    <?php echo Form::close(); ?>


<div class="modal fade" id="modal-create-term" >
  <div class="modal-dialog ">
      <div class="modal-content">
          <div class="modal-header">
              <h4 class="modal-title"><?php echo e(trans('general.title.new', ['type' => trans_choice('general.net_term', 1)])); ?></h4>
          </div>
          <div class="modal-body">
              <?php echo Form::open(['id' => 'form-create-term', 'role' => 'form']); ?>

              <div class="row">
                    <div class="col-md-6 "> 
                      <div class="form-group required">      
                            <input class="form-control" required name="name" type="text" id="name">
                            <label for="name" class="form-label"><?php echo e(trans('general.name')); ?></label>
                            <span class="form-controlBrd"></span>
                      </div>
                    </div>
                    <div class="col-md-6 required">
                        <div class="form-group ">
                            <input class="form-control" required name="term_daysplaceholder="day" type="text" id="term_days"> 
                            <label for="name" class="form-label">Due in fixed number of days</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
              </div>
              <?php echo Form::close(); ?>

          </div>
          <div class="modal-footer">
              <div class="pull-left">
               <button type="button" id="close-modal-create-term" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
              <?php echo Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-term', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

              </div>
          </div>
      </div>
  </div>
</div>
<?php echo $__env->make('accounts/common/models/chartofaccount', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div id='chart_dropdown' style="display: none">
    <?php echo Cache::get('account_details_option'); ?>

</div>
    
<script  src="<?php echo e(asset('accounts/chartofaccounts/accounting.js')); ?>">  </script>
<script type="text/javascript">

    var account_row = <?php echo e($account_row); ?>;

    function addAccount() {
        html  = '<tr id="account-row-' + account_row + '">';
        html += '  <td style="vertical-align: middle;">';
        html += '      <button type="button" onclick="$(\'#account-row-' + account_row + '\').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>';
        html += '  </td>';

        html += '  <td>';
        html += '      <select class="selectpicker" data-live-search="true" name="account[' + account_row + '][account_id]" id="account-id-' + account_row + '" onchange="nameofAccount(' + account_row + ');addChartofAccount(event)">'; 

        html += $('#chart_dropdown').html();
        
        html += '      </select>';

        html += ' <input class="form-control"  name="account['+ account_row +'][name]" type="hidden" id="account-name-'+ account_row +'">';
        html += '  </td>';

        html += '  <td>';
        html += '  <div class="form-group"><input class="form-control" required="required" name="account[' + account_row + '][description]" type="text" id="account-description-' + account_row + '"><label class="form-label"><?php echo e(trans('general.description')); ?></label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';
        html += ' <td>';
        html += '   <div class="form-group"><input class="form-control" name="account[' + account_row + '][quantity]" type="text" id="account-quantity-' + account_row + '" value="1" min="1" required><label class="form-label">Price</label> <span class="form-controlBrd"></span> </div>';
        html += ' </td>';
        html += '  <td>';
        html += '  <div class="form-group"><input class="form-control" required="required" name="account[' + account_row + '][price]" type="text" id="account-price-' + account_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';
        html += '  <td style="vertical-align: middle;">';
        html += '      <span id="account-total-' + account_row + '">0</span>';
        html += '  </td>';

        $('#account tbody #addAccount').before(html);
        $('#account-id-'+ account_row).selectpicker('refresh');

        account_row++;
    }

    var autocomplete_path = "<?php echo e(url('items/items/autocompletebill')); ?>";
    function autoItem (id){
        var item_id = $("#item-id-"+id).val();
        $.ajax({
            url: autocomplete_path,
            type: 'GET',
            dataType: 'JSON',
            data: 'query=' + item_id + '&type=bill&currency_code=' + $('#currency_code').val(),
            success: function(data) {
                $('#item-name-'+id).val(data.name);
                $('#item-quantity-' + id).val('1');
                $('#item-price-' + id).val(data.purchase_price);
                
                $('#item-chartid-' +id).val(data.expense_account);



                $('#item-total-' + id).html(data.total);

                totalItem();
            }
        });
    }

    $(document).ready(function(){
        totalItem();

        //Date picker
        $('#billed_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
		$('#billed_at').datepicker({
			format: 'yyyy-mm-dd',
			todayHighlight: true,
			clearBtn: true
		});

		$('#due_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
		$('#due_at').datepicker({
			format: 'yyyy-mm-dd',
			todayHighlight: true,
			clearBtn: true,
			minDate: $('#billed_at').val(),
		});


        

        <?php if($bill->attachment): ?>
            attachment_html  = '<span class="attachment">';
            attachment_html += '    <a href="<?php echo e(url('uploads/' . $bill->attachment->id . '/download')); ?>">';
            attachment_html += '        <span id="download-attachment" class="text-primary">';
            attachment_html += '            <i class="fa fa-file-<?php echo e($bill->attachment->aggregate_type); ?>-o"></i> <?php echo e($bill->attachment->basename); ?>';
            attachment_html += '        </span>';
            attachment_html += '    </a>';
            attachment_html += '    <?php echo Form::open(['id' => 'attachment-' . $bill->attachment->id, 'method' => 'DELETE', 'url' => [url('uploads/' . $bill->attachment->id)], 'style' => 'display:inline']); ?>';
            attachment_html += '    <a id="remove-attachment" href="javascript:void();">';
            attachment_html += '        <span class="text-danger"><i class="fa fa fa-times"></i></span>';
            attachment_html += '    </a>';
            attachment_html += '    <?php echo Form::close(); ?>';
            attachment_html += '</span>';

            $('.fancy-file .fake-file').append(attachment_html);

            $(document).on('click', '#remove-attachment', function (e) {
                confirmDelete("#attachment-<?php echo $bill->attachment->id; ?>", "<?php echo trans('general.attachment'); ?>", "<?php echo trans('general.delete_confirm', ['name' => '<strong>' . $bill->attachment->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]); ?>", "<?php echo trans('general.cancel'); ?>", "<?php echo trans('general.delete'); ?>");
            });
        <?php endif; ?>
        /*Accounts Event*/
        $(document).on('change', '#currency_code, #account tbody select', function(){
            totalItem();
        });

        $(document).on('keyup', '#account tbody .form-control', function(){
            totalItem();
        });
        /*Item Event*/
        $(document).on('change', '#currency_code, #items tbody select', function(){
            totalItem();
        });

        $(document).on('keyup', '#items tbody .form-control', function(){
            totalItem();
        });

        $(document).on('change', '#vendor_id', function (e) {
            $.ajax({
                url: '<?php echo e(url("expenses/vendors/currency")); ?>',
                type: 'GET',
                dataType: 'JSON',
                data: 'vendor_id=' + $(this).val(),
                success: function(data) {
                    $('#currency_code').val('USD');

                    // This event Select2 Stylesheet
                    $('#currency_code').trigger('change');
                }
            });
        });
    });

    function totalItem() {
        $.ajax({
            url: '<?php echo e(url("items/items/totalBillamount")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $('#currency_code, #items input[type=\'text\'],#items input[type=\'hidden\'], #items textarea, #items select,#account input[type=\'text\'],#account input[type=\'hidden\'], #account textarea, #account select'),
            headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
            success: function(data) {
                if (data) {
                    $.each( data.items, function( key, value ) {
                        $('#item-total-' + key).html(value);
                    });
                    $.each( data.account, function( key, value ) {
                        $('#account-total-' + key).html(value);
                    });

                    $('#sub-total').html(data.sub_total);
                    
                    $('#grand-total').html(data.grand_total);
                }
            }
        });
    }
        function nameofAccount( id ){
        $('#account-price-'+id).prop('required',true);
        var account_id = $('#account-id-'+id +' option:selected').text();
        $('#account-name-'+id).val(account_id.split("---")[0]);
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/bills/edit.blade.php ENDPATH**/ ?>