<?php $__env->startSection('title', trans_choice('general.invoices', 1) . ': ' . $invoice->invoice_number); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('incomes/invoices ')); ?> " class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.invoices', 1) . ' List'); ?> </a>

<a href="<?php echo e(url('incomes/invoices/' . $invoice->id .'/edit')); ?>"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">edit</i>Edit</a>
<a href="<?php echo e(url('incomes/invoices/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Invoices"><i class="material-icons left">add</i> <?php echo e(trans_choice('general.invoices', 2)); ?></a>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    .invoice-logo{height:50px;}
    .invoice{padding:15px;}
    .invoice-company{padding-top:10px;}
    .table th{padding:1rem !important;}
    </style>
    <div class="card">
        <section class="invoice">
            <span class="badge <?php echo e($invoice->status->label); ?> "><?php echo e($invoice->status->name); ?></span>

            <div class="row">
                <div class="col-md-6">
                    <div class="invoice-header">
                    <?php if(setting('general.invoice_logo')): ?>
                        <img src="<?php echo e(Storage::url(setting('general.invoice_logo'))); ?>" class="invoice-logo" />
                    <?php elseif(setting('general.company_logo')): ?>
                        <img src="<?php echo e(Storage::url(setting('general.company_logo'))); ?>" class="invoice-logo" />
                    <?php else: ?>
                      
                    <?php endif; ?>
                </div>
                <div class=" invoice-company">
                    <address>
                        <strong><?php echo e(setting('general.company_name')); ?></strong><br>
                        <?php echo nl2br(setting('general.company_address')); ?><br>
                        <?php if(setting('general.company_phone')): ?>
                        <?php echo e(setting('general.company_phone')); ?><br>
                        <?php endif; ?>
                        <?php echo e(setting('general.company_email')); ?>

                    </address>
                </div>
            </div>
                <div class="col-md-6">
                     <div class="">
                        <table class="table no-border table-striped">
                            <tbody>
                                <tr>
                                    <th><?php echo e(trans('invoices.invoice_number')); ?>:</th>
                                    <td class="text-right"><?php echo e($invoice->invoice_number); ?></td>
                                </tr>
                                <?php if($invoice->order_number): ?>
                                <tr>
                                    <th><?php echo e(trans('invoices.order_number')); ?>:</th>
                                    <td class="text-right"><?php echo e($invoice->order_number); ?></td>
                                </tr>
                                <?php endif; ?>
                                <tr>
                                    <th><?php echo e(trans('invoices.invoice_date')); ?>:</th>
                                    <td class="text-right"><?php echo e(Date::parse($invoice->invoiced_at)->format($date_format)); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo e(trans('invoices.payment_due')); ?>:</th>
                                    <td class="text-right"><?php echo e(Date::parse($invoice->due_at)->format($date_format)); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                </div>
            </div>
          
            <div class="row">
                
                <div class="col-md-6">
                   <?php echo e(trans('invoices.bill_to')); ?>

                    <address>
                        <strong><?php echo e(isset($invoice->customer->parent_re->name)?$invoice->customer->parent_re->name:$invoice->customer_name); ?></strong><br>
                        <?php echo isset($invoice->customer->parent_re->address)?nl2br($invoice->customer->parent_re->address):nl2br($invoice->customer_address); ?><br>   
                        <?php echo e(isset($invoice->customer->parent_re->phone)?$invoice->customer->parent_re->phone:$invoice->customer_phone); ?><br>  
                        <?php echo e(isset($invoice->customer->parent_re->customer_email)?$invoice->customer->parent_re->customer_email:$invoice->customer_email); ?>

                    </address>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <th><?php echo e(trans('general.description')); ?></th>
                                <th class="text-center"><?php echo e(trans('invoices.quantity')); ?></th>
                                <th class="text-right"><?php echo e(trans('invoices.price')); ?></th>
                                <th class="text-right"><?php echo e(trans('invoices.total')); ?></th>
                            </tr>
                            <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e(isset($item->description)?$item->description:$item->name); ?>

                                </td>
                                <td class="text-center"><?php echo e($item->quantity); ?></td>
                                <td class="text-right"><?php echo money($item->price, $invoice->currency_code, true); ?></td>
                                <td class="text-right"><?php echo money($item->total, $invoice->currency_code, true); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                <?php if($invoice->notes): ?>
                    <p class="lead"><?php echo e(trans_choice('general.notes', 2)); ?></p>

                    <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                        <?php echo e($invoice->notes); ?>

                    </p>
                <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <div class="">
                        <table class="table">
                            <tbody>
                                <?php $__currentLoopData = $invoice->totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($total->code != 'total'): ?>
                                    <tr>
                                        <th><?php echo e(trans($total['name'])); ?>:</th>
                                        <td class="text-right"><?php echo money($total->amount, $invoice->currency_code, true); ?></td>
                                    </tr>
                                <?php else: ?>
                                    <?php if($invoice->paid): ?>
                                        <tr class="text-success">
                                            <th><?php echo e(trans('invoices.paid')); ?>:</th>
                                            <td class="text-right">- <?php echo money($invoice->paid, $invoice->currency_code, true); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th><?php echo e(trans($total['name'])); ?>:</th>
                                        <td class="text-right"><?php echo money($total->amount - $invoice->paid, $invoice->currency_code, true); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="box-footer row no-print">
                <div class="col-md-12">
                    <a href="<?php echo e(url('incomes/invoices/' . $invoice->id . '/edit')); ?>" class="btn btn-primary">
                        <i class="fa fa-pencil-square-o"></i>&nbsp; <?php echo e(trans('general.edit')); ?>

                    </a>
                    <a href="<?php echo e(url('incomes/invoices/' . $invoice->id . '/print')); ?>"  class="btn btn-default">
                        <i class="fa fa-print"></i>&nbsp; <?php echo e(trans('general.print')); ?>

                    </a>
                    <div class="btn-group dropup">
                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-chevron-circle-up"></i>&nbsp; <?php echo e(trans('general.more_actions')); ?></button>
                        <ul class="dropdown-menu" role="menu">
                            <?php if($invoice->status->code != 'paid'): ?>
                           
                          
                            <?php if(empty($invoice->payments()->count()) || (!empty($invoice->payments()->count()) && $invoice->payments()->paid() != $invoice->amount)): ?>
                            <li><a href="<?php echo e(url('incomes/customers/receivepayment/'.$invoice->customer_id.'/'.$invoice->id)); ?>" ><?php echo e(trans('invoices.add_payment')); ?></a></li>
                            <?php endif; ?>
                           
                            <?php endif; ?>
                                                       
                            <?php if($invoice->customer_email): ?>
                            <li><a href="<?php echo e(url('incomes/invoices/' . $invoice->id . '/email')); ?>"><?php echo e(trans('invoices.send_mail')); ?></a></li>
                            <?php else: ?>
                            <li><a href="javascript:void(0);" class="green-tooltip disabled" data-toggle="tooltip" data-placement="right" title="<?php echo e(trans('invoices.messages.email_required')); ?>"><span class="text-disabled"><?php echo e(trans('invoices.send_mail')); ?></span></a></li>
                            <?php endif; ?>
                            
                            <li><a href="<?php echo e(url('incomes/invoices/' . $invoice->id . '/pdf')); ?>"><?php echo e(trans('invoices.download_pdf')); ?></a></li>
                            
                        </ul>
                    </div>

                    <?php if($invoice->attachment): ?>
                        <span class="attachment">
                            <a href="<?php echo e(url('uploads/' . $invoice->attachment->id . '/download')); ?>">
                                <span id="download-attachment" class="text-primary">
                                    <i class="fa fa-file-<?php echo e($invoice->attachment->aggregate_type); ?>-o"></i> <?php echo e($invoice->attachment->basename); ?>

                                </span>
                            </a>
                            <?php echo Form::open([
                                'id' => 'attachment-' . $invoice->attachment->id,
                                'method' => 'DELETE',
                                'url' => [url('uploads/' . $invoice->attachment->id)],
                                'style' => 'display:inline'
                            ]); ?>

                            <a id="remove-attachment" href="javascript:void();">
                                <span class="text-danger"><i class="fa fa fa-times"></i></span>
                            </a>
                            <?php echo Form::close(); ?>

                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="box box-default collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo e(trans('invoices.histories')); ?></h3>

                </div>
                <div class="">
                    <div class="">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th><?php echo e(trans('general.created_date')); ?></th>
                                <th><?php echo e(trans_choice('general.statuses', 1)); ?></th>
                                <th><?php echo e(trans('general.description')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $invoice->histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(Date::parse($history->created_at)->format($date_format)); ?></td>
                                    <td><?php echo e($history->status->name); ?></td>
                                    <td><?php echo e($history->description); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="box box-default collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo e(trans('invoices.payments')); ?></h3>

                    <!-- <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
                    </div> -->
                    <!-- /.box-tools -->
                </div>
                <div class="">
                    <div class="">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th><?php echo e(trans('general.payment_date')); ?></th>
                                <th><?php echo e(trans('general.amount')); ?></th>
                                <th><?php echo e(trans_choice('general.accounts', 1)); ?></th>
                                <th><?php echo e(trans('general.actions')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $invoice->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(Date::parse($payment->paid_at)->format($date_format)); ?></td>
                                    <td><?php echo money($payment->amount, $payment->currency_code, true); ?></td>
                                    <td><?php echo e(isset($payment->account->name_number)?$payment->account->name_number:'Credit Memo'); ?></td>
                                    <td>
                                        
                                        <?php echo e(Form::deleteLinkA($payment,'incomes/invoices/payment','Payments')); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function(){
            
            $(document).on('click', '#button-email', function (e) {
                $('#email-modal').remove();

                var html = '<div class="modal fade" id="email-modal" tabindex="-1" role="dialog" aria-labelledby="emailModalLabel">';
                html += '   <div class="modal-dialog" role="document">';
                html += '       <div class="modal-content">';
                html += '           <div class="modal-header">';
                html += '               <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                html += '               <h4 class="modal-title" id="emailModalLabel">Overflowing text</h4>';
                html += '           </div>';
                html += '           <div class="modal-body">';
                html += '              <?php echo e(trans('general.na')); ?>';
                html += '           </div>';
                html += '           <div class="modal-footer">';
                html += '               <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('general.cancel')); ?></button>';
                html += '               <button type="button" class="btn btn-success">Save changes</button>';
                html += '           </div>';
                html += '       </div>';
                html += '   </div>';
                html += '</div>';

                $('body').append(html);

                $('#email-modal').modal('show');
            });
            <?php if($invoice->attachment): ?>
            $(document).on('click', '#remove-attachment', function (e) {
                confirmDelete("#attachment-<?php echo $invoice->attachment->id; ?>", "<?php echo trans('general.attachment'); ?>", "<?php echo trans('general.delete_confirm', ['name' => '<strong>' . $invoice->attachment->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]); ?>", "<?php echo trans('general.cancel'); ?>", "<?php echo trans('general.delete'); ?>");
            });
            <?php endif; ?>
        });

        function addPayment() {
            $('.help-block').remove();

            $.ajax({
                url: '<?php echo e(url("incomes/invoices/payment")); ?>',
                type: 'POST',
                dataType: 'JSON',
                data: $('#payment-modal input[type=\'text\'], #payment-modal input[type=\'hidden\'], #payment-modal textarea, #payment-modal select'),
                headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                beforeSend: function() {
                    $('#payment-modal .modal-content').append('<div id="loading" class="text-center"><i class="fa fa-spinner fa-spin fa-5x checkout-spin"></i></div>');
                },
                complete: function() {
                    $('#loading').remove();
                },
                success: function(json) {
                    if (json['error']) {
                        $('#payment-modal .modal-message').append('<div class="alert alert-danger">' + json['message'] + '</div>');
                        $('div.alert-danger').delay(1000).fadeOut(350);
                    }

                    if (json['success']) {
                        $('#payment-modal .modal-message').before('<div class="alert alert-success">' + json['message'] + '</div>');
                        $('div.alert-success').delay(3000).fadeOut(350);

                        setTimeout(function(){
                            $("#payment-modal").modal('hide');

                            location.reload();
                        }, 3000);
                    }
                },
                error: function(data){
                    var errors = data.responseJSON;

                    if (typeof errors !== 'undefined') {
                        if (errors.paid_at) {
                            $('#payment-modal #paid_at').parent().after('<p class="help-block">' + errors.paid_at + '</p>');
                        }

                        if (errors.amount) {
                            $('#payment-modal #amount').parent().after('<p class="help-block">' + errors.amount + '</p>');
                        }

                        if (errors.account_id) {
                            $('#payment-modal #account_id').parent().after('<p class="help-block">' + errors.account_id + '</p>');
                        }

                        if (errors.currency_code) {
                            $('#payment-modal #currency_code').parent().after('<p class="help-block">' + errors.currency_code + '</p>');
                        }

                        if (errors.category_id) {
                            $('#payment-modal #category_id').parent().after('<p class="help-block">' + errors.category_id + '</p>');
                        }

                        if (errors.payment_method) {
                            $('#payment-modal #payment_method').parent().after('<p class="help-block">' + errors.payment_method + '</p>');
                        }
                    }
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/incomes/invoices/show.blade.php ENDPATH**/ ?>