<?php $__env->startSection('title', trans('general.title.edit', ['type' => trans_choice('general.reconciliations', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('banking/reconcile')); ?>" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.reconciliations', 1) . ' List'); ?> </a>
<a href="<?php echo e(route('reconcile.create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Reconcile"><i class="material-icons left">add</i><?php echo e(trans_choice('general.reconciliations', 1)); ?></a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.transactions', 2)); ?></h3>
        </div>
        <div class="">
            <?php echo Form::model($reconcile, [
                'method' => 'PATCH',
                'url' => ['banking/reconcile', $reconcile->id],
                'role' => 'form',
                'id' => 'form-reconciliations',
                'class' => 'form-loading-button'
            ]); ?>


            <?php echo e(Form::hidden('account_id', $account->id)); ?>

            <?php echo e(Form::hidden('currency_code', $currency->code, ['id' => 'currency_code'])); ?>

            <?php echo e(Form::hidden('opening_balance', $opening_balance, ['id' => 'opening_balance'])); ?>

            <?php echo e(Form::hidden('closing_balance', $reconcile->closing_balance, ['id' => 'closing_balance'])); ?>

            <?php echo e(Form::hidden('started_at', $reconcile->started_at)); ?>

            <?php echo e(Form::hidden('ended_at', $reconcile->ended_at)); ?>

            <?php echo e(Form::hidden('reconcile', $reconcile->reconcile, ['id' => 'hidden-reconcile'])); ?>

            <div class="">
                <table class="table table-striped table-bordered" id="tbl-transactions">
                    
                    <thead >
                    <tr>
                        <th ><?php echo e(trans('general.date')); ?></th>
                        <th ><?php echo e(trans('general.description')); ?></th>
                        <th ><?php echo e(trans('general.name')); ?></th>
                        <th ><?php echo e(trans('general.memo')); ?></th>
                        <th ><?php echo e(trans_choice('general.type', 1)); ?></th>
                        <th ><?php echo e(trans_choice('general.deposits', 1)); ?></th>
                        <th ><?php echo e(trans_choice('general.withdrawals', 1)); ?></th>
                        <th ><?php echo e(trans('general.clear')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(Date::parse($item->transaction_date)->format($date_format)); ?></td>
                            <td><?php echo e($item->description); ?></td>
                            <td><?php echo e($item->name); ?></td>
                            <td><?php echo e($item->number); ?></td>
                            <td><?php if(!empty($item->transaction_type)): ?> <?php echo e($item->transaction_type); ?> <?php else: ?> <?php echo e(trans('general.na')); ?><?php endif; ?></td>
                            <?php if($item->amount_type ==  'add'): ?>
                                <td><?php echo money($item->amount, $item->currency_code, true); ?></td>
                                <td>&nbsp;</td>
                            <?php else: ?>
                                <td>&nbsp;</td>
                                <td><?php echo money($item->amount, $item->currency_code, true); ?></td>
                            <?php endif; ?>
                            <td>
                                <div class="custom-controls-stacked d-block">
                                    <label class="custom-control overflow-checkbox"><?php echo e(Form::checkbox('transactions['. $item->id . '_'. $item->amount_type . ']', $item->amount, $item->reconciled,['class'=>'overflow-control-input'])); ?><span class="overflow-control-indicator"></span>  </label> 
                                
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php if($transactions->count()): ?>
                    <table class="table">
                        <tbody>
                        <tr>
                            
                            <td  class="col-md-1 text-right"><?php echo e(trans('reconciliations.closing_balance')); ?>:</td>

                            <td id="closing-balance" class="col-md-1 text-right"><?php echo money($reconcile->closing_balance, $account->currency_code, true); ?></td>
                        </tr>
                        <tr>
                           
                            <td  class="col-md-1 text-right"><?php echo e(trans('reconciliations.cleared_amount')); ?>:</td>
                            <td id="cleared-amount" class="col-md-1 text-right"><?php echo money('0', $account->currency_code, true); ?></td>
                        </tr>
                        <tr>
                            
                            <td  class="col-md-1 text-right"><?php echo e(trans('general.difference')); ?>:</td>
                            <td id="difference" class="col-md-1 text-right"><?php echo money('0', $account->currency_code, true); ?></td>
                        </tr>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
        <div class="text-right">
            <?php if($transactions->count()): ?>
                <div class="form-group no-margin">
                    <?php echo Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-default button-submit', 'data-loading-text' => trans('general.loading')]); ?>

                    <?php echo Form::button('<span class="fa fa-check"></span> &nbsp;' . trans('reconciliations.reconcile'), ['type' => 'button', 'id' => 'button-reconcile', 'class' => 'btn btn-primary button-submit', 'data-loading-text' => trans('general.loading'), 'disabled' => 'disabled']); ?>

                    <a href="<?php echo e(route('reconcile.index')); ?>" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></a>
                </div>
            <?php else: ?>
                <?php echo e(trans('general.no_records')); ?>

            <?php endif; ?>
        </div>
        <?php echo Form::close(); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function(){
        $('#tbl-transactions input[type="checkbox"]').trigger('change');
    });

    $(document).on('change', '#tbl-transactions input[type="checkbox"]', function (e) {
        $.ajax({
            url: '<?php echo e(url("/banking/reconcile/calculate")); ?>',
            type: 'GET',
            dataType: 'JSON',
            data: $('#form-reconciliations').serialize(),
            headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
            success: function(data) {
                if (data) {
                    if (data.difference_raw != 0)  {
                        $('#button-reconcile').attr('disabled','disabled');
                        $('#difference').css('background-color', '#f2dede');
                    } else {
                        $('#button-reconcile').removeAttr('disabled');
                        $('#difference').css('background-color', '#d0e9c6');
                    }

                    $('#closing-balance').html(data.closing_balance);
                    $('#cleared-amount').html(data.cleared_amount);
                    $('#difference').html(data.difference);
                }
            }
        });
    });

    $(document).on('click', '#button-reconcile', function (e) {
        $('#hidden-reconcile').val(1);

        $('#form-reconciliations').submit();
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/banking/reconcile/edit.blade.php ENDPATH**/ ?>