
<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('includes.headers.consultants', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row mb-3">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="title_left">
            <h2> <strong> Welcome</strong> <?php echo e(ucwords($consultant->name)); ?> Profile</h2>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="row" style="border-bottom: solid blue 1px; font-size: 22px;">
                    <div class="col-md-7 col-lg-7 col-sm-12"><b><?php echo e(ucwords($consultant->name)); ?></b></div>
                    <div class="col-md-5 col-lg-5 col-sm-12 text-right">Golars ID:- <b>GNS-<?php echo e($consultant->id); ?></b></div>
                </div>

                <div class="row pt-3">
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <img class="profilePic-Image" src="/public/profile_images/dummy.png" alt="Avatar"
                                    title="Click to change the Avatar" style="border-radius: 50%; width: 100%; height: 100%;">
                            </div>
                            <div class="col-lg-9 col-md-9 col-sm-12">
                                <div class="row"> <label class="col-sm-4"><b>Name:- </b></label>  <?php echo e(ucwords($consultant->name)); ?> </div>
                                <div class="row"> <label class="col-sm-4"><b>Email:- </b></label>  <?php echo e($consultant->email); ?> </div>
                                <div class="row"> <label class="col-sm-4"><b>Phone:- </b></label>  <?php echo e($consultant->mobile); ?> </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="mb-5">
    <div class="pmd-tabs pmd-tabs-bg horizantTabs">
        <ul id="horizontalTabs" class="nav nav-tabs " role="tablist">
            <li class="nav-item ">
                <a class="nav-link waves-effect waves-gray active show" href="#tab_content" id="profile-tab" role="tab"
                    data-toggle="tab" aria-expanded="true">Personal Details</a>
            </li>
            <li class="nav-item">
                <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#tab_content1" id="recruiter-tab"
                    role="tab" data-toggle="tab" aria-expanded="false">Recruiter Details</a>
            </li>
            <li class="nav-item">
                <a class="nav-link waves-effect waves-gray" href="#tab_content4" id="cer-tab" role="tab"
                    data-toggle="tab" aria-expanded="false">Certification</a>
            </li>
        </ul>
    </div>
    <div class="pmd-card-body horizantTabsBodyContainer">
        <div class="tab-content">
            <!-- start personal details -->
            <div id="tab_content" role="tabpanel" class="tab-pane active" aria-labelledby="profile-tab">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Mobile</label>
                            <div class="font15"> <?php echo e($consultant->mobile); ?></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">E-Mail</label>
                            <div class="font15"><?php echo e($consultant->email); ?></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Date Of Birth</label>
                            <div class="font15"> <?php echo e(Date::parse($consultant->date_of_birth)->format(env('APP_DATE'))); ?>

                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Visa Status</label>
                            <div class="font15">
                                <?php echo e(ucwords(isset($consultant->visa_status)?$visas[$consultant->visa_status]:'-')); ?></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Address</label>
                            <div class="font15"><?php echo e(ucwords($consultant?->address)); ?>

                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Batch</label>
                            <div class="font15"><?php echo e($consultant->name); ?></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Status</label>
                            <div class="font15"><?php echo e(ucwords($statuses[$consultant->status])); ?></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Technologies</label>
                            <div class="font15"><?php if($technologies): ?>
                                <?php $__currentLoopData = $consultant->technologies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $technology): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-sm-7 col-xs-6">
                                    <?php echo e($technology->name); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end personal details -->
            <!-- start recruiter activity -->
            <div id="tab_content1" role="tabpanel" class="tab-pane" aria-labelledby="recruiter-tab"
                style="margin-top: 12px">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Recruiter Name</label>
                            <div class="font15"><?php echo e(ucwords($consultant->creater?->name)); ?> </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Recruiter Mobile</label>
                            <div class="font15"><?php echo e($consultant->creater?->mobile); ?> </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group pb-0">
                            <label class="text-themeGray">Recruiter E-Mail</label>
                            <div class="font15"><?php echo e($consultant->creater?->email); ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end recruiter activity -->
            <!--Certification Details -->
            <div role="tabpanel" class="tab-pane col-md-12 col-sm-12 col-xs-12 "
                style="margin-top: 12px;max-height: 500px;overflow: auto" id="tab_content4" aria-labelledby="cer-tab">
                <div class="table-responsive">
                    <table
                        class="table table-striped table-bordered dt-responsive nowrap datatable-responsive jambo_table"
                        cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Name</th>
                                <th>Certification Id</th>
                                <th>Validity</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($consultant->certificates) > 0 && isset($consultant->certificates)): ?>
                                <?php $__currentLoopData = $consultant->certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr style="text-align: center">
                                    <td><?php echo e($k+1); ?></td>
                                    <td><?php echo e($certificate->name); ?></td>
                                    <td><?php echo e($certificate->certificate_id); ?></td>
                                    <td><?php echo e(Date::parse($certificate->validity)->format(env('APP_DATE'))); ?></td>
                                    <td><?php echo e(ucwords($certificate->status)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- end skills  -->
            <!-- Certification Details End-->
        </div>
    </div>
</div>

<?php echo e(Form::hidden('consultant_id', $consultant->id, ['id'=>'consultant_id'])); ?>

<div class="card">
    <div>
        <div class="fixed_height_320">
            <div class="">
                <h2> Comments</h2>
                <div class="clearfix"></div>
            </div>

            <div class="message" id="cmnt_div" style="height:320px !important; overflow-y: auto; "></div>

            <div class="">
                <div class="input-group">
                    <input type="hidden" id="consultant_id" name="consultant_id" value="<?php echo e($consultant->id); ?>">
                    <?php if(auth()->check() && auth()->user()->hasRole('student')): ?>
                    <div class="form-group">
                        <input id="comment" type="text" class="form-control "
                            placeholder="Type your Comments here..." />
                        <span class="form-controlBrd"></span>
                        <div class="help-block with-errors"></div>
                    </div>
                    <div>
                        <button class="btn btn-primary " id="btn-cmnt" onclick="add_comment()">
                            Add Comment</button>
                    </div>
                    <?php else: ?>
                    <div class="form-group">
                        <input type="text" class="form-control" id="comment" required="">
                        <label class="form-label">Type your Comments here</label>
                        <span class="form-controlBrd"></span>
                        <div class="help-block with-errors"></div>
                    </div>

                    <div>
                        <button class="btn btn-primary " id="btn-cmnt" onclick="add_comment()">
                            Add Comment</button>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- recruiter comments end -->

<script>
    $(document).ready(function(){
        return refresh();
    });

     function add_comment(){
        consultant_id = $('#consultant_id').val();
        comment = $('#comment').val();
        $.ajax({
            url : '/save_comments',
            data :{ 'comment': comment , 'consultant_id': consultant_id},
            success : function(result){
                $('#cmnt_div').html(result);
                $('#comment').val('');
                $(".message").scrollTop($(".message")[0].scrollHeight);
            }
        });
    };

    /*Callable Function*/
    function refresh(){
        consultant_id = $('#consultant_id').val();
        $.ajax({
            url : '/save_comments',
            data : 'comment='+'&consultant_id='+consultant_id,
            success : function(result){
                $('#cmnt_div').html(result);
                $(".message").scrollTop($(".message")[0].scrollHeight);
            }
        });
    };

    $("#comment").on('keydown', function (e) {
        if (e.keyCode == 13) {
              consultant_id = $('#consultant_id').val();
              comment = $('#comment').val();
            $.ajax({
               url : '/save_comments',
            data :{ 'comment': comment , 'consultant_id': consultant_id},
                success : function(result){
                     $('#cmnt_div').html(result);
                     $('#comment').val('');
                     return refresh();
                }
            });
        }
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/consultants/show.blade.php ENDPATH**/ ?>