

<?php $__env->startSection('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.customerbalancesummary')])); ?>

<?php $__env->startSection('new_button'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  
<div class="box box-primary">
  <div class="card">
  <div class="box-header">
   
      <?php echo Form::open(['url'=>'/reports/standard/customer-balance-summary']); ?>

      <?php echo $__env->make('accounts.reports.standard.date-filter-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <?php echo Form::close(); ?>

    </div>
  </div>
  <div class="box-body">
      <div class="col-md-12">
        <h3 class="text-center">ASAS <strong><?php echo e(trans('reports.standard.customerbalancesummary')); ?></strong></h3>
       
      </div>

      <div class="">
          <table class="table  table-hover" id="tbl-customers">
              <thead>
                  <tr>
                      <th class="col-md-2"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('name', trans('general.name')));?></th>
                      <th class="col-md-1"><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('blance', trans_choice('general.balance',2)));?></th>
                  </tr>
              </thead>
              <tbody>  

                <?php echo e(Tree($items)); ?>


                <?php 
                  $gtotal = 0;
                    function Tree($elements, $prefix = 10) {
                      global $gtotal;
                      
                        foreach ($elements as $k=> $element) { 
                              $total_amount = 0;
                              $paid_amount = 0;

                              if( count($element['invoices_total']) > 0){
                                $invoice_amount = ($element['invoices_total'])[0]['total_amount'];
                                $paid_amount    =  isset(($element['payments_total'])[0])?($element['payments_total'])[0]['paid_amount']:0;
                                $total_amount = $invoice_amount - $paid_amount ;
                                $gtotal = $gtotal + $total_amount ;
                              }
                ?>
                              <tr>
                                <td  style = "padding-left:<?php echo e($prefix); ?>px" >
                                  <a href="<?php echo e(url('incomes/customers/' . $element['id'])); ?>">
                                  <?php echo e($element['name']); ?> </a>
                                    
                                </td>
                                <td><?php echo money((($total_amount != '')?$total_amount:0), $element['currency_code'], true); ?></td>
                              </tr>

                              <?php if(isset($element['children'])): ?>
                                  <?php 
                                    Tree($element['children'], $prefix+20 );  
                                  ?>
                              <?php endif; ?>
                        
                              <?php if($element['parent_id'] == NULL): ?>
                                <tr style="font-weight: bold;">
                                  <td>Total <?php echo e($element['name']); ?></td>
                                  <td><?php echo money((($gtotal != '')?$gtotal:0), $element['currency_code'], true); ?></td>
                                </tr>
                                <?php
                                  $gtotal = 0;
                                ?>
                              <?php endif; ?>
                <?php  
                        } 

                    }
                ?>
              </tbody>
          </table>
      </div>
  </div>
</div>
  
<?php echo $__env->make('accounts.reports.standard.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/reports/standard/owes/customer-balance-summary.blade.php ENDPATH**/ ?>