

<?php $__env->startSection('title', trans_choice('general.cheques', 1) . ': ' . $cheque->cheque_number); ?>
<style>
    .cheque{padding:20px;}
     .table th{padding:1rem !important;}
</style>
<?php $__env->startSection('content'); ?>
<div class="card">
    <section class="cheque">
        <div class="row invoice-header">
            <div class="col-md-6">
                <?php if($logo): ?>
                    <img src="<?php echo e($logo); ?>" class="invoice-logo" />
                <?php endif; ?>
          
            <div class="invoice-company">
                <address>
                    <strong><?php echo e(setting('general.company_name')); ?></strong><br>
                    <?php echo nl2br(setting('general.company_address')); ?><br>
                    <?php if(setting('general.company_tax_number')): ?>
                        <?php echo e(trans('general.tax_number')); ?>: <?php echo e(setting('general.company_tax_number')); ?><br>
                    <?php endif; ?>
                    <br>
                    <?php if(setting('general.company_phone')): ?>
                        <?php echo e(setting('general.company_phone')); ?><br>
                    <?php endif; ?>
                    <?php echo e(setting('general.company_email')); ?>

                </address>
            </div>
        </div>
        <div class="col-md-6">
            <div class="">
                    <table class="table no-border">
                        <tbody>
                        <tr>
                            <th><?php echo e(trans('cheques.cheque_number')); ?>:</th>
                            <td><?php echo e($cheque->cheque_number); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(trans('cheques.paid_date')); ?>:</th>
                            <td><?php echo e(Date::parse($cheque->paid_at)->format($date_format)); ?></td>
                        </tr>
                        
                        </tbody>
                    </table>
                </div>
        </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <?php echo e(trans('cheques.cheque_from')); ?>

                <address>
                    <strong><?php echo e($cheque->vendor_name); ?></strong><br>
                    <?php echo nl2br($cheque->vendor_address); ?><br>
                    <?php if($cheque->vendor_tax_number): ?>
                        <?php echo e(trans('general.tax_number')); ?>: <?php echo e($cheque->vendor_tax_number); ?><br>
                    <?php endif; ?>
                    <br>
                    <?php if($cheque->vendor_phone): ?>
                        <?php echo e($cheque->vendor_phone); ?><br>
                    <?php endif; ?>
                    <?php echo e($cheque->vendor_email); ?>

                </address>
            </div>
            <div class="col-md-6">
                
            </div>
        </div>
        <div class="row">
            <div class="">
                <table class="table table-striped">
                    <tbody>
                    <tr>
                        <th><?php echo e(trans_choice('accounting.accountdetails', 1)); ?></th>
                        <th><?php echo e(trans_choice('general.description', 1)); ?></th>
                        <th><?php echo e(trans('bills.price')); ?></th>
                        <th><?php echo e(trans('bills.total')); ?></th>
                    </tr>
                    <?php $__currentLoopData = $cheque->account_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                             <td>
                                    <?php echo e($item->name); ?>

                                </td>

                                 <td>
                                    <?php echo e(isset($item->description)?$item->description:'-'); ?>

                                </td>
                                <td><?php echo money($item->price, $cheque->currency_code, true); ?></td>
                                <td><?php echo money($item->total, $cheque->currency_code, true); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <?php if($cheque->notes): ?>
                    <p class="lead"><?php echo e(trans_choice('general.notes', 2)); ?>:</p>

                    <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                        <?php echo e($cheque->notes); ?>

                    </p>
                <?php endif; ?>
            </div>
            <div class="col-md-6">
                <div class="">
                    <table class="table">
                        <tbody>
                        <?php $__currentLoopData = $cheque->totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($total->code != 'total'): ?>
                                <tr>
                                    <th><?php echo e(trans($total['name'])); ?>:</th>
                                    <td class="text-right"><?php echo money($total->amount, $cheque->currency_code, true); ?></td>
                                </tr>
                            <?php else: ?>
                                <?php if($cheque->paid): ?>
                                    <tr class="text-success">
                                        <th><?php echo e(trans('invoices.paid')); ?>:</th>
                                        <td class="text-right">- <?php echo money($cheque->paid, $cheque->currency_code, true); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <tr>
                                    <th><?php echo e(trans($total['name'])); ?>:</th>
                                    <td class="text-right"><?php echo money($total->amount - $cheque->paid, $cheque->currency_code, true); ?></td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounts.layouts.cheque', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/cheques/cheque.blade.php ENDPATH**/ ?>