
<?php $__env->startSection('title', 'New Transfer'); ?>

<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('banking/transfers')); ?>"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>Transfer List</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Default box -->
    <div class="card">
        <?php echo Form::open(['url' => 'banking/transfers', 'role' => 'form' ,'id'=> 'form']); ?>


        <?php echo e(Form::hidden('from_account_chart_id',null,['id'=>'from_account_chart_id'])); ?>

        <?php echo e(Form::hidden('to_account_chart_id',null,['id'=>'to_account_chart_id'])); ?>

        <div class="row">
            <div class="col-lg-3 col-md-3">
                <?php echo e(Form::selectGroup('from_account_id', 'From Account', $accounts, null, ['data-live-search'=>'true','required'=>'required'])); ?>   
            </div>
            <div class="col-lg-3 col-md-3">
                <?php echo e(Form::selectGroup('to_account_id', 'To Account', $accounts, null, ['data-live-search'=>'true','required'=>'required'])); ?>

            </div>
            <div class="col-lg-3 col-md-3">
                <?php echo e(Form::textGroup('amount', 'Amount', null, ['id'=>'amount','required' => 'required'])); ?> 
            </div>
            <div class="col-lg-3 col-md-3">
                <?php echo e(Form::textGroup('transferred_at', 'Transfer date', '', ['id' => 'transferred_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

            </div>
            <div class="col-lg-3 col-md-3">
                <?php echo e(Form::selectGroup('payment_method', 'Payment Method', $payment_methods, config('accounts.payment_method'), [])); ?>

            </div>
            <div class="col-lg-3 col-md-3">
                <?php echo e(Form::textGroup('reference', 'Reference Number', 'file-text-o', [])); ?>

            </div>
            <div class="col-lg-12 col-md-12">
                <?php echo e(Form::textareaGroup('description', 'Description')); ?>

            </div>
        </div>
        <!-- /.box-body -->

        <div class="box-footer">
            <?php echo e(Form::saveButton('Save')); ?>

        </div>
        <!-- /.box-footer -->

        <?php echo Form::close(); ?>

    </div>

<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    $(document).ready(function(){
        $('#from_account_id').on('change',function(){
            var from_account_id = $(this).val();
            var type = 'from_account_id';
            getChartid(from_account_id,from_account_id);
            getAccountBalance(from_account_id,type);
        });

        $('#to_account_id').on('change',function(){
            var to_account_id = $(this).val();
            var type = 'to_account_id';
            getChartid(to_account_id);
            getAccountBalance(to_account_id,type);
        });
        
        //Date picker
        $('#transferred_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#transferred_at').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
            clearBtn: true
        });
    });

    function getChartid(id , from_account_id){
        $.ajax({
            url  : '<?php echo e(url('banking/tranfers/chart_id/')); ?>'+'/'+id,
            type : 'GET',
            success : function(data){
                if(from_account_id){
                    $('#from_account_chart_id').val(data);
                }else{
                    $('#to_account_chart_id').val(data);
                }
            },
            error:function(data){
                console.log(data);
            }
        });
    }

    function getAccountBalance(account_id,type){
        $('#accountbalance').html(' ');
        $.ajax({
            url  : '<?php echo e(url('banking/accounts/accountbalance/')); ?>'+'/'+account_id,
            type : 'GET',
            success : function(data){
                $('#'+type+'_div').html('Balance: $' +data.amount);
            },
            error:function(data){
                console.log(data);
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/banking/transfers/create.blade.php ENDPATH**/ ?>