<?php $__env->startSection('title', trans('general.general')); ?>

<?php $__env->startSection('content'); ?>
   
    <?php echo Form::model($setting, [
            'method' => 'PATCH',
            'url' => ['settings/ac_settings'],
            'class' => 'setting-form',
            'files' => true,
            'role' => 'form'
        ]); ?>


        <?php echo e(Form::hidden('company_id', Session::get('company_id'))); ?>

        <div>
            <div class="pmd-tabs pmd-tabs-bg horizantTabs">
                <ul role="tablist" class="nav nav-tabs secondarySubMeu inner-submenu" id="myTab">
                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray active" data-toggle="tab" href="#company" role="tab">
                         <!--    <span class="hTabsIcon">
                                <i class="material-icons ">star</i></span>  -->
                               <?php echo e(trans_choice('general.companies', 1)); ?>

                        </a>
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#localisation" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                            Date Settings
                        </a> 
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#invoice" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                            <?php echo e(trans('settings.invoice.tab')); ?>

                        </a> 
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#default" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                            <?php echo e(trans('settings.default.tab')); ?>

                        </a> 
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#scheduling" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                           <?php echo e(trans('settings.scheduling.tab')); ?>

                        </a> 
                    </li>
                </ul>
            </div>
            <div class="pmd-card-body horizantTabsBodyContainer"> 
                <div class="tab-content">
                    <div class="tab-pane tab-margin active" id="company">
                        <div class="row">
                            <div class="col-md-4">
                                <?php echo e(Form::textGroup('company_name', trans('settings.company.name'),null)); ?>

                            </div>
                            <div class="col-md-4">
                                <?php echo e(Form::textGroup('company_email', trans('settings.company.email'), null)); ?>

                            </div>
                            <div class="col-md-4">
                                <?php echo e(Form::textGroup('company_phone', trans('settings.company.phone'), null, [])); ?>

                            </div>
                            <div class="col-md-12">
                                <?php echo e(Form::textareaGroup('company_address', trans('settings.company.address'), null)); ?>

                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin"  id="localisation">
                        <div class="row">
                            <div class="col-md-4">
                                <?php echo e(Form::selectGroup('date_format', trans('settings.localisation.date.format'), $date_formats, null, [])); ?>

                            </div>
                            <div class="col-md-4">
                                <?php echo e(Form::selectGroup('date_separator', trans('settings.localisation.date.separator'), $date_separators, null, [])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin" id="invoice">
                        <div class="row">
                            <div class="col-md-4">
                                <?php echo e(Form::textGroup('invoice_number_prefix', trans('settings.invoice.prefix'), null, [])); ?>

                            </div>
                            <div class="col-md-4">
                                <?php echo e(Form::textGroup('invoice_number_digit', trans('settings.invoice.digit'), null, [])); ?>

                            </div>
                            <div class="col-md-4">
                                <?php echo e(Form::textGroup('invoice_number_next', trans('settings.invoice.next'), null, [])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin" id="default">
                        <div class="row">
                            <div class="col-md-4">
                                <?php echo e(Form::selectGroup('default_account', trans('settings.default.account'), $accounts, null, [])); ?>

                            </div>
                            <div class="col-md-4">
                                <?php echo e(Form::selectGroup('default_currency', trans('settings.default.currency'), $currencies, null, [])); ?>

                            </div>
                            <div class="col-md-4">
                                <?php echo e(Form::selectGroup('default_payment_method', trans('settings.default.payment'), $payment_methods, setting('general.default_payment_method'), [])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin" id="scheduling">
                        <div class="row">
                            <div class="col-md-3">
                                <?php echo e(Form::radioGroup('send_invoice_reminder', trans('settings.scheduling.send_invoice'))); ?>

                            </div>
                            <div class="col-md-3">
                                <?php echo e(Form::textGroup('schedule_invoice_days', trans('settings.scheduling.invoice_days'), null)); ?>

                            </div>
                            <div class="col-md-3">
                                <?php echo e(Form::textGroup('schedule_time', trans('settings.scheduling.schedule_time'), null, [])); ?>

                            </div>
                            <div class="col-md-3">
                                <?php echo e(Form::textGroup('schedule_bill_days', trans('settings.scheduling.bill_days'), null, [])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="setting-buttons text-center">
                        <div class="col-md-3 form-group no-margin text-right">
                            <?php echo Form::saveButton('Update'); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
   <?php echo Form::close(); ?>  

    <script type="text/javascript">
        var text_yes = '<?php echo e(trans('general.yes')); ?>';
        var text_no = '<?php echo e(trans('general.no')); ?>';

    </script>
    <script type="text/javascript">
    $(document).ready(function(){
        $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });
        var activeTab = localStorage.getItem('activeTab');
        if(activeTab){
            $('#myTab a[href="' + activeTab'"]').tab('show');
        }
    });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/settings/settings/edit.blade.php ENDPATH**/ ?>