
<?php $__env->startSection('title', trans('general.title.edit', ['type' => trans_choice('general.cheques', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('expenses/cheques')); ?>"
	class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.cheques', 2) . 'List'); ?> 
</a>
<a href="<?php echo e(url('expenses/cheques/'.$cheque->id)); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">remove_red_eye</i>show</a>
<a  href="<?php echo e(url('expenses/cheques/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Cheque"><i class="material-icons left">add</i> <?php echo e(trans_choice('general.cheques', 2)); ?></a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Default box -->
<?php echo Form::model($cheque, ['method' => 'PATCH', 'files' => true, 'url' => ['expenses/cheques', $cheque->id], 'role' => 'form']); ?>

<div class="card">
	<div class="row">
		<div class="col-lg-3 col-md-4 col-sm-6   required <?php echo e($errors->has('person_id') ? 'has-error' : ''); ?>">
			<small> <?php echo e(trans('general.payee')); ?></small>
			<select id="person_id" class="selectpicker" data-live-search="true" name="person_id">
				<option value="" selected="selected"> Select Name </option>
				<?php $__currentLoopData = $personname; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<option value="<?php echo e($person->id); ?>" data-subtext=
					(<?php echo e($person->type); ?>) <?php echo e(($person->id == $cheque->person_id)?'selected':''); ?>> <?php echo e($person->name); ?> 
				</option>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</select>
			<?php echo $errors->first('person_id', '
			<div class="help-block with-errors">:message</div>
			'); ?>

		</div>
        <div class="col-md-3">
			<?php echo e(Form::selectGroup('account_id', 'Account', $accounts, null, ['data-live-search'=>'true','required' =>'required'])); ?>

		</div>
		<div class="col-md-3">
			<?php echo e(Form::textGroup('paid_at', 'Date', Date::parse($cheque->paid_at)->format('yyyy-mm-dd'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

		</div>
		<div class="col-md-3">
			<?php echo e(Form::textGroup('cheque_number', 'Cheque Number', null, ['required' => 'required'])); ?>

		</div>
		<?php echo e(Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code'])); ?>

	</div>
</div>
<div class="account_details">
	<h3 class="mb-3 mt-3">Account Details</h3>
	<div class="">
		<table class="table table-bordered tabl-input" id="account">
			<thead>
				<tr style="background-color: #f9f9f9;">
					<th width="10%"  class="text-center"><?php echo e(trans('general.actions')); ?></th>
					<th width="30%"><?php echo e(trans_choice('general.accounting',1)); ?></th>
					<th width="30%"><?php echo e(trans('general.description')); ?></th>
					<th width="15%"><?php echo e(trans('bills.price')); ?></th>
					<th width="15%"><?php echo e(trans('bills.total')); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php $account_row = 0; ?>
				<?php 
				function chartfunction1($elements, $prefix = '' , $item_id) {
				foreach ($elements as $k=> $element) { 
				?>
				<option value="<?php echo e($element['id']); ?>" 
				<?php echo e(( $item_id == $element['id'] )?'selected':''); ?> data-subtext="<?php echo e($element['account_name']); ?>">
				<?php echo e($prefix . $element['name']); ?> 
				<?php if(isset($element['children'])): ?>
				<?php chartfunction1($element['children'],$prefix . $element['name'] ." : " , $item_id);
				?>
				<?php endif; ?>
				</option>
				<?php  } 
				}
				?>
				<?php $__empty_1 = true; $__currentLoopData = $cheque->account_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
				<tr id="account-row-<?php echo e($account_row); ?>">
					<td style="vertical-align: middle;">
						<button type="button" onclick="$('#account-row-<?php echo e($account_row); ?>').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
					</td>
					<td>
						<select onchange="nameofAccount(<?php echo e($account_row); ?>);addChartofAccount(event);" id="account-id-<?php echo e($account_row); ?>" class="selectpicker" name="account[<?php echo e($account_row); ?>][account_id]" data-live-search="true" tabindex="-1" aria-hidden="true" required="required">
						<?php echo loopChartData($account_details_name , $prefix = '',$item->account_type_id); ?> 
						</select>
						<input class="form-control"  name="account[<?php echo e($account_row); ?>][name]" type="hidden" id="account-name-<?php echo e($account_row); ?>">
						<input class="form-control" name="account[<?php echo e($account_row); ?>][quantity]" type="hidden" value="1" id="account-quantity-<?php echo e($account_row); ?>">
					</td>
					<td>
						<div class="form-group">
							<input class="form-control " value="<?php echo e($item->description); ?>"  name="account[<?php echo e($account_row); ?>][description]"  type="text" id="account-description-<?php echo e($account_row); ?>">
							<label class="form-label"><?php echo e(trans('general.description')); ?></label> 
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td>
						<div class="form-group">
							<input value="<?php echo e($item->price); ?>" class="form-control" required="required" name="account[<?php echo e($account_row); ?>][price]" type="text" id="account-price-<?php echo e($account_row); ?>">
							<label class="form-label">Price</label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td style="vertical-align: middle;">
						<span id="account-total-<?php echo e($account_row); ?>">0</span>
					</td>
				</tr>
				<?php $account_row++; ?>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?> 
				<tr id="account-row-<?php echo e($account_row); ?>">
					<td style="vertical-align: middle;">
						<button type="button" onclick="$('#account-row-<?php echo e($account_row); ?>').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
					</td>
					<td>
						<select onchange="nameofAccount(<?php echo e($account_row); ?>);addChartofAccount(event);" id="account-id-<?php echo e($account_row); ?>" class="selectpicker" data-live-search="true" name="account[<?php echo e($account_row); ?>][account_id]" tabindex="-1" aria-hidden="true" required="required">
						<?php echo Cache::get('account_details_option'); ?>

						</select>
						<input class="form-control"  name="account[<?php echo e($account_row); ?>][name]" type="hidden" id="account-name-<?php echo e($account_row); ?>">
						<input class="form-control" name="account[<?php echo e($account_row); ?>][quantity]" type="hidden" value="1" id="account-quantity-<?php echo e($account_row); ?>">
					</td>
					<td>
						<div class="form-group"><input class="form-control "  name="account[<?php echo e($account_row); ?>][description]" type="text" id="account-description-<?php echo e($account_row); ?>">
							<label class="form-label"><?php echo e(trans('general.description')); ?></label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td>
						<div class="form-group"><input class="form-control" required="required" name="account[<?php echo e($account_row); ?>][price]" type="text" id="account-price-<?php echo e($account_row); ?>">
							<label class="form-label">Price</label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td style="vertical-align: middle;">
						<span id="account-total-<?php echo e($account_row); ?>">0</span>
					</td>
				</tr>
				<?php endif; ?>
				<?php $account_row++; ?>
				<tr id="addAccount">
					<td><button type="button" onclick="addAccount();" data-toggle="tooltip" title="<?php echo e(trans('general.add')); ?>" class="btn btn-xs  btn-outline-primary btn-circle-iconic btn34" data-original-title="<?php echo e(trans('general.add')); ?>"><i class="material-icons">add</i></button></td>
					<td colspan="4"></td>
				</tr>
				<tr>
					<td class="text-right" colspan="4"><strong><?php echo e(trans('cheques.sub_total')); ?></strong></td>
					<td><span id="sub-total">0</span></td>
				</tr>
				<tr>
					<td class="text-right" colspan="4"><strong><?php echo e(trans('cheques.total')); ?></strong></td>
					<td><span id="grand-total">0</span></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<?php echo e(Form::fileGroup('attachment', trans('general.attachment'))); ?>

<?php if($cheque->attachment): ?>
<span class="attachment">
<a href="<?php echo e(url('uploads/' . $cheque->attachment->id . '/download')); ?>">
<span id="download-attachment" class="text-primary">
<i class="fa fa-file-<?php echo e($cheque->attachment->aggregate_type); ?>-o"></i> <?php echo e($cheque->attachment->basename); ?>

</span>
</a>
</span>
<?php endif; ?>
<div class="row">
	<div class="col-lg-6 col-md-6 col-sm-6 mt-2">
		<?php echo e(Form::textareaGroup('description', trans_choice('general.description', 2))); ?>

	</div>
	<div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
		<?php echo e(Form::saveButton('Update expenses/cheques')); ?>

	</div>
</div>
<?php echo Form::close(); ?>

<div id='chart_dropdown' style="display: none">
	<?php echo Cache::get('account_details_option'); ?>

</div>
<?php echo $__env->make('accounts.common.models.chartofaccount', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script  src="<?php echo e(asset('accounts/chartofaccounts/accounting.js')); ?>">  </script>
<script type="text/javascript">
	var account_row = <?php echo e($account_row); ?>;
	function addAccount() {
	    html  = '<tr id="account-row-' + account_row + '">';
	    html += '  <td style="vertical-align: middle;">';
	    html += '      <button type="button" onclick="$(\'#account-row-' + account_row + '\').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>';
	    html += '  </td>';
	
	    html += '  <td>';
	    html += '      <select class="selectpicker" data-live-search="true" onchange="nameofAccount('+ account_row +');addChartofAccount(event);" name="account[' + account_row + '][account_id]" id="account-id-' + account_row + '">';
	
	    html += $('#chart_dropdown').html();
	   
	    html += '      </select>';
	    html += '<input class="form-control"  name="account['+ account_row +'][name]" type="hidden" id="account-name-'+ account_row +'">';
	    html += '<input  name="account['+ account_row +'][quantity]" type="hidden" value="1" id="account-quantity-'+ account_row +'">'
	    html += '  </td>';
	
	    html += '  <td>';
	    html += '<div class="form-group"><input class="form-control"  name="account[' + account_row + '][description]" type="text" id="account-description-' + account_row + '"><label class="form-label"><?php echo e(trans('general.description')); ?></label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	    html += '  <td>';
	    html += ' <div class="form-group"><input class="form-control" required  name="account[' + account_row + '][price]" type="text" id="account-price-' + account_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	
	    html += '  <td style="vertical-align: middle;">';
	    html += '      <span id="account-total-' + account_row + '">0</span>';
	    html += '  </td>';
	
	    $('#account tbody #addAccount').before(html);
	    $('#account-id-'+ account_row).selectpicker('refresh');
	
	    account_row++;
	}
	
	$(document).ready(function(){
	    totalItem();
		//Date picker
		$('#paid_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
		$('#paid_at').datepicker({
			format: 'yyyy-mm-dd',
			todayHighlight: true,
		});
	
	    //Date picker
	    $('#due_at').datepicker({
	        format: '<?php echo e($date_format); ?>',
	        autoclose: true
	    });
	    
	
	    <?php if($cheque->attachment): ?>
	        attachment_html  = '<span class="attachment">';
	        attachment_html += '    <a href="<?php echo e(url('uploads/' . $cheque->attachment->id . '/download')); ?>">';
	        attachment_html += '        <span id="download-attachment" class="text-primary">';
	        attachment_html += '            <i class="fa fa-file-<?php echo e($cheque->attachment->aggregate_type); ?>-o"></i> <?php echo e($cheque->attachment->basename); ?>';
	        attachment_html += '        </span>';
	        attachment_html += '    </a>';
	        attachment_html += '    <?php echo Form::open(['id' => 'attachment-' . $cheque->attachment->id, 'method' => 'DELETE', 'url' => [url('uploads/' . $cheque->attachment->id)], 'style' => 'display:inline']); ?>';
	        attachment_html += '    <a id="remove-attachment" href="javascript:void();">';
	        attachment_html += '        <span class="text-danger"><i class="fa fa fa-times"></i></span>';
	        attachment_html += '    </a>';
	        attachment_html += '    <?php echo Form::close(); ?>';
	        attachment_html += '</span>';
	
	        $('.fancy-file .fake-file').append(attachment_html);
	
	        $(document).on('click', '#remove-attachment', function (e) {
	            confirmDelete("#attachment-<?php echo $cheque->attachment->id; ?>", "<?php echo trans('general.attachment'); ?>", "<?php echo trans('general.delete_confirm', ['name' => '<strong>' . $cheque->attachment->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]); ?>", "<?php echo trans('general.cancel'); ?>", "<?php echo trans('general.delete'); ?>");
	        });
	    <?php endif; ?>  
	
	      /*Accounts Event*/
	    $(document).on('change', '#currency_code, #account tbody select', function(){
	        totalItem();
	    });
	
	    $(document).on('keyup', '#account tbody .form-control', function(){
	        totalItem();
	    });
	
	
	
	    
	    $(document).on('change', '#vendor_id', function (e) {
	        $.ajax({
	            url: '<?php echo e(url("expenses/vendors/currency")); ?>',
	            type: 'GET',
	            dataType: 'JSON',
	            data: 'vendor_id=' + $(this).val(),
	            success: function(data) {
	                $('#currency_code').val(data.currency_code);
	
	                // This event Select2 Stylesheet
	                $('#currency_code').trigger('change');
	            }
	        });
	    });
	    $(document).on('change', '#account_id', function (e) {
	    $.ajax({
	        url: '<?php echo e(url("settings/currencies/currency")); ?>',
	        type: 'GET',
	        dataType: 'JSON',
	        data: 'account_id=' + $(this).val(),
	        success: function(data) {
	            $('#currency').val(data.currency_name);
	            $('#currency_code').val(data.currency_code);
	        }
	    });
	});
	});
	
	function totalItem() {
	    $.ajax({
	        url: '<?php echo e(url("items/items/totalChequeamount")); ?>',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $('#currency_code, #account input[type=\'text\'],#account input[type=\'hidden\'], #account textarea, #account select'),
	        headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
	        success: function(data) {
	            if (data) {
	                
	                $.each( data.account, function( key, value ) {
	                    $('#account-total-' + key).html(value);
	                });
	                $('#sub-total').html(data.sub_total);
	               
	                $('#grand-total').html(data.grand_total);
	            }
	        }
	    });
	}
	
	
	   // Account Name Taken Form Dropdown Text.
	function nameofAccount( id ){
	    $('#account-price-'+id).prop('required',true);
	    var account_id = $('#account-id-'+id +' option:selected').text();
	    $('#account-name-'+id).val(account_id.split("---")[0]);
	}
	
	$(document).on('click', '#button-account-create', function (e) { 
	$('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');    
	$.ajax({
	    url: '<?php echo e(url("accounting/chartofaccounts_model_data")); ?>',
	    type: 'POST',
	    dataType: 'JSON',
	    data: $("#form-account-create").serialize(),
	     
	    success: function(data) {
	        $('#span-loader').remove(); 
	
	        $('#close-modal-create-account').trigger('click');
	        $("#"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
	        $("#"+ data.present_value_of_dropdown).selectpicker('refresh');
	
	    },
	    error: function(error, textStatus, errorThrown) {
	        $('#span-loader').remove();
	        // $('#close-modal-create-account').trigger('click'); 
	
	    }
	}); 
	}); 
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/cheques/edit.blade.php ENDPATH**/ ?>