<div class="modal fade" id="modal-account-create"  >
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title"><?php echo e(trans('general.title.new', ['type' => trans_choice('general.chartsofaccount', 1)])); ?> </h4>
              <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body">
            <?php echo Form::open(['id' => 'form-account-create', 'role' => 'form']); ?>

            <div class="row"> 
                <div class="col-md-6">
                     <div class="form-group">
                    <small><?php echo e(trans_choice('general.types', 1)); ?> <span class="RED-Star"> * </span></small>             
                    <select id="account_type_id" name="account_type_id"  class="selectpicker" data-live-search='true'  required="required">
                        <option selected="selected" value="">- Select Account Type -</option>
                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"> <?php echo e($type); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                         
                    </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group   ">
                        <input class="form-control"   name="name" type="text" data-dirrty-initial-value="" data-is-dirrty="false" required="required">
                        <label for="name" class="form-label">Name <span class="RED-Star"> * </span></label>
                        <span class="form-controlBrd"></span>
                    </div>
                </div> 
                <div class="col-md-6 " >  
                 <small>Select Parent Account</small>             
                    <select id="chart_parent_id" name="chart_parent_id"  class="selectpicker" disabled="disabled" data-live-search='true'  > 
                       <?php echo Cache::get('account_details_option'); ?>                         
                    </select>
                    <div class="help-block">
                        <div class="custom-controls-stacked d-block">
                            <label class="custom-control overflow-checkbox" >
                            <input type="checkbox" name="sub_chart" id="sub_chart" value="1" class="overflow-control-input">
                            <span class="overflow-control-indicator"></span> <span class="overflow-control-description">Is Sub Account</span> </label>
                        </div> 
                    </div>
                </div>
                <div  class="col-md-6" id="number_div" style="display: none">
                    <div class="form-group required">
                        <?php echo Form::text('number', null, array_merge(['class' => 'form-control'])); ?>

                        <?php echo Form::label('number', trans('accounts.number') . '<span class="RED-Star">*</span>', ['class' => 'form-label'],false); ?>

                        <span class="form-controlBrd"></span>
                    </div>
                </div>
                <div  class="col-md-6" id="balance_div" >
                    <div class="form-group  required">
                         <input class="form-control"  name="balance" id="balance" type="text">
                         <label for="balance" class="form-label" id="balance_label">Opening Balance 
                            <span class="RED-Star">*</span></label>
                         <span class="form-controlBrd"></span>
                    </div>
                </div>
            
                <div class="col-md-6" id="balance_as_of_div" style="display: none">
                    <div class="form-group  required ">
                        <input class="form-control has-value " id="balance_as_of" data-inputmask="'alias': 'mm-dd-yyyy'" data-mask="" name="balance_as_of" type="text" value="<?php echo e(Date::now()->format($date_format)); ?>">
                        <label for="balance_as_of" class="form-label">Balance as of <span class="RED-Star">*</span></label>
                        <span class="form-controlBrd"></span>
                        
                    </div>
                </div>

                <?php echo e(Form::textareaGroup('description', trans('general.description'))); ?>


                <?php echo e(Form::radioGroup('enabled', trans('general.status'))); ?>


            </div>
            <?php echo Form::close(); ?>

            </div>
            <div class="modal-footer">
                <div class="pull-left">
                  <button type="button" id="close-modal-create-account" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"> <span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
                  <?php echo Form::button('SAVE', ['type' => 'button', 'id' =>'button-account-create', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\resources\views/accounts/common/models/chartofaccount.blade.php ENDPATH**/ ?>