
<?php $__env->startSection('title', 'Email List'); ?>
<?php if(isAdmin()): ?>
  <?php $__env->startSection('new_button'); ?>
    <a href="<?php echo e(url('/campaign_reports')); ?>" class="btn btn-primary btn-Rcircle-iconic waves-effect waves-light">Team Reports</a>
  <?php $__env->stopSection(); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>

<style>
.red-dot {
    height: 10px;
    width: 10px;
    background-color: red;
    border-radius: 50%;
    display: inline-block;
}
.green-dot {
    height: 10px;
    width: 10px;
    background-color: green;
    border-radius: 50%;
    display: inline-block;
}
.red {
  color: red;
}
.green {
  color: green;
}
.ash-back {
  background-color: #D8D8D9; 
  font-weight: bold;
}
</style>

<div class="card">
  <?php echo Form::open(['url'=>'/campaign_email_reports', 'method'=>'POST', 'autocomplete'=>'off']); ?>

  <div class="row">
    <div class="col-md-3 form-group">
      <small>Type</small>
      <?php echo Form::select('state', [''=>'Select Status', 'sent'=>'Email Sent', 'rejected'=>'Email Rejected'], null, ['class'=>'selectpicker', 'required']); ?>

    </div>
    <div class="col-md-3">
      <?php echo e(Form::label('From Date')); ?>

      <?php echo Form::text('from_date', NULL, ['id'=>'fromdate']); ?>

    </div>
    <div class="col-md-3">
      <?php echo e(Form::label('To Date')); ?>

      <?php echo Form::text('to_date', NULL, ['id'=>'todate']); ?>

    </div>
    <div class="col-md-3 form-group">
      <?php echo Form::submit('Filter', ['class'=>'btn btn-sm btn-primary pull-right', 'style'=>"margin-top: 0px;"]); ?>

    </div>
  </div>
  <?php echo Form::close(); ?>

</div>

<table class="table table-hover dt-responsive" id="example" style="font-size: 11px;">
  <thead class="ash-back">
    <tr>
      <th>Status</th>
      <th>Sender</th>
      <th>Email</th>
      <th>Subject</th>
      <th>Opens</th>
      <th>Clicks</th>
      <th>Content</th>
    </tr>
  </thead>
  <tbody>
    <?php 
      $new_date = date('Y-m-d'); 
    ?> 
    <?php if( is_array($list) && count($list) > 0): ?> 
      <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $li): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
        <?php if(Date::parse($li->ts)->format('Y-m-d') != $new_date): ?> 
          <?php 
            $new_date = Date::parse($li->ts)->format($date_format); 
          ?>
          <tr class="text-center ash-back">
            <td colspan="7">
              <strong><?php echo e(Date::parse($li->ts)->format($date_format)); ?></strong>
            </td>
          </tr>
        <?php endif; ?>
          <tr>
            <?php if($li->state === 'sent'): ?>
            <td>
              <span class="green-dot"></span>
              <span class="green"><?php echo e(ucfirst($li->state)); ?> </span>
              <p><?php echo e(Date::parse($li->ts)->format($date_format)); ?> <?php echo e(Date::parse($li->ts)->format('H:i A')); ?></p>
            </td>
            <?php else: ?>
            <td>
              <span class="red-dot"></span>
              <span class="red"><?php echo e(ucfirst($li->state)); ?> </span>
              <p><?php echo e(Date::parse($li->ts)->format($date_format)); ?> <?php echo e(Date::parse($li->ts)->format('H:i A')); ?></p>
            </td>
            <?php endif; ?>
            <td><?php echo e($li->sender); ?></td>
            <td id="email<?php echo e($i+1); ?>"><?php echo e($li->email); ?></td>
            <td title="<?php echo e($li->subject); ?>"><?php echo e(str_limit($li->subject, 20)); ?></td>
            <td><?php echo e($li->opens); ?></td>
            <td><?php echo e($li->clicks); ?></td>
            <td>
              <?php if($li->state === 'sent'): ?>
              <a href="<?php echo e(url('/campaign/mail-view')); ?>/<?php echo e($li->_id); ?>" target="_blank" size="<?php echo e($li->_id); ?>" id="content<?php echo e($i+1); ?>">View Content</a> 
              <?php endif; ?>
              <button title="Resend" type="button" class="btn btn-sm" onclick="resendMail(<?php echo e($i+1); ?>)">Resend</button>
            </td>
          </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
    <?php else: ?>
    <tr class="text-center">
      <td colspan="7" class="text-center">No Data Found</td>
    </tr>
    <?php endif; ?>
  </tbody>
</table>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="<?php echo e(asset('js/pages/campaigns/email-list-view.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.campaign', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/mail-campaign/reports/email-list-view.blade.php ENDPATH**/ ?>