
<?php $__env->startSection('new_button'); ?>
<a  href="<?php echo URL::to('/jobs'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i class="material-icons left"> remove_red_eye </i> Job list </a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style type="text/css">
	table > tbody > tr > td{
	padding: 5px !important;
	}
	.control-label{
        float:left;
        font-size: 16px;
        font-weight: 800;
    }
	fieldset{
        width:100%;
        margin-top: 1.5rem;
    }
    legend {
        text-decoration: underline;
    }
</style>

<div class="card">
    
    <fieldset>
        <legend>Job Details</legend>
        <div class="row">
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Title :- </label>
                <div class="vendor-info"><?php echo e(ucfirst($job->title)); ?></div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info"><?php echo e(ucwords($job->country?->name)); ?></div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Experience :- </label>
                <div class="vendor-info"><?php echo e($job->min_experience); ?>Y - <?php echo e($job->max_experience); ?>Y</div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Payrate :- </label>
                <div class="vendor-info"><?php echo e($job->min_payrate); ?> - <?php echo e($job->max_payrate); ?></div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Interview Mode :- </label>
                <div class="vendor-info">
                    <?php echo e(config('custom.interview_modes')[$job->interview_mode]); ?>

                </div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Employment Type :- </label>
                <div class="vendor-info"><?php echo e(config('custom.employment_types')[$job->employment_type]); ?></div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label">Job Status :- </label>
                <div class="vendor-info">
                    <?php if($job->status == 0): ?>
                    Open
                    <?php elseif($job->status == 1): ?>
                    Closed
                    <?php elseif($job->status == 2): ?>
                    Pending
                    <?php else: ?>
                    ...
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label" style="width:145px;">Internal message :- </label>
                <div class="vendor-info"><?php echo e(ucfirst($job->internal_message)); ?></div>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12">
                <label class="control-label" style="width:145px;">Job Description :- </label>
                <div class="vendor-info" data-toggle="tooltip" title="<?php echo e(ucfirst(strip_tags($job->description))); ?>"><?php echo e(ucfirst(Str::limit(strip_tags($job->description, 20)))); ?></div>
            </div>
        </div>
    </fieldset>

    <!-- Vendor Details -->
    <fieldset>
        <legend>Vendor Details</legend>
        <?php $__currentLoopData = $job->vendor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Name :- </label>
                <div class=""><?php echo e(ucfirst($vendor->vendor?->name)); ?></div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info"><?php echo e($vendor->vendor?->country?->name); ?></div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Website :- </label>
                <div class="vendor-info"><?php echo e($vendor->vendor?->website); ?></div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </fieldset>
    
    <!-- Implementer Details -->
    <fieldset>
        <legend>Implementer Details</legend>
        <div class="row">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Name :- </label>
                <div class="vendor-info"><?php echo e(ucfirst($job->implementor?->name)); ?></div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info"><?php echo e($job->implementor?->country?->name); ?></div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Website :- </label>
                <div class="vendor-info"><?php echo e($job->implementor?->website); ?></div>
            </div>
        </div>
    </fieldset>
    
    <!-- Client Details -->
    <fieldset>
        <legend>Client Details</legend>
        <div class="row">
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Name :- </label>
                <div class="vendor-info"><?php echo e(ucfirst($job->client?->name)); ?></div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Location :- </label>
                <div class="vendor-info"><?php echo e($job->client?->country?->name); ?></div>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-12">
                <label class="control-label">Website :- </label>
                <div class="vendor-info"><?php echo e($job->client?->website); ?></div>
            </div>
        </div>
    </fieldset>
</div>


<h3><b>Shared Profiles</b></h3>
<div class="card">
    <form action="<?php echo e(url('/save_scheduled')); ?>" method="post" id="saveSchedule">
    <?php echo csrf_field(); ?>
    <table class="table table-striped table-bordered" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Name</th>
                <th>Mobile</th>
                <th>Email</th>
                <th>Visa Type</th>
                <th>Location Specific</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php if(count($shared) > 0): ?>
                <?php $__currentLoopData = $shared; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$share): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($share->consultant?->name); ?></td>
                    <td><?php echo e($share->consultant?->mobile); ?></td>
                    <td><?php echo e($share->consultant?->email); ?></td>
                    <td><?php echo e($share->consultant?->visa_status); ?></td>
                    <td> <?php echo e($share->consultant?->country?->name); ?> </td>
                    <td><?php echo e(ucwords($share->status)); ?></td>
                    <td>
                        <input type="checkbox" name="share_id[]" value="<?php echo e($share->id); ?>" class="students" id="">
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <tr style="text-align:center;">
                <td colspan='10'>No Student(s) Found...</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <div class="row" style="margin-top: 10px">
        <div class="btn-group col-md-12">
            <button class="btn btn-primary btn-sm pull-right" type="button" id="" onclick="$('#saveSchedule').submit()" value="1">Mark as scheduled</button>
        </div>
    </div>
    </form>
</div>


<h3><b>Schedule Interviews</b></h3>
<div class="card">
    <form action="<?php echo e(url('/save_attended')); ?>" method="post">
        <table class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Visa Type</th>
                    <th>Location Specific</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($scheduled) > 0): ?>
                    <?php $__currentLoopData = $scheduled; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($schedule->consultant?->name); ?></td>
                        <td><?php echo e($schedule->consultant?->mobile); ?></td>
                        <td><?php echo e($schedule->consultant?->email); ?></td>
                        <td><?php echo e($schedule->consultant?->visa_status); ?></td>
                        <td> <?php echo e($schedule->consultant?->country?->name); ?> </td>
                        <td><?php echo e(ucwords($schedule->status)); ?></td>
                        <td>
                            <input type="checkbox" name="share_id[]" value="<?php echo e($schedule->id); ?>" class="students" id="">
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr style="text-align:center;">
                    <td colspan='10'>No Student(s) Found...</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="row">
            <div class="btn-group col-md-12">
                <button class="btn btn-primary btn-sm pull-right" type="submit" name="update_scheduled" id="scheduled" value="update_scheduled">Mark as attended</button>
            </div>
        </div>
        <?php echo e(csrf_field()); ?>

    </form>
</div>


<h3><b>Mark as Attended</b></h3>
<div class="card">
    <form action="<?php echo e(url('/save_selected')); ?>" method="post">
        <table class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Visa Type</th>
                    <th>Location Specific</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($attended) > 0): ?>
                    <?php $__currentLoopData = $attended; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$attend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($attend->consultant?->name); ?></td>
                        <td><?php echo e($attend->consultant?->mobile); ?></td>
                        <td><?php echo e($attend->consultant?->email); ?></td>
                        <td><?php echo e($attend->consultant?->visa_status); ?></td>
                        <td> <?php echo e($attend->consultant?->country?->name); ?> </td>
                        <td><?php echo e(ucwords($attend->status)); ?></td>
                        <td>
                            <input type="checkbox" name="share_id[]" value="<?php echo e($attend->id); ?>" class="students" id="">
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr style="text-align:center;">
                    <td colspan='10'>No Student(s) Found...</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="row">
            <div class="btn-group col-md-12">
                <button class="btn btn-primary btn-sm pull-right" type="submit" name="update_attended" id="attended">Mark as selected</button>
            </div>
        </div>
        <?php echo e(csrf_field()); ?>

    </form>
</div>


<h3><b>Mark as Selected</b></h3>
<div class="card">
    <form action="<?php echo e(url('/save_joined')); ?>" method="post">
        <table class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Visa Type</th>
                    <th>Location Specific</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($selected) > 0): ?>
                    <?php $__currentLoopData = $selected; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$select): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($select->consultant?->name); ?></td>
                        <td><?php echo e($select->consultant?->mobile); ?></td>
                        <td><?php echo e($select->consultant?->email); ?></td>
                        <td><?php echo e($select->consultant?->visa_status); ?></td>
                        <td> <?php echo e($select->consultant?->country?->name); ?> </td>
                        <td><?php echo e(ucwords($select->status)); ?></td>
                        <td>
                            <input type="checkbox" name="share_id[]" value="<?php echo e($select->id); ?>" class="students" id="">
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr style="text-align:center;">
                    <td colspan='10'>No Student(s) Found...</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="row">
            <div class="btn-group col-md-12">
                <button class="btn btn-primary btn-sm pull-right" type="submit" name="update_selected" id="selected">Mark as joined</button>
            </div>
        </div>
        <?php echo e(csrf_field()); ?>

    </form>
</div>


<h3><b>Mark as Joined</b></h3>
<div class="card">
    <table class="table table-striped table-bordered" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Name</th>
                <th>Mobile</th>
                <th>Email</th>
                <th>Visa Type</th>
                <th>Location Specific</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php if(count($joined) > 0): ?>
                <?php $__currentLoopData = $joined; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$join): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($join->consultant?->name); ?></td>
                    <td><?php echo e($join->consultant?->mobile); ?></td>
                    <td><?php echo e($join->consultant?->email); ?></td>
                    <td><?php echo e($join->consultant?->visa_status); ?></td>
                    <td> <?php echo e($join->consultant?->country?->name); ?> </td>
                    <td><?php echo e(ucwords($join->status)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <tr style="text-align:center;">
                <td colspan='10'>No Student(s) Found...</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php echo e(csrf_field()); ?>

</div>

<script type="text/javascript">
	$(document).ready(function(){
		$('.scheduled_date').datepicker({
			format: 'dd-mm-yyyy',
			todayHighlight: true,
			clearBtn: true
		});
	
		$(".scheduled_date").keypress(function(e){
			e.preventDefault();
		});
	
		$('.attended_date').datepicker({
			format: 'dd-mm-yyyy',
			todayHighlight: true,
			clearBtn: true
		});
	
		$(".attended_date").keypress(function(e){
			e.preventDefault();
		});
	
		$('.selected_date').datepicker({
			format: 'dd-mm-yyyy',
			todayHighlight: true,
			clearBtn: true
		});
	
		$(".selected_date").keypress(function(e){
			e.preventDefault();
		});
	
	});
	function Checkradiobutton(){
		if(document.getElementById('schedule_radio').checked){
			document.getElementById('scheduled_date').disabled=true;
		}
	}
</script>
<script type="text/javascript">
	$(document).ready(function(){
		$('#download_resume').click(function () {
			$(".students").each(function(){
				if($(this).is(':checked')){
					var id = $(this).val();
					//var std_name = $(".students_name").val();
					var editor = '#editor'+id;
					var doc = new jsPDF();
					var specialElementHandlers = {
					    'editor': function (element, renderer) {
					        return true;
					    }
					};
					doc.fromHTML($("#resume_content"+id).val(), 15, 15, {
				        'width': 170,
			          	'elementHandlers': specialElementHandlers
				    });
			    	doc.save('Resume_'+id+'.pdf');
			    	doc = new jsPDF();
				}
	
			});
	
		});
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/jobs/show.blade.php ENDPATH**/ ?>