<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('accounts.expenses.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', trans_choice('general.payments', 2)); ?>


<?php $__env->startSection('new_button'); ?>
<div class="searchBox mr-2">
   <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]); ?>

    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="<?php echo e(url('expenses/payments/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Payments"><i class="material-icons left">add</i><?php echo e(trans_choice('general.payments', 2)); ?></a>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Default box -->
<div class="box box-success">
   
    <div class="">
        <div class="">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-payments">
              
                <thead>
                    <tr>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('paid_at', trans('general.date')));?></th>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('amount', trans('general.amount')));?></th>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('vendor.name', trans_choice('general.vendors', 1)));?></th>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('account.name', trans_choice('general.accounts', 1)));?></th>
                        <th ><?php echo e(trans('general.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><a href="<?php echo e(url('expenses/payments/' . $item->id . '/edit')); ?>"><?php echo e(Date::parse($item->paid_at)->format($date_format)); ?></a></td>
                        <td><?php echo money($item->amount, $item->currency_code, true); ?></td>
                        <td class="hidden-xs"><?php echo e(!empty($item->vendor->name) ? $item->vendor->name : trans('general.na')); ?></td>
                        <td class="hidden-xs"><?php echo e($item->account->name_number); ?></td>
                        <td class="">
                             <a  class="btn btn-outline-info btn-circle-iconic btn34" href="<?php echo e(url('expenses/payments/' . $item->id . '/edit')); ?>"><i class="material-icons">create</i></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->

    
    <!-- /.box-footer -->
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/payments/index.blade.php ENDPATH**/ ?>