<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('accounts.expenses.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', trans_choice('general.bills', 2)); ?>

<?php $__env->startSection('new_button'); ?>

<div class="searchBox mr-2">
   <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder'), 'id'=>'tableSearch']); ?>

    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="<?php echo e(url('expenses/bills/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"  data-toggle="tooltip" title="Create Bills"><i class="material-icons left">add</i> <?php echo e(trans_choice('general.bills', 2)); ?></a>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Default box -->
<div class="box box-success">
    

    <div class="">
        <div class="wid100-Hidden" style="min-height:400px;">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-bills">
             
                <thead >
                    <tr>
                        <th><?php echo e(trans_choice('general.numbers', 1)); ?></th>
                        <th><?php echo e(trans_choice('general.vendors', 1)); ?></th>
                        <th><?php echo e(trans('general.amount')); ?> </th>
                        <th><?php echo e(trans('bills.bill_date')); ?></th>
                        <th><?php echo e(trans('bills.due_date')); ?></th>
                        <th><?php echo e(trans_choice('general.statuses', 1)); ?> </th>
                        <th><?php echo e(trans('general.actions')); ?></th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $bills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><a href="<?php echo e(url('expenses/bills/' . $item->id . ' ')); ?>"><?php echo e($item->bill_number); ?></a></td>
                        <td><?php echo e($item->vendor_name); ?></td>
                        <td><?php echo money($item->amount, $item->currency_code, true); ?></td>
                        <td><?php echo e(Date::parse($item->billed_at)->format($date_format)); ?></td>
                        <td><?php echo e(Date::parse($item->due_at)->format($date_format)); ?></td>
                        <td><span class="badge <?php echo e($item->status->label); ?>"><?php echo e($item->status->name); ?></span></td>
                         <td>
                            <div class="pull-center">
                                <?php if($item->status->code != 'paid'): ?>
                                <a href="<?php echo e(url('expenses/bills/makepayment/'.$item->id)); ?>"><?php echo e(trans('bills.make_payment')); ?></a>
                                <?php else: ?>
                                <a href="<?php echo e(url('expenses/bills/' . $item->id . '/print')); ?>" >
                                   <?php echo e(trans('general.print')); ?></a>
                                <?php endif; ?>
                                
                            </div>
                        </td>
                        <td>
                            <div class="position-relative">
                                <div class="btn-group">
                                    <div class="dropdown moreIcon">
                                        <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <li><a href="<?php echo e(url('expenses/bills/' . $item->id)); ?>"><?php echo e(trans('general.show')); ?></a></li>
                                            <li><a href="<?php echo e(url('expenses/bills/' . $item->id . '/edit')); ?>"><?php echo e(trans('general.edit')); ?></a></li>
                                            <li> <a href="<?php echo e(url('expenses/bills/' . $item->id . '/pdf')); ?>"><?php echo e(trans('bills.download_pdf')); ?></a>
                                            </li>
                                            <?php if($item->status->code != 'paid'): ?>
                                            <li>
                                                <a href="<?php echo e(url('expenses/bills/' . $item->id . '/print')); ?>" >
                                               <?php echo e(trans('general.print')); ?>

                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>   
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->

   
    <!-- /.box-footer -->
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/bills/index.blade.php ENDPATH**/ ?>