

<?php $__env->startSection('title', trans_choice('general.cheques', 1) . ': ' . $cheque->cheque_number); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('expenses/cheques')); ?>"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.cheques', 2) . 'List'); ?> 
</a>

<a href="<?php echo e(url('expenses/cheques/'.$cheque->id .'/edit')); ?>"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">edit</i>Edit
</a>

<a  href="<?php echo e(url('expenses/cheques/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Cheque"><i class="material-icons left">add</i> <?php echo e(trans_choice('general.cheques', 2)); ?></a>
<?php $__env->stopSection(); ?>
<style>
    .cheque{padding:20px;}
    .invoice-company{padding-top:10px;}
     .table th{padding:1rem !important;}
     .invoice-logo{height:50px;}
</style>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="cheque">
           

            <div class="row invoice-header">
                <div class="col-md-6">
                    <?php if(isset($cheque->vendor->logo) && !empty($cheque->vendor->logo->id)): ?>
                        <img src="<?php echo e(Storage::url($cheque->vendor->logo->id)); ?>" class="invoice-logo" />
                    <?php else: ?>
                        <img src="<?php echo e(asset('accounts/img/company.png')); ?>" class="invoice-logo" />
                    <?php endif; ?>
                
                <div class="invoice-company">
                    <address>
                        <strong><?php echo e(setting('general.company_name')); ?></strong><br>
                        <?php echo nl2br(setting('general.company_address')); ?><br>
                        <?php if(setting('general.company_phone')): ?>
                            <?php echo e(setting('general.company_phone')); ?><br>
                        <?php endif; ?>
                        <?php echo e(setting('general.company_email')); ?>

                    </address>
                </div>
            </div>
            <div class="col-md-6">
                    <div class="">
                        <table class="table no-border">
                            <tbody>
                            <tr>
                                <th><?php echo e(trans('cheques.cheque_number')); ?>:</th>
                                <td class="text-right"><?php echo e($cheque->cheque_number); ?></td>
                            </tr>
                            <tr>
                                <th><?php echo e(trans('cheques.paid_date')); ?>:</th>
                                <td class="text-right"><?php echo e(Date::parse($cheque->paid_at)->format($date_format)); ?></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <?php echo e(trans('cheques.cheque_from')); ?>

                    <address>
                        <strong><?php echo e($cheque->person_name); ?></strong><br>
                        <?php echo nl2br($cheque->person_address); ?><br>
                        
                        <?php if($cheque->person_phone): ?>
                        <?php echo e($cheque->person_phone); ?><br>
                        <?php endif; ?>
                        <?php echo e($cheque->person_email); ?>

                    </address>
                </div>
                <div class="col-md-6">
                </div>
            </div>
            
            <?php if(count($cheque->account_details)>0): ?>
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <th><?php echo e(trans_choice('accounting.accountdetails', 1)); ?></th>
                                <th class="text-center"><?php echo e(trans_choice('general.description', 1)); ?></th>
                                <th class="text-right"><?php echo e(trans('bills.price')); ?></th>
                                <th class="text-right"><?php echo e(trans('bills.total')); ?></th>
                            </tr>
                            
                            <?php $__currentLoopData = $cheque->account_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($item->name); ?>

                                </td>

                                 <td class="text-center">
                                    <?php echo e($item->description); ?>

                                </td>
                                <td class="text-right"><?php echo money($item->price, $cheque->currency_code, true); ?></td>
                                <td class="text-right"><?php echo money($item->total, $cheque->currency_code, true); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-lg-7 col-md-7 col-sm-7">
                    <?php if($cheque->notes): ?>
                        <p class="lead"><?php echo e(trans_choice('general.notes', 2)); ?>:</p>

                        <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                            <?php echo e($cheque->notes); ?>

                        </p>
                    <?php endif; ?>
                </div>
                <div class="col-lg-5 col-md-5 col-sm-5">
                    <div class="">
                        <table class="table">
                            <tbody>
                                <?php $__currentLoopData = $cheque->totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                                <?php if($total->code != 'total'): ?>
                                    <tr>
                                        <th><?php echo e(trans($total['name'])); ?>:</th>
                                        <td class="text-right"><?php echo money($total->amount, $cheque->currency_code, true); ?></td>
                                    </tr>
                                <?php else: ?>
                                    <?php if($cheque->paid): ?>
                                        <tr class="text-success">
                                            <th><?php echo e(trans('invoices.paid')); ?>:</th>
                                            <td class="text-right">- <?php echo money($cheque->paid, $cheque->currency_code, true); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th><?php echo e(trans($total['name'])); ?>:</th>
                                        <td class="text-right"><?php echo money($total->amount, $cheque->currency_code, true); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="box-footer row no-print">
                <div class="col-md-12">
                    <a href="<?php echo e(url('expenses/cheques/' . $cheque->id . '/edit')); ?>" class="btn btn-primary">
                        <i class="fa fa-pencil-square-o"></i>&nbsp; <?php echo e(trans('general.edit')); ?>

                    </a>
                    <a href="<?php echo e(url('expenses/cheques/' . $cheque->id . '/print')); ?>" target="_blank" class="btn btn-default">
                        <i class="fa fa-print"></i>&nbsp; <?php echo e(trans('general.print')); ?>

                    </a>
                    <?php if($cheque->attachment): ?>
                        <span class="attachment">
                            <a href="<?php echo e(url('uploads/' . $cheque->attachment->id . '/download')); ?>">
                                <span id="download-attachment" class="text-primary">
                                    <i class="fa fa-file-<?php echo e($cheque->attachment->aggregate_type); ?>-o"></i> <?php echo e($cheque->attachment->basename); ?>

                                </span>
                            </a>
                            <?php echo Form::open([
                                'id' => 'attachment-' . $cheque->attachment->id,
                                'method' => 'DELETE',
                                'url' => [url('uploads/' . $cheque->attachment->id)],
                                'style' => 'display:inline'
                            ]); ?>

                            <a id="remove-attachment" href="javascript:void();">
                                <span class="text-danger"><i class="fa fa fa-times"></i></span>
                            </a>
                            <?php echo Form::close(); ?>

                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="box box-default collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo e(trans('cheques.histories')); ?></h3>
                    <!-- /.box-tools -->
                </div>
                <div class="box-body">
                    <div class="">
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo e(trans('general.date')); ?></th>
                                <th><?php echo e(trans_choice('general.statuses', 1)); ?></th>
                                <th><?php echo e(trans('general.description')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $cheque->histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(Date::parse($cheque->created_at)->format($date_format)); ?></td>
                                    <td><?php echo e(isset($cheque->status->name)?$cheque->status->name:''); ?></td>
                                    <td><?php echo e($cheque->description); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="box box-default collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo e(trans('cheques.payments')); ?></h3>
                    <!-- /.box-tools -->
                </div>
                <div class="box-body">
                    <div class="">
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo e(trans('general.date')); ?></th>
                                <th><?php echo e(trans('general.amount')); ?></th>
                                <th><?php echo e(trans_choice('general.accounts', 1)); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $cheque->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(Date::parse($payment->paid_at)->format($date_format)); ?></td>
                                    <td><?php echo money($payment->amount, $payment->currency_code, true); ?></td>
                                    <td><?php echo e(isset($payment->account->name)?$payment->account->name:''); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function(){
            $(document).on('click', '#button-payment', function (e) {
                $('#payment-modal').remove();

                var html = '';

                html += '<div class="modal fade" id="payment-modal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel">';
                html += '   <div class="modal-dialog" role="document">';
                html += '       <div class="modal-content box box-success">';
                html += '           <div class="modal-header">';
                html += '               <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                html += '               <h4 class="modal-title" id="paymentModalLabel"><?php echo e(trans('cheques.add_payment')); ?></h4>';
                html += '           </div>';
                html += '           <div class="modal-body box-body">';
                html += '               <div class="modal-message"></div>';
                html += '               <div class="form-group col-md-6 required">';
                html += '                   <?php echo Form::label('paid_at', trans('general.date'), ['class' => 'control-label']); ?>';
                html += '                   <div class="input-group">';
                html += '                       <div class="input-group-addon"><i class="fa fa-calendar"></i></div>';
                html += '                       <?php echo Form::text('paid_at', \Date::now()->format($date_format), ['id' => 'paid_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'data-mask' => '']); ?>';
                html += '                   </div>';
                html += '               </div>';
                html += '               <div class="form-group col-md-6 required">';
                html += '                   <?php echo Form::label('amount', trans('general.amount'), ['class' => 'control-label']); ?>';
                html += '                   <div class="input-group">';
                html += '                       <div class="input-group-addon"><i class="fa fa-money"></i></div>';
                html += '                       <?php echo Form::text('amount', $cheque->grand_total, ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans('general.form.enter', ['field' => trans('general.amount')])]); ?>';
                html += '                   </div>';
                html += '               </div>';
                html += '               <div class="form-group col-md-6 required">';
                html += '                   <?php echo Form::label('account_id', trans_choice('general.accounts', 1), ['class' => 'control-label']); ?>';
                html += '                   <div class="input-group">';
                html += '                       <div class="input-group-addon"><i class="fa fa-university"></i></div>';
                html += '                       <?php echo Form::select('account_id', $accounts, setting('general.default_account'), ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.accounts', 1)])]); ?>';
                html += '                   </div>';
                html += '               </div>';

                html += '<?php echo Form::hidden('currency_code', setting('general.default_currency')); ?>';

                html += '               <div class="form-group col-md-12">';
                html += '                   <?php echo Form::label('description', trans('general.description'), ['class' => 'control-label']); ?>';
                html += '                   <?php echo Form::textarea('description', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => trans('general.form.enter', ['field' => trans('general.description')])]); ?>';
                html += '               </div>';
                html += '               <div class="form-group col-md-6 required">';
                html += '                   <?php echo Form::label('payment_method', trans_choice('general.payment_methods', 1), ['class' => 'control-label']); ?>';
                html += '                   <div class="input-group">';
                html += '                       <div class="input-group-addon"><i class="fa fa-folder-open-o"></i></div>';
                html += '                       <?php echo Form::select('payment_method', $payment_methods, setting('general.default_payment_method'), ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.payment_methods', 1)])]); ?>';
                html += '                   </div>';
                html += '               </div>';
                html += '               <div class="form-group col-md-6">';
                html += '                   <?php echo Form::label('reference', trans('general.reference'), ['class' => 'control-label']); ?>';
                html += '                   <div class="input-group">';
                html += '                       <div class="input-group-addon"><i class="fa fa-file-text-o"></i></div>';
                html += '                       <?php echo Form::text('reference', null, ['class' => 'form-control', 'placeholder' => trans('general.form.enter', ['field' => trans('general.reference')])]); ?>';
                html += '                   </div>';
                html += '               </div>';
                html += '               <?php echo Form::hidden('cheque_id', $cheque->id, ['id' => 'cheque_id', 'class' => 'form-control', 'required' => 'required']); ?>';
                html += '           </div>';
                html += '           <div class="modal-footer" style="text-align: left;">';
                html += '               <button type="button" onclick="addPayment();" class="btn btn-success"><?php echo e(trans('general.save')); ?></button>';
                html += '               <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('general.cancel')); ?></button>';
                html += '           </div>';
                html += '       </div>';
                html += '   </div>';
                html += '</div>';

                $('body').append(html);

                $('#paid_at').datepicker({
                    format: '<?php echo e($date_format); ?>',
                    autoclose: true
                });
/*
                $("#account_id").select2({
                    placeholder: "<?php echo e(trans('general.form.select.field', ['field' => trans_choice('general.accounts', 1)])); ?>"
                });

                $("#payment_method").select2({
                    placeholder: "<?php echo e(trans('general.form.select.field', ['field' => trans_choice('general.payment_methods', 1)])); ?>"
                });*/

                $('#payment-modal').modal('show');
            });

            $(document).on('change', '#account_id', function (e) {
                $.ajax({
                    url: '<?php echo e(url("settings/currencies/currency")); ?>',
                    type: 'GET',
                    dataType: 'JSON',
                    data: 'account_id=' + $(this).val(),
                    success: function(data) {
                        $('#currency').val(data.currency_name);
                        $('#currency_code').val(data.currency_code);
                    }
                });
            });

            $(document).on('click', '#button-email', function (e) {
                $('#email-modal').remove();

                var html = '<div class="modal fade" id="email-modal" tabindex="-1" role="dialog" aria-labelledby="emailModalLabel">';
                html += '   <div class="modal-dialog" role="document">';
                html += '       <div class="modal-content">';
                html += '           <div class="modal-header">';
                html += '               <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                html += '               <h4 class="modal-title" id="emailModalLabel">Overflowing text</h4>';
                html += '           </div>';
                html += '           <div class="modal-body">';
                html += '               <?php echo e(trans('general.na')); ?>';
                html += '           </div>';
                html += '           <div class="modal-footer">';
                html += '               <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('general.cancel')); ?></button>';
                html += '               <button type="button" class="btn btn-success">Save changes</button>';
                html += '           </div>';
                html += '       </div>';
                html += '   </div>';
                html += '</div>';

                $('body').append(html);

                $('#email-modal').modal('show');
            });
            <?php if($cheque->attachment): ?>
            $(document).on('click', '#remove-attachment', function (e) {
                confirmDelete("#attachment-<?php echo $cheque->attachment->id; ?>", "<?php echo trans('general.attachment'); ?>", "<?php echo trans('general.delete_confirm', ['name' => '<strong>' . $cheque->attachment->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]); ?>", "<?php echo trans('general.cancel'); ?>", "<?php echo trans('general.delete'); ?>");
            });
            <?php endif; ?>
        });

        function addPayment() {
            $('.help-block').remove();

            $.ajax({
                url: '<?php echo e(url("expenses/cheques/payment")); ?>',
                type: 'POST',
                dataType: 'JSON',
                data: $('#payment-modal input[type=\'text\'], #payment-modal input[type=\'hidden\'], #payment-modal textarea, #payment-modal select'),
               
                headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                beforeSend: function() {
                    $('#payment-modal .modal-content').append('<div id="loading" class="text-center"><i class="fa fa-spinner fa-spin fa-5x checkout-spin"></i></div>');
                },
                complete: function() {
                    $('#loading').remove();
                },
                success: function(json) {
                    if (json['error']) {
                        $('#payment-modal .modal-message').append('<div class="alert alert-danger">' + json['message'] + '</div>');
                        $('div.alert-danger').delay(3000).fadeOut(350);
                    }

                    if (json['success']) {
                        $('#payment-modal .modal-message').before('<div class="alert alert-success">' + json['message'] + '</div>');
                        $('div.alert-success').delay(3000).fadeOut(350);

                        setTimeout(function(){
                            $("#payment-modal").modal('hide');

                            location.reload();
                        }, 3000);
                    }
                },
                error: function(data){
                    var errors = data.responseJSON;

                    if (typeof errors !== 'undefined') {
                        if (errors.paid_at) {
                            $('#payment-modal #paid_at').parent().after('<p class="help-block">' + errors.paid_at + '</p>');
                        }

                        if (errors.amount) {
                            $('#payment-modal #amount').parent().after('<p class="help-block">' + errors.amount + '</p>');
                        }

                        if (errors.account_id) {
                            $('#payment-modal #account_id').parent().after('<p class="help-block">' + errors.account_id + '</p>');
                        }

                        if (errors.currency_code) {
                            $('#payment-modal #currency_code').parent().after('<p class="help-block">' + errors.currency_code + '</p>');
                        }

                        if (errors.category_id) {
                            $('#payment-modal #category_id').parent().after('<p class="help-block">' + errors.category_id + '</p>');
                        }

                        if (errors.payment_method) {
                            $('#payment-modal #payment_method').parent().after('<p class="help-block">' + errors.payment_method + '</p>');
                        }
                    }
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/cheques/show.blade.php ENDPATH**/ ?>