<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('accounts.accounting.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', trans_choice('general.reconciliations', 2)); ?>

<?php $__env->startSection('new_button'); ?>
<div class="searchBox mr-2">
   <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]); ?>

    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
 <a href="<?php echo e(route('reconcile.create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Reconcile"><i class="material-icons left">add</i><?php echo e(trans_choice('general.reconciliations', 1)); ?></a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Default box -->
<div class="box box-success">
    
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-reconciliations">
            
                <thead>
                    <tr>
                        <th><?php echo e(trans('general.created_date')); ?> </th>
                        <th><?php echo e(trans_choice('general.accounts', 1)); ?></th>
                        <th><?php echo e(trans('general.period')); ?></th>
                        <th  class="amount-space"><?php echo e(trans('reconciliations.closing_balance')); ?> </th>
                        <th><?php echo e(trans_choice('general.statuses', 1)); ?></th>
                        <th><?php echo e(trans('general.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $reconciliations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><a href="<?php echo e(route('reconcile.edit', $item->id)); ?>"><?php echo e(Date::parse($item->created_at)->format($date_format)); ?></a></td>
                        <td><?php echo e(isset($item->account->name_number)?$item->account->name_number:''); ?></td>
                        <td class="hidden-xs"><?php echo e(Date::parse($item->started_at)->format($date_format)); ?> - <?php echo e(Date::parse($item->ended_at)->format($date_format)); ?></td>
                        <td class=" amount-space"><?php echo money($item->closing_balance, $item->account->currency_code, true); ?></td>
                        <td class="hidden-xs">
                            <?php if($item->reconciled): ?>
                                <span class="label label-success"><?php echo e(trans('reconciliations.reconciled')); ?></span>
                            <?php else: ?>
                                <span class="label label-danger"><?php echo e(trans('reconciliations.unreconciled')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                              <a  class="btn btn-outline-info btn-circle-iconic btn34" href="<?php echo e(route('reconcile.edit', $item->id)); ?>"><i class="material-icons">create</i></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
     
    <!-- /.box-body -->

    
    <!-- /.box-footer -->
</div>
<!-- /.box -->

<script type="text/javascript">
    $(document).ready(function(){
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/banking/reconcile/index.blade.php ENDPATH**/ ?>