<?php $__env->startSection('title', trans('general.title.new', ['type' => trans_choice('general.payments', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('expenses/payments')); ?>"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.payments', 2)); ?></a>
<?php $__env->stopSection(); ?>
<style>
    .help-block.with-errors {
    position: absolute;
    bottom: -25px !important;
    color: #f00;
    font-size: 13px;
    line-height: 8px;
}
</style>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <?php echo Form::open(['url' => 'expenses/payments', 'files' => true, 'role' => 'form']); ?>


        <div class="row">
            <div class="col-md-3">
                <?php echo e(Form::textGroup('paid_at', trans('general.date'), Date::now()->format('Y-m-d'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('amount', trans('general.amount'), null, ['id'=>'amount','required' => 'required', 'autofocus' => 'autofocus', 'data-decimals'=>"0"])); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::selectGroup('account_id', trans_choice('general.accounts', 1), $accounts, setting('general.default_account'), ['data-live-search'=>'true'])); ?>

            </div>

            <?php echo e(Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code'])); ?>


            
            
            <div class="col-lg-3 col-md-4 col-sm-6">
                
                <div class="row">
                    <div class="col-lg-10 col-md-10 col-sm-10">
                        <small><?php echo e(trans_choice('general.vendors', 1)); ?></small>
                        <?php echo Form::select('vendor_id', $vendors, null, array_merge(['id' => 'vendor_id', 'class' => 'selectpicker','data-live-search'=>'true', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.vendors', 1)])])); ?>

                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-2">
                        <div class="add-bttn pr-2">
                            <button type="button" data-toggle="modal" data-target="#modal-create-vendor"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;">add </i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <?php echo e(Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), $payment_methods, setting('general.default_payment_method'), [])); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('reference', trans('general.reference'), null)); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::fileGroup('attachment', trans('general.attachment'))); ?>

            </div>
            <div class="col-md-6">
                <?php echo e(Form::textareaGroup('description', trans('general.description'), null)); ?>

            </div>
        </div>
        <!-- /.box-body -->

        <div class="box-footer">
            <?php echo e(Form::saveButton('expenses/payments')); ?>

        </div>
        <!-- /.box-footer -->

        <?php echo Form::close(); ?>

    </div>


<div class="modal fade" id="modal-create-vendor" >
    <div class="modal-dialog  modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?php echo e(trans('general.title.new', ['type' => trans_choice('general.vendors',1)])); ?></h4>
            </div>
            <div class="modal-body">
                <?php echo Form::open(['id' => 'form-create-vendor', 'role' => 'form']); ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group  required">
                            <input class="form-control"  required="required" namename" type="text" id="name">
                            <label for="name" class="form-label"><?php echo e(trans('general.name')); ?></label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group ">
                            <input class="form-control"  required="required" name="vendor_email" type="text" id="email">
                            <label for="email" class="form-label"><?php echo e(trans('general.email')); ?></label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group  required">
                            <small><?php echo e(trans_choice('general.net_term', 1)); ?></small>
                            <?php echo Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker net_term','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])); ?>

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group   ">
                            <input class="form-control" name="phone" id="phone" type="text">
                            <label for="phone" class="form-label">Phone</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>


                    <?php echo Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_cod']); ?>

                    <div class="col-md-12">
                      <div class="form-groupTextArea  ">
                        <textarea class="form-ControlTextArea" rows="3" name="address" cols="50" id="address"></textarea>
                         <label for="address" class="form-label"><?php echo e(trans('general.address')); ?> </label>
                         <span class="form-controlBrd"></span>
                      </div>
                    </div>
                  <?php echo Form::hidden('enabled', '1', []); ?>

                </div>
              <?php echo Form::close(); ?>

            </div>
            <div class="modal-footer">
              <div class="pull-left">
                  <button type="button" id="close-modal-create-vendor" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span classfa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
                  <?php echo Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-vendor', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

              </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        //Date picker
        $('#paid_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#paid_at').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
            clearBtn: true,
            endDate: today
        });

        $(document).on('change', '#account_id', function (e) {
            $.ajax({
                url: '<?php echo e(url("settings/currencies/currency")); ?>',
                type: 'GET',
                dataType: 'JSON',
                data: 'account_id=' + $(this).val(),
                success: function(data) {
                    $('#currency').val(data.currency_name);
                    $('#currency_code').val(data.currency_code);
                }
            });
        });
    });

    $(document).on('click', '#button-create-vendor', function (e) {
        $('#modal-create-vendor .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

        $.ajax({
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '<?php echo e(url("expenses/vendors/vendor")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-create-vendor").serialize(),
            beforeSend: function () {
                $(".form-group").removeClass("has-error");
                $(".help-block").remove();
            },
            success: function(data) {
                $('#span-loader').remove();

                $('#close-modal-create-vendor').trigger('click');

                $("#vendor_id").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
               // $("#vendor_id").select2('refresh');
            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();

                if (error.responseJSON.name) {
                    $("input[name='name']").parent().parent().addClass('has-error');
                    $("input[name='name']").parent().after('<p class="help-block">' + error.responseJSON.name + '</p>');
                }

                if (error.responseJSON.email) {
                    $("input[name='email']").parent().parent().addClass('has-error');
                    $("input[name='email']").parent().after('<p class="help-block">' + error.responseJSON.email + '</p>');
                }

                if (error.responseJSON.currency_code) {
                    $("select[name='currency_code']").parent().parent().addClass('has-error');
                    $("select[name='currency_code']").parent().after('<p class="help-block">' + error.responseJSON.currency_code + '</p>');
                }
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/payments/create.blade.php ENDPATH**/ ?>