    <!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice - #<?php echo e(trans('invoices.invoice_number')); ?></title>

    <style type="text/css">
        @page  {
            margin: 0px;
        }
        body {
            margin: 0px;
        }
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        a {
            color: #000;
            text-decoration: none;
        }
        table {
            font-size: x-small;
        }
        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }
        .invoice table {
            margin: 15px;
        }
        .invoice h3 {
            margin-left: 15px;
        }
        .information {
           /* background-color: #60A7A6;*/
            color: #000;
        }
        .information .logo {
            height: 60px;
        }
        .information table {
            padding: 10px;
        }
    </style>
</head>
<body>

    <div class="information">
        <table width="100%">
            <tr>
                           
                          
                        
                    

                <td align="left" style="width: 40%;">
                    <h3><?php echo e(isset($invoice->customer->parent_re->name)?$invoice->customer->parent_re->name:$invoice->customer_name); ?></h3>
                    <address>
                        <?php echo isset($invoice->customer->parent_re->address)?nl2br($invoice->customer->parent_re->address):nl2br($invoice->customer_address); ?><br>
                       
                        <?php echo e(isset($invoice->customer->parent_re->phone)?$invoice->customer->parent_re->phone:$invoice->customer_phone); ?><br>
                       
                        <?php echo e(isset($invoice->customer->parent_re->customer_email)?$invoice->customer->parent_re->customer_email:$invoice->customer_email); ?>

                        <br/>
                        <?php echo e(trans('invoices.invoice_number')); ?> : <?php echo e($invoice->invoice_number); ?><br/> 
                        <?php echo e(trans('invoices.invoice_date')); ?> : <?php echo e(Date::parse($invoice->invoiced_at)->format($date_format)); ?><br/>
                        <?php echo e(trans('invoices.payment_due')); ?> : <?php echo e(Date::parse($invoice->due_at)->format($date_format)); ?> <br/>
                        Status: Paid
                    </address>         
                           </td>
                <td align="center" style="width: 40%;">
                     <?php if($logo): ?>
                        <img src="<?php echo e($logo); ?>" class="invoice-logo"  style="height: 60px" />
                    <?php endif; ?>
                </td>
                <td align="right" style="width: 40%;">
                    <h3><?php echo e(setting('general.company_name')); ?></h3>
                    <address>
                        <?php echo nl2br(setting('general.company_address')); ?>

                        <?php if(setting('general.company_phone')): ?>
                        <?php echo e(setting('general.company_phone')); ?><br>
                        <?php endif; ?>
                        <?php echo e(setting('general.company_email')); ?>

                    </address>
                </td>
            </tr>
        </table>
    </div>


    <br/>

    <div class="invoice">
        <h3>Invoice specification #<?php echo e($invoice->invoice_number); ?></h3>
        <table width="100%">
            <thead>
                <tr>
                    <th><?php echo e(trans('general.description')); ?></th>
                    <th class="text-center"><?php echo e(trans('invoices.quantity')); ?></th>
                    <th class="text-right"><?php echo e(trans('invoices.price')); ?></th>
                    <th class="text-right"><?php echo e(trans('invoices.total')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <?php echo e(isset($item->description)?$item->description:$item->name); ?>

                    </td>
                    <td class="text-center"><?php echo e($item->quantity); ?></td>
                    <td class="text-right"><?php echo money($item->price, $invoice->currency_code, true); ?></td>
                    <td class="text-right"><?php echo money($item->total, $invoice->currency_code, true); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

            <tfoot>
                 <?php $__currentLoopData = $invoice->totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($total->code != 'total'): ?>
                    <tr >
                        <th colspan="3"><?php echo e(trans($total['name'])); ?>:</th>
                        <td><?php echo money($total->amount, $invoice->currency_code, true); ?></td>
                    </tr>
                    <?php else: ?>
                    <?php if($invoice->paid): ?>
                    <tr class="text-success" >
                        <th colspan="3"><?php echo e(trans('invoices.paid')); ?>:</th>
                        <td>- <?php echo money($invoice->paid, $invoice->currency_code, true); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr > 
                        <th colspan="3"><?php echo e(trans($total['name'])); ?>:</th>
                        <td class="text-right"><?php echo money($total->amount - $invoice->paid, $invoice->currency_code, true); ?></td>
                    </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tfoot>
        </table>
    </div>

    <div class="information" style="position: absolute; bottom: 0;">
        <table width="100%">
            <tr>
                <td align="left" style="width: 50%;">
                    &copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.url')); ?> - All rights reserved.
                </td>
                <td align="right" style="width: 50%;">
                  Thanks For 
                </td>
            </tr>

        </table>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\resources\views/accounts/incomes/invoices/invoice.blade.php ENDPATH**/ ?>