

<?php $__env->startSection('title', trans('reports.standard.title.generalledger')); ?>

<?php $__env->startSection('new_button'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
    .red-text {
        color: red;
    }

    .text-right {
        text-align: right;
    }

    .table-show tbody {
        height: auto !important;
    }

    .profit-content {
        display: none;
    }

    .profit-link .material-icons {
        position: relative;
        top: 6px;
    }

    .first-step {
        padding-left: 1% !important;
    }

    .second-step {
        padding-left: 2% !important;
    }
</style>
<!-- Default box -->
<div class="box box-success">
    <div class="card">
        <?php echo Form::open(['url'=>'/reports/standard/general-ledger']); ?>

        <?php echo $__env->make('accounts.reports.standard.date-filter-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo Form::close(); ?>

    </div>
    <div class="box-body">
        <div class="row m-0">
            <h3><strong><?php echo e(trans('reports.standard.profitandlossdetails')); ?></strong></h3>
        </div>
        <table class="table table-show table-striped table-hover table-bordered " id="">
            <thead>
                <tr>
                    <th>ACCOUNT / DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>NAME</th>
                    <th>DESCRIPTION</th>
                    <th>AMOUNT</th>
                </tr>
            </thead>
        </table>
        
        <?php
        $incometotal = 0;
        ?>
        <?php $__currentLoopData = $lists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(count($list->chartofhistory) > 0): ?>
                <p><a class="profit-link" data-toggle="collapse" href="#innerIncomes<?php echo e($list->id); ?>" role="button" aria-expanded="false" aria-controls="innerIncomes<?php echo e($list->id); ?>"><i class="material-icons">keyboard_arrow_down</i><?php echo e($list->name); ?></a></p>
                <div class="collapse second-step" id="innerIncomes<?php echo e($list->id); ?>">
                    <div class="inner-accord">
                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <?php
                                    $total = 0;
                                    $charts = $list->chartofhistory;
                                ?>
                                <?php $__currentLoopData = $charts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    if($item->amount_type == 'add') {
                                        $total = $total + $item->amount;
                                    } else {
                                        $total = $total - $item->amount;
                                    }
                                ?>
                                <tr>
                                    <td><?php echo e(Carbon\Carbon::parse($item->created_at)->format($date_format)); ?></td>
                                    <td><?php echo e($item->transaction_type); ?></td>
                                    <td><?php echo e($item->number); ?></td>
                                    <td><?php echo e($item->name); ?></td>
                                    <td><?php echo e($item->description); ?></td>
                                    <td><?php echo e(($item->amount_type=='add')?'+':'-'); ?><?php echo money($item->amount, 'USD', true); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <table class="table table-show table-striped table-hover table-bordered table-responsive" id="">
                    <tbody>
                        <tr class="first-table">
                            <td colspan="5"><?php echo e($list->name); ?></td>
                            <td><?php echo money($total, 'USD', true); ?></td>
                        </tr>
                    </tbody>
                </table>
                <?php
                    $incometotal = $incometotal + $total;
                    $total = 0;
                ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php echo $__env->make('accounts.reports.standard.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/reports/standard/accountant/general-ledger.blade.php ENDPATH**/ ?>