

<?php $__env->startSection('title', trans_choice('reports.standard.standardreports', 1)); ?>

<?php $__env->startSection('new_button'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="box box-success">
    <div class="card">
        <?php echo Form::open(['url'=>'/reports/standard/accounts-recievables']); ?>

        <?php echo $__env->make('accounts.reports.standard.date-filter-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo Form::close(); ?>

    </div>
    <div class="box-header">
        <h3 class="box-title"><?php echo e(trans('reports.standard.accountsrecievables')); ?> Details</h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body">
        <table id="fullFeatures" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>CUSTOMER</th>
                    <th>DUE DATE</th>
                    <th>AMOUNT</th>
                    <th>OPEN BALANCE</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $gtotal = 0;
                    $total = 0;
                ?>
                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $balance = $invoice->amount - $invoice->invoice->payment_total;
                        $total = $total + $invoice->amount;
                        $gtotal = $gtotal + $invoice->amount;
                    ?>
                    <tr>
                        <td><?php echo e(Carbon\Carbon::parse($invoice->invoiced_at)->format($date_format)); ?></td>
                        <td>Invoice</td>
                        <td><?php echo e($invoice->number); ?></td>
                        <td><?php echo e($invoice->name); ?></td>
                        <td><?php echo e(Carbon\Carbon::parse($invoice->invoice->due_at)->format($date_format)); ?></td>
                        <td><?php echo money($invoice->amount, 'USD', true); ?> </td>
                        <td><?php echo money($balance, 'USD', true); ?> </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $others; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $balance = $invoice->amount;
                        $total = $total + $invoice->amount;
                        $gtotal = $gtotal + $invoice->amount;
                    ?>
                    <tr>
                        <td><?php echo e(Carbon\Carbon::parse($invoice->created_at)->format($date_format)); ?></td>
                        <td><?php echo e($invoice->transaction_type); ?></td>
                        <td><?php echo e($invoice->number); ?></td>
                        <td><?php echo e($invoice->name); ?></td>
                        <td><?php echo e(Carbon\Carbon::parse($invoice->created_at)->format($date_format)); ?></td>
                        <td><?php echo money($balance, 'USD', true); ?> </td>
                        <td><?php echo money($balance, 'USD', true); ?> </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr class="bg-success">
                    <td colspan="5"> <strong>Totals</strong> </td>
                    <td><?php echo money($total, 'USD', true); ?></td>
                    <td><?php echo money($gtotal, 'USD', true); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="box-footer">
    </div>
    <!-- /.box-body -->
</div>
<!-- /.box -->

<?php echo $__env->make('accounts.reports.standard.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/reports/standard/owes/accounts-recievables.blade.php ENDPATH**/ ?>