 

<?php $__env->startSection('title','Assign Consultant Payrates'); ?>

<?php $__env->startSection('new_button'); ?>

<div class="searchBox mr-2">

   <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]); ?>


    <span class="search-icn"><i class="material-icons">search</i></span>

    <span class="form-controlBrd"></span>

</div>

	<a href="<?php echo route('consultnatpayrates.create'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Consultant Payrates"><i class="material-icons left">add</i><?php echo e(__('Pay rates')); ?> </a>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>



<!-- page content -->

<table class="table  table-show table-bordered table-filter">

	<thead>

		<tr>

			<th>Consultant</th>

			<th>Vendor Company</th>

			<th>Vendor Payrate - Reg</th>

			<th>Vendor Payrate - OT</th>

			<th>Payrate Type</th>

			<th>From Hours</th>

			<th>To Hours</th>

			<th>From Date</th>

			<th>To Date</th>

			<th>Consultant Payrate - Reg</th>

			<th>Consultant Payrate - OT</th>

			<th>Employer Payrate - Reg</th>

			<th>Employer Payrate - OT</th>

		</tr>

	</thead>



	<tbody>

		<?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $li): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

			<tr>

				<td><?php echo e($li->consultant?->name); ?></td>

				<td><?php echo e($li->vendor?->name); ?></td>

				<td><?php echo e($li->vendor_payrate_reg); ?></td>

				<td><?php echo e($li->vendor_payrate_ot); ?></td>

				<td><?php echo e($li->rate_type); ?></td>

				<td><?php echo e($li->from); ?></td>

				<td><?php echo e($li->to); ?></td>

				<td><?php echo e(Carbon\Carbon::parse($li->from_date)->format($date_format)); ?></td>

				<td><?php echo e(Carbon\Carbon::parse($li->to_date)->format($date_format)); ?></td>

				<?php if($li->rate_type == 'fixed'): ?>

				<td><?php echo e($li->reg_rate); ?></td>

				<td><?php echo e($li->ot_rate); ?></td>

				<td></td>

				<td></td>

				<?php else: ?>

				<td><?php echo e($li->percent_reg); ?> <?php echo e(($li->consultant_percentage_reg != '')?'('.$li->consultant_percentage_reg.'%)':''); ?></td>

				<td><?php echo e($li->percent_ot); ?> <?php echo e(($li->consultant_percentage_ot != '')?'('.$li->consultant_percentage_ot.'%)':''); ?></td>

				<td><?php echo e($li->company_payrate_reg); ?> <?php echo e(($li->company_payrate_reg != '')?'('.$li->company_percentage_reg.'%)':''); ?></td>

				<td><?php echo e($li->company_payrate_ot); ?> <?php echo e(($li->company_payrate_reg != '')?'('.$li->company_percentage_ot.'%)':''); ?></td>

				<?php endif; ?>			

			</tr>

		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

		<?php if(count($list) == 0): ?>
		
			<tr>
				<td class="text-center" colspan="13">No Data</td>
			</tr>

		<?php endif; ?>

	</tbody>

</table>

<!-- /page content -->



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/payrates/consultants-payrates.blade.php ENDPATH**/ ?>