<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('accounts.expenses.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', trans_choice('general.vendors', 2)); ?>

<?php $__env->startSection('new_button'); ?>


<div class="searchBox mr-2">
   <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]); ?>

    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>

<a href="<?php echo e(url('common/import/expenses/vendors')); ?>" class="btn mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left rotate90deg">
last_page
</i> <?php echo e(trans('import.import')); ?></a>

<a href="<?php echo e(url('expenses/vendors/billcenter')); ?>" class="btn mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">star</i> <?php echo e(trans('customers.bill_center')); ?></a>
<a href="<?php echo e(url('expenses/vendors/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Vendors"><i class="material-icons left">add</i> <?php echo e(trans_choice('general.vendors', 2)); ?></a>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<!-- Default box -->
<div class="box box-success">
    

    <div class="">
        <div class="wid100-Hidden">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-vendors">
            
                <thead>
                    <tr>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('name', trans('general.name')));?></th>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('email', trans('general.email')));?></th>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('phone', trans('general.phone')));?></th>
                        <th ><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('enabled', trans_choice('general.statuses', 1)));?></th>
                        <th ><?php echo e(trans('general.actions')); ?></th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><a href="<?php echo e(url('expenses/vendors/' . $item->id . '/edit')); ?>"><?php echo e($item->name); ?></a></td>
                        <td class="hidden-xs"><?php echo e(!empty($item->vendor_email) ? $item->vendor_email : trans('general.na')); ?></td>
                        <td><?php echo e($item->phone); ?></td>
                        <td class="hidden-xs">
                            <?php if($item->enabled): ?>
                                <span class="label label-success"><?php echo e(trans('general.enabled')); ?></span>
                            <?php else: ?>
                                <span class="label label-danger"><?php echo e(trans('general.disabled')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="pull-center">
                                <a href="<?php echo e(url('/expenses/bills/vendor_expense')); ?>/<?php echo e($item->id); ?>"><?php echo e(trans('general.create_expense')); ?></a>
                                
                            </div>
                        </td>
                        <td>
                            <div class="position-relative">
                                <div class="btn-group ">
                                    <div class="dropdown moreIcon" >
                                        <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <li><a href="<?php echo e(url('/expenses/vendor_cheque')); ?>/<?php echo e($item->id); ?>">Write cheque</a></li>
                                            <li><a href="<?php echo e(url('expenses/vendors/' . $item->id . '/edit')); ?>"><?php echo e(trans('general.edit')); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                    </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->
    
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/vendors/index.blade.php ENDPATH**/ ?>