
<?php $__env->startSection('title', 'Edit meeting'); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo route('meetings.index'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> list </i>My Meetings List
</a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    .right-bar {
        border-right: solid blue 1px;
    }
</style>
<!-- page content -->
<div class="card">
    <?php echo e(Form::model($meeting, ['route'=>['meetings.update', $meeting->id], 'method'=>'PUT', 'role'=>'form', 'id'=>'editForm'])); ?>

    <legend>Meeting Info</legend>
    <div class="row">
        <div class="col-md-3">
            <?php echo e(Form::textGroup('subject', 'Meeting Topic', null, ['id'=>'subject', 'required'=>'required'])); ?>

        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            <?php echo e(Form::selectGroup('venue', 'Select Venue', $venues, $meeting->venue, ['class'=>'selectpicker', 'title'=>'Select Venue'])); ?>

        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            <?php echo e(Form::textGroup('number', 'Meeting No.', 'MOM-0'.$meeting->number, ['id'=>'number', 'required'=>'required'])); ?>

        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            <?php echo e(Form::textGroup('organised_by', 'Organised By', ucwords(auth()->user()->name)), ['id'=>'organise', 'readonly']); ?>

        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            <?php echo e(Form::textGroup('date', 'Date', date('d-m-Y', strtotime($meeting->date)),['id' => 'todaydate', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'required'=>'required', 'placeholder'=>'yyyy-mm-dd'])); ?>

        </div>
        <div class="col-md-3 col-lg-3 col-sm-12">
            <small>Time (24hr's) <?php echo e(redStar()); ?></small>
            <div class="row">
                <div class="col-md-6 col-lg-6 col-sm-12">
                    <?php echo e(Form::selectRange('time1', 1, 12, $meeting->time, ['class'=>'selectpicker'])); ?>

                </div>
                <div class="col-md-6 col-lg-6 col-sm-12">
                    <?php echo e(Form::selectRange('time2', 0, 59, $meeting->time1, ['class'=>'selectpicker'])); ?>

                </div>
            </div>
        </div>
        <div class="col-md-4 col-lg-4 col-sm-12">
            <div class="row">
                <div class="col-md-6 col-lg-6 col-sm-12 pt-4">
                    <?php echo e(Form::radio('time3', 1, ($meeting->time2 == 1)?true:false)); ?> AM
                    <?php echo e(Form::radio('time3', 2, ($meeting->time2 == 2)?true:false)); ?> PM
                </div>
                <div class="col-md-6 col-lg-6 col-sm-12">
                    <small>Select Duration (Min)</small>
                    <?php echo e(Form::selectRange('duration', 1, 200, $meeting->duration, ['class'=>'selectpicker', 'title'=>'Select Venue'])); ?>

                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12 col-lg-12 col-sm-12 pl-0">
        <div class="col-md-12 col-lg-12 col-sm-12 pl-0">
            <div class="col-md-3 col-lg-3 col-sm-12 pl-0">
                <?php echo e(Form::selectGroup('participants[]', 'Select Participants', $participants, null, ['class'=>'selectpicker', 'multiple', 'title'=>'Select Participants', 'id'=>'partsSelect', 'data-live-search'=>'true'])); ?>

            </div>
        </div>
        <div class="col-md-12 col-lg-12 col-sm-12 p-0 mt-3 mb-3">
            <h6><u>Participants:</u></h6>
            <div class='row' id="usersDiv">
                <?php $__currentLoopData = $mparticipants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($p->user_id != auth()->user()->id): ?>
                    <div class="col-lg-3 col-md-3 col-sm-12 right-bar">
                        <span class="pull-left"><?php echo e(ucwords($p->user->name)); ?> <input type="hidden" name="pids[]" value="<?php echo e($p->user_id); ?>" /></span>
                        <span class="pull-right"><b id="sts<?php echo e($p->id); ?>"><?php if($p->status==1): ?>Attended <?php else: ?> Not Attended <?php endif; ?></b> <input type="checkbox" onchange="statusChange(<?php echo e($p->id); ?>)" name="sts[]" value="<?php echo e($p->user_id); ?>" <?php if($p->status == 1): ?> checked <?php endif; ?> id="chk<?php echo e($p->id); ?>" /></span>
                    </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(count($mparticipants) == 0): ?>
                    <div class="col-lg-3 col-md-3 col-sm-3">No one selected</div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="col-md-12 col-lg-12 col-sm-12 pl-0">
        <h3>Recurring</h3>
        <div class="row">
            <div class="col-md-4 pt-4">
                <input type="checkbox" name="weeks[]" value="1" <?php echo e(in_array(1, $weeks)?'checked':''); ?> /> Mon
                <input type="checkbox" name="weeks[]" value="2" <?php echo e(in_array(2, $weeks)?'checked':''); ?> /> Tue
                <input type="checkbox" name="weeks[]" value="3" <?php echo e(in_array(3, $weeks)?'checked':''); ?> /> Wed
                <input type="checkbox" name="weeks[]" value="4" <?php echo e(in_array(4, $weeks)?'checked':''); ?> /> Thu
                <input type="checkbox" name="weeks[]" value="5" <?php echo e(in_array(5, $weeks)?'checked':''); ?> /> Fri
                <input type="checkbox" name="weeks[]" value="6" <?php echo e(in_array(6, $weeks)?'checked':''); ?> /> Sat
                <input type="checkbox" name="weeks[]" value="7" <?php echo e(in_array(7, $weeks)?'checked':''); ?> /> Sun
            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('rdate', 'Recurring End Date', $meeting->recursion_end,['id' => 'rdate', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'required'=>'required', 'placeholder'=>'yyyy-mm-dd'])); ?>

            </div>
        </div>
    </div>

    <div class="row">
        <h3 class="pl-3 mt-4">Meeting Agenda</h3>
        <div class="form-groupTextArea col-md-12">
            <?php echo Form::textareaGroup('agenda', 'Meeting Agenda', $meeting->agenda, ['class' => 'form-ControlTextArea', 'id'=>'agenda']); ?>

        </div>
        <h3 class="pl-3 mt-2">Discussion Points</h3>
        <div class="form-groupTextArea col-md-12">
            <?php echo Form::textareaGroup('dpoints', 'Discussion Points', $meeting->dpoints, ['class' => 'form-ControlTextArea', 'id'=>'dpoints']); ?>

        </div>
    </div>

    <div class="row pl-3 pr-3">
        <h3 class="pl-0 mt-4">Issues Statements</h3>
        <?php $__currentLoopData = $issues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $issue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-12 col-lg-12 card" id="div<?php echo e($issue->id); ?>">
            <div class="col-md-12 col-lg-12 col-sm-12" style="display: inline-flex;">
                <div class="col-md-3 col-lg-3 col-sm-12 pl-0" style="display: inline-flex;">
                    <div class="col-md-12 col-lg-12 col-sm-12 pl-0">
                        <div class="col-md-12 col-lg-12 col-sm-12 pl-0 mb-4">
                            <?php echo e(Form::selectGroup('rparticipants[]', ' Select Participant', $participants, $issue->user_id, ['class'=>'selectpicker rpselect', 'id'=>'select1', 'onchange'=>'changeRadio(1)', 'data-live-search'=>'true', 'title'=>'Select Participnt'])); ?>

                        </div>
                        <div class="form-group"> 
                            <input class="form-control consultant1" name="" type="text" value="<?php echo e($issue->consultant); ?>">
                            <label for="" class="form-label">Consultant Name</label> <span class="form-controlBrd"></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-12 pl-0">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="form-group">
                            <input class="form-control issue<?php echo e($issue->user_id); ?>" required="required" name="issue<?php echo e($issue->user_id); ?>" type="text" value="<?php echo e($issue->issue); ?>">
                            <label for="lblissue<?php echo e($issue->user_id); ?>" class="form-label lablissue1">Issue Statement</span></label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
    
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="form-group">
                            <input class="form-control solution<?php echo e($issue->user_id); ?>" required="required" name="solution<?php echo e($issue->user_id); ?>" type="text" value="<?php echo e($issue->solution); ?>">
                            <label for="lblsolution<?php echo e($issue->user_id); ?>" class="form-label lblsolution1">Solution Statement</span></label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-2 col-lg-2 col-sm-12 mt-3">
                    <label for="">Resolved ?</label>
                    <p> <input name="sts<?php echo e($issue->user_id); ?>" value="1" type="radio" class="<?php echo e($issue->user_id); ?>"  <?php echo e(($issue->status == 1)?'checked':''); ?>/> Yes</p>
                    <p> <input name="sts<?php echo e($issue->user_id); ?>" value="0" type="radio" class="<?php echo e($issue->user_id); ?>"  <?php echo e(($issue->status == 0)?'checked':''); ?>/> No</p>
                </div>

                <div class="col-md-1 col-lg-1 col-sm-12 mt-3">
                    <button type="button" class="btn btn-xs btn-outline-info" onclick="removeDiv(<?php echo e($issue->id); ?>)">Remove Row</button>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div id="issuesDiv" class="col-md-12 col-sm-12 col-lg-12 ml-0 pl-0 pr-0 mr-0"></div>
        <div class="col-lg-12 col-md-12 col-sm-12 pr-0">
            <?php echo e(Form::button('Add Row', ['class'=>'btn btn-primary pull-right', 'onclick'=>'addRow()'])); ?>

        </div>
    </div>

    <div class="form-group no-margin text-right mt-3">
        <a href="<?php echo e(url('/home')); ?>" class="btn mr-3 btn-default waves-effect waves-gray">Cancel</a>
        <button type="submit" class="btn btn-primary waves-effect waves-light" name="draft" value="1" <?php if($meeting->status == 3 || $meeting->status == 2): ?> disabled <?php endif; ?>>Save as Draft</button>
        <button type="submit" class="btn btn-primary waves-effect waves-light" name="send_mail" value="1" <?php if($meeting->status == 3): ?> disabled <?php endif; ?>>Save & Send Mail</button>
        <button type="submit" class="btn btn-primary waves-effect waves-light" name="completed" value="1" <?php if($meeting->status == 3): ?> disabled <?php endif; ?>>Save & Completed</button>
    </div>
    <?php echo e(csrf_field()); ?>

    </form>

</div>
<!-- /page content -->

<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>
<?php echo e(Form::hidden('fcontrol', '', ['id'=>'fcontrol'])); ?>

<script>
    var config = {};
    config.toolbarGroups = [
    { name: 'basicstyles', groups: [ 'basicstyles'] },
    { name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align'] },
    { name: 'styles' },
    { name: 'colors' },
    ];
	CKEDITOR.replace('agenda', config);
    CKEDITOR.replace('dpoints', config);
    
    var today = new Date();
    $('#todaydate').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
    $('#todaydate').datepicker({
        format: 'yyyy-mm-dd',
        todayHighlight: true,
        clearBtn: true,
        endDate: today
    });
    $('#rdate').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
    $('#rdate').datepicker({
        format: 'yyyy-mm-dd',
        todayHighlight: true,
        clearBtn: true,
        endDate: today,
        minDate: today,
    });
    $('#timepicker').timepicker();

    $("#partsSelect").on('change', function() {
        var participants = $("#partsSelect").val();
        $.ajax({
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '<?php echo e(route('participants')); ?>',
            type: 'post',
            data: 'ids='+participants,
            success: function(result) {
                $("#usersDiv").html('');
                $(result).each(function( index, value ) {
                    var item = '<div class="col-md-3 col-lg-3 col-sm-3" style="border-right: solid blue 1px;"><span class="pull-left">'+value['name']+'<input type="hidden" name="pids[]" value="'+value['id']+'" /></span> <span class="pull-right">Status <input type="checkbox" name="sts[]" value="'+value['id']+'" /></span></div>';
                    $("#usersDiv").append(item);
                });
            }
        });
    });

    function statusChange(id) {
        if($("#chk"+id).prop("checked") == true){
            $("#sts"+id).html('Attended');
        }
        else if($("#chk"+id).prop("checked") == false){
            $("#sts"+id).html('Not Attended');
        }
    }
    
    var mparticipants = <?php echo e(json_encode($mpids)); ?>;
    $(mparticipants).each(function(index, value) {
        $('#partsSelect option[value=' + value + ']').attr('selected', true);
    });

    /* Adding New Row */
    function addRow() {
    var newDivId = Math.floor(Math.random() * 100);
    var newpart = '<select title="Select Participant" class="selectpicker rpselect" id="select'+newDivId+'" name="rparticipants[]" onchange="changeRadio('+newDivId+')"> <option value="">Select Country</option><?php $__currentLoopData = $participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c=>$part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($c); ?>"><?php echo e($part); ?> </option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </select>';
    var newstd = '<div class="form-group"> <input class="form-control has-value consultant'+newDivId+'" name="" type="text" value=""> <label for="" class="form-label">Consultant Name</label> <span class="form-controlBrd"></span> </div>';
    
    var newRow  ='<div class="col-md-12 col-lg-12 card" style="display: inline-flex;" id="div'+newDivId+'">';
        newRow +='<div class="col-md-12 col-lg-12 col-sm-12" style="display: inline-flex;">';
        newRow +='    <div class="col-md-3 col-lg-3 col-sm-12 pl-0">';
        newRow +=' <div class="col-md-12 col-lg-12 col-sm-12 pl-0 mb-4">';
            newRow +=' <small> Select Participant</small>';
            newRow += newpart;
            newRow +=' </div>';
        newRow +=' <div class="col-md-12 col-lg-12 col-sm-12 pl-0">';
            newRow += newstd;
            newRow +=' </div>';
        newRow +='    </div>';
        newRow +='    <div class="col-md-6 col-lg-6 col-sm-12 pl-0">';
        newRow +='       <div class="form-group">';
        newRow +='           <input class="form-control has-value issue'+newDivId+'" name="" type="text" value="">';
        newRow +='           <label for="" class="form-label lblissue'+newDivId+'">Issue or Statement</label>';
        newRow +='           <span class="form-controlBrd"></span>                        ';
        newRow +='       </div>';
        newRow +='       <div class="form-group">';
        newRow +='           <input class="form-control has-value solution'+newDivId+'" name="" type="text" value="">';
        newRow +='           <label for="]" class="form-label lblsolution'+newDivId+'">Solution or Statement</label>';
        newRow +='           <span class="form-controlBrd"></span>                        ';
        newRow +='       </div>';
        newRow +='    </div>';
        newRow +='    <div class="col-md-2 col-lg-2 col-sm-12 mt-3">';
        newRow +='          <label>Resolved ?</label>';
        newRow +='          <p> <input name="" type="radio" value="1" class="'+newDivId+'" /> Yes </p>';
        newRow +='          <p> <input name="" type="radio" value="0" class="'+newDivId+'" /> No </p>';
        newRow +='    </div>';
        newRow +='    <div class="col-md-1 col-lg-1 col-sm-12 mt-3">';
        newRow +=       '<button class="btn btn-xs btn-outline-info" onclick="removeDiv('+newDivId+')">Remove Row</button>'; 
        newRow +='    </div>';
        newRow +='</div>';
        newRow +='</div>';

        $("#issuesDiv").append(newRow);
        $(".selectpicker").selectpicker('refresh');
    }

    function removeDiv(id) {
        $("#div"+id).remove();
    }

    function changeRadio(rps) {
        var rid = $("#select"+rps).val();
        $("."+rps).prop('name', 'sts'+rid);
        $(".consultant"+rps).prop('name', 'consultant'+rid);
        $(".lablconsultant"+rps).prop('for', 'consultant'+rid);
        
        $(".issue"+rps).prop('name', 'issue'+rid);
        $(".lablissue"+rps).prop('for', 'issue'+rid);
        
        $(".solution"+rps).prop('name', 'solution'+rid);
        $(".lblsolution"+rps).prop('for', 'solution'+rid);
    }

    $("#editForm input").click(function() {
        $("#fcontrol").val(1);
    });
    // Event listener for the  
    // 'beforeunload' event 
    window.addEventListener('beforeunload', function (e) {
        // Check if any of the input 
        // fields are filled 
        fcontrol = $("#fcontrol").val();
        if (fcontrol != '') { 

            // Cancel the event and 
            // show alert that the unsaved 
            // changes would be lost 
            e.preventDefault(); 
            e.returnValue = ''; 
        } 
    }); 
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/meetings/edit.blade.php ENDPATH**/ ?>