use Carbon\Carbon;


<?php $__env->startSection('title', trans('invoices.receive_payment') . 'for  ' . $customer_parent->original['full_name']); ?> 
<?php $__env->startSection('new_button'); ?>
<button type="button" data-toggle="modal" data-target="#modal-create-cashback" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">add</i> Discounts / Cashback </button> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<style type="text/css">
input[type=number]::-webkit-inner-spin-button, 
input[type=number]::-webkit-outer-spin-button { 
  -webkit-appearance: none; 
}

input[type=number] {
  -moz-appearance: textfield;
}

</style>

<!-- Default box -->
<div class="card">
    <?php echo Form::open(['url' => 'incomes/invoices/customerpayment', 'files' => true, 'id' =>  'customerpayment','role' => 'form']); ?>


    <div class="row">
        <div class="col-md-3">
            <?php echo e(Form::textGroup('name', trans('general.coustomer_name'), $customer->name, ['disabled' => 'disabled'])); ?>

        </div>
        <div class="col-md-3">
            <?php echo e(Form::textGroup('paid_at', trans('general.date'), Date::now()->format(env('APP_DATE')), ['id' => 'paid_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'mm-dd-yyyy\'', 'data-mask' => ''])); ?>

        </div>
        <div class="col-md-3">
            <?php echo e(Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), $payment_methods, isset($customer->payment_method)?$customer->payment_method:config('accounts.payment_method'), [])); ?>

        </div>
        <div class="col-md-3">
            <?php echo e(Form::selectGroup('account_id', trans_choice('general.depositto', 1), $accounts, setting('general.default_account'),['data-live-search'=>'true'])); ?>

        </div>

        <div class="col-lg-3 col-md-4 col-sm-6" id="payment_sub"></div>

        <?php echo e(Form::hidden('account_chart_id', null, ['id'=>'account_chart_id'])); ?>

        <?php echo e(Form::hidden('customer_id', isset($customer->id))); ?>   
        <?php echo Form::hidden('currency_code', 'USD' , ['id' => 'currency_code']); ?>

        </div>
    </div>

        <div class="row m-0">
            <h3 class="item-title">Outstanding Transactions</h3>
           
                <table class="table table-bordered table-hover tabl-payment table-striped" id="items">
                    <thead>
                        <tr >
                            <th>
                               <label class="custom-control overflow-checkbox">
                               <input type="checkbox" class="overflow-control-input" id="check_all">
                               <span class="overflow-control-indicator"></span>
                               </label>
                            </th>
                            <th><?php echo e(trans('general.description')); ?></th>
                            <th><?php echo e(trans('invoices.due_date')); ?></th>
                            <th><?php echo e(trans('general.totalamount')); ?></th>
                            <th><?php echo e(trans('general.recivedamount')); ?></th>
                            <th><?php echo e(trans_choice('general.balance', 2)); ?></th>
                            <th><?php echo e('Discount Account'); ?></th>
                            <th><?php echo e('Discount'); ?></th>
                            <th><?php echo e(trans_choice('general.payments',1)); ?></th>
                        </tr>
                    </thead> 
                    <tbody>
                        <?php foreach($payments_lists as $k=> $payments_list){
                           
                                if(!( $payments_list->payments_total->isEmpty() )){
             
                                   $paid_amount = $payments_list->payments_total[0]['paid_amount'];
                                }
                                else{
                                    $paid_amount = 0;
                                }
                        ?>
                        <tr style="white-space: nowrap; <?php echo e((\Carbon\Carbon::now() > $payments_list->due_at) ? 'color: #f90000' : ''); ?>">
                            <td style="display: flex;">
                                   <label class="custom-control overflow-checkbox">
                                   <input type="checkbox"  class="overflow-control-input check_box"  value="<?php echo e($k); ?>" id="check_box_<?php echo e($k); ?>" <?php echo e(($payments_list->id == $invoice_id)?'checked':''); ?> >
                                   <span class="overflow-control-indicator"></span>
                                   </label>
                            </td>
                        	<td class="receive-pay-info"><?php echo e($payments_list->invoice_number . $payments_list->notes); ?></td>
                        	<td><?php echo e(Date::parse($payments_list->due_at)->format($date_format)); ?></td>
                            <td> <?php echo money($payments_list->amount, $payments_list->currency_code, true); ?> </td>
                        	<td> <?php echo money($paid_amount, $payments_list->currency_code, true); ?></td>
                            <td ><?php echo money(($payments_list->amount - $paid_amount),$payments_list->currency_code, true); ?>
                                <input type="hidden" name="balance_hidden[]" id="balance_hidden_<?php echo e($k); ?>" value="<?php echo e(($payments_list->amount - $paid_amount)); ?>" >
                            </td>
                            <td>
                                <select name="discount_account[]"  onchange="addChartofAccount(event)" id="disc_acct_select<?php echo e($k); ?>" class="selectpicker" data-live-search="true">
                                    <?php echo Cache::get('account_details_option'); ?>

                                </select>
                            </td>
                            <td>
                                <?php
                                $amt = $payments_list->amount - $paid_amount
                                ?>
                                <?php echo e(Form::textGroup('discount[]', 'Discount', 0, ['id'=>'discount_'.$k, 'min'=>0, 'class'=>'form-control disc', 'max'=>$amt, 'onkeyup,onblur'=>'applyDiscount('.$k.')'])); ?>

                            </td>
                        	<td>
                                <div class="form-group">                                
                                    <input type="number" name="amount[]"  min="0" max="<?php echo e(($payments_list->amount - $paid_amount)); ?>" value="<?php echo e(($payments_list->id == $invoice_id)?($payments_list->amount - $paid_amount):''); ?>" id="amount_<?php echo e($k); ?>"  class="form-control amount"  step="any"> 
                                    <label class="form-label">Amount</label>
                                    <span class="form-controlBrd"></span>
                                    <input type="hidden" id="invoice_amount_<?php echo e($k); ?>" value="<?php echo e($payments_list->amount - $paid_amount); ?>">
                                </div>
                            </td>

                            <?php echo Form::hidden('invoice_id[]', $payments_list->id, ['id' => 'invoice_id', 'class' => 'form-control', 'required' => 'required']); ?>

                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
           
            <div class="col-md-12 ">
                <div class="col-md-offset-5 col-md-2 pull-right">
                    <label class="control-label">Total Amount:</label>  
                    <label id="total_applied_amount"></label>    
                </div> 
            </div>
        </div>

      <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6">
            <?php echo e(Form::textareaGroup('notes', trans_choice('general.notes', 2))); ?>

        </div>
         <div class="col-lg-6 col-md-6 col-sm-6 pull-right mrg-top-5">
             <div id="payment_id"></div>
        <?php echo e(Form::saveButton('Save incomes/invoices')); ?>

         </div>
    </div>
   

    <?php echo Form::close(); ?>



<script>
    function applyDiscount(id) {
        $("#disc_acct_select"+id).prop('required', false);
        var bal = $("#balance_hidden_"+id).val();
        var disc = $("#discount_"+id).val();
        if(+disc <= +bal) {
            var ttl = +bal - +disc;
            $("#amount_"+id).val(ttl);
            $("#disc_acct_select"+id).prop('required', true);
        } else {
            var ttl = 0;            
            $("#amount_"+id).val(bal);
            $("#discount_"+id).val(0);
            $("#disc_acct_select"+id).prop('required', false);
        }
    }
</script>
<?php $__currentLoopData = $payments_lists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $payments_list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="card">
    <div class="box-header with-border">
        <h3 class="box-title"><?php echo e($payments_list->invoice_number . $payments_list->notes); ?></h3>
        <!-- <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
        </div> -->
    </div>
    <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6">
            <div class="box box-default ">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo e(trans('invoices.histories')); ?></h3>
                </div>
                <div class="box-body">
                    <div class="">
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo e(trans('general.date')); ?></th>
                                <th><?php echo e(trans_choice('general.statuses', 1)); ?></th>
                                <th><?php echo e(trans('general.description')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $payments_list->histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $histories): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(Date::parse($histories->created_at)->format($date_format)); ?></td>
                                    <td><?php echo e($histories->status->name); ?></td>
                                    <td><?php echo e(isset($histories->description)?$histories->description:''); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6 col-md-6 col-sm-6">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo e(trans('invoices.payments')); ?></h3>
                </div>
                <div class="box-body">
                    <div class="">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th><?php echo e(trans('general.date')); ?></th>
                                <th><?php echo e(trans('general.amount')); ?></th>
                                <th><?php echo e(trans_choice('general.accounts', 1)); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $payments_list->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(Date::parse($payment->paid_at)->format($date_format)); ?></td>
                                    <td><?php echo money($payment->amount, $payment->currency_code, true); ?></td>
                                    <td><?php echo e(isset($payment->account->name_number)?$payment->account->name_number:'Credit Memo'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('accounts/common/models/chartofaccount',['account_details_name'=>$account_details_name,'types'=>$types], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<script  src="<?php echo e(asset('accounts/chartofaccounts/accounting.js')); ?>">  </script>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript">
  $(function() {
  var minimized_elements = $('#items tbody tr td.receive-pay-info');
  minimized_elements.each(function() {
    var t = $(this).text();
    if (t.length < 50) return;

    $(this).html(
      t.slice(0, 50) + '<span>... </span><a href="#" class="more">Read More</a>' +
      '<span style="display:none;">' + t.slice(50, t.length) + ' <a href="#" class="less">Less</a></span>'
    );

  });

  $('a.more', minimized_elements).click(function(event) {
    event.preventDefault();
    $(this).hide().prev().hide();
    $(this).next().show();
  });

  $('a.less', minimized_elements).click(function(event) {
    event.preventDefault();
    $(this).parent().hide().prev().show().prev().show();
  });

});
</script>

<script type="text/javascript">
    // Create USD currency formatter.
    var formatter = new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: 'USD',
    }); 

    window.onload = function() { 
        var account_id = '<?php echo e(setting('general.default_account')); ?>';
            $.ajax({
            url  : '<?php echo e(url('banking/tranfers/chart_id/')); ?>'+'/'+account_id,
            type : 'GET',
            success : function(data){
                $('#account_chart_id').val(data);
            },
            error:function(data){
                console.log(data);
            }
        }); 
        amount_sum();
    }
    $(document).ready(function(){

        var payment_type = $('#payment_method').val();
        PaymentType(payment_type);
        $('#account_id').on('change',function(){               
            var account_id = $(this).val();
                $.ajax({
                url  : '<?php echo e(url('banking/tranfers/chart_id/')); ?>'+'/'+account_id,
                type : 'GET',
                success : function(data){
                    $('#account_chart_id').val(data);
                },
                error:function(data){
                    console.log(data);
                }
            });
        });

        
        $('#payment_method').change(function(){
            var payment_type = $(this).val();
                $('#payment_sub').html('');
                PaymentType(payment_type);   
        });
        $(".check_box").on('change',function(){
            var c = this.checked;
            let row = this.value;
            if(c){
                $("#amount_"+row).val($('#invoice_amount_'+row).val());
                $("#amount_"+row).addClass('has-value');
            }else{
                $("#amount_"+row).val('');
                $("#amount_"+row).removeClass('has-value');
            }
            if ($('.check_box:checked').length == $('.check_box').length) {
                    $('#check_all').prop('checked',true);
            }else{
                $('#check_all').prop('checked',false);
            }
            amount_sum();
        });  
        $("input[type='number']").on('keyup',function(){
            amount_sum();
        });


        $("#check_all").on('change',function(){

            if(this.checked){ 
                
                if ($('.check_box:checked').length == $('.check_box').length) {
                        $('#check_all').prop('checked',true);
                        $('.check_box').prop('checked',true);
                    
                        //$('.check_box').val('34');
                        
                }else{
                    $('.check_box').prop('checked',true);
                }
            }else{
                $('.check_box').trigger('click'); 
            }
            $(".check_box:checked").each(function(){
                var id = $(this).attr("id").split('_');
                $('#amount_'+id[2]).val($('#invoice_amount_'+id[2]).val());
                $('#amount_'+id[2]).addClass('has-value');
            });
            amount_sum();
        });
        
        $('#customerpayment').submit(function() {
            var elements = $("input[name='amount[]']");
            var validated = false;
            elements.each(function() {
                if ($(this).val() != '' && $(this).val() != 0) {
                    validated = true;
                }
            });
            if(validated == false)  {
                $('#payment_id').html('<p style="color:blue;margin-left:20px"> Please Enter Amount </p>').fadeOut(10000);
            }   
            return validated;
        });
        $("#paid_at").inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
                    //Date picker
        $('#paid_at').datepicker({
            format: '<?php echo e($date_format); ?>',
            autoclose: true
        });

    });
    function amount_sum(){
        var total = 0;
        $("input[name='amount[]']").each(function(){
            if(this.value){
                total += +this.value;
            }
        });
        

        $('#total_applied_amount').html(formatter.format(total));
    }


    function PaymentType(payment_type){
        if(payment_type == 2){
            
            modal =  '<div class="form-group">';
            modal +=  '<input class="form-control" placeholder="Enter Refernce Number" name="reference" id="reference" type="text">';
            modal +=  '<label for="Refernce Number" class="control-label">Refernce Number</label>';
            modal +=  '<span class="form-controlBrd"></span>';
            modal +=  '</div>';
            $('#payment_sub').html(modal);
        }else if(payment_type == 3){

            
            modal =  '<div class="form-group">';
            modal +=  '<input class="form-control" placeholder="Enter Check Number" name="reference" id="reference" type="text">';
            modal +=  '<label for="Refernce Number" class="control-label">Check Number</label>';
            modal +=  '<span class="form-controlBrd"></span>';
            modal +=  '</div>';
            $('#payment_sub').html(modal);
            
        }else{
            
            modal =  '<div class="form-group">';
            modal +=  '<input class="form-control" placeholder="Enter Memo Number" name="reference" id="reference" type="text">';
            modal +=  '<label for="Memo" class="control-label">Memo Number</label>';
            modal +=  '<span class="form-controlBrd"></span>';
            modal +=  '</div>';
            $('#payment_sub').html(modal);
            
        } 
    }
        
        
    function RemoveAmount(){
        $("input[name='amount[]']").each(function(){
        }).val(0);
        $('#amount_to_apply').html('Amount to Apply :' + ' ' +0);
    }

        

    $(document).on('click', '#button-account-create', function (e) { 
            $('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>'); 
            
        $.ajax({
            url: '<?php echo e(url("accounting/chartofaccounts_model_data")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-account-create").serialize(),
                
            success: function(data) {
                $('#span-loader').remove(); 

                $('#close-modal-create-account').trigger('click');
                $("#disc_acct_select"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
                $("#disc_acct_select"+ data.present_value_of_dropdown).selectpicker('refresh');

            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
                // $('#close-modal-create-account').trigger('click'); 

            }
        });
        
    }); 

    

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/incomes/invoices/payment.blade.php ENDPATH**/ ?>