
<?php $__env->startSection('title', 'New Cheque'); ?>
<style>
	.bootstrap-select.btn-group .dropdown-menu.inner {
	max-height: 400px !important;
	}
</style>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('expenses/cheques')); ?>"
	class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>Cheque List</a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Default box -->
<?php echo Form::open(['url' => 'expenses/cheques', 'files' => true, 'role' => 'form']); ?>

<div class="card ">
	<div class="row">
		<input type="hidden" name="currency_code" value="<?php echo e(setting('general.default_currency')); ?>" id="currency_code">
		<div class="col-lg-3 col-md-4 col-sm-6   required <?php echo e($errors->has('person_id') ? 'has-error' : ''); ?>">
			<div class="row">
				<div class="col-lg-10 col-md-10 col-sm-10">
					<small>Payee</small>
					<select id="person_id" class="selectpicker" data-live-search="true" name="person_id">
						<option value="" selected="selected"> Select Name </option>
						<?php $__currentLoopData = $personname; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($person->id); ?>" data-subtext=
							(<?php echo e($person->type); ?>) > <?php echo e($person->name); ?> 
						</option>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</select>
					<?php echo $errors->first('person_id', '
					<div class="help-block with-errors">:message</div>
					'); ?>

				</div>
				<div class="col-lg-2 col-md-2 col-sm-2">
					<div class="add-bttn pr-2">
						<button type="button" data-toggle="modal" data-target="#modal-create-vendor"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;">add </i></button>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-3">
			<?php echo e(Form::selectGroup('account_id', 'Account', $accounts, null, ['data-live-search'=>'true','required' =>'required'])); ?>

		</div>
		<div class="col-md-3">
			<?php echo e(Form::textGroup('paid_at', 'Date', Date::now()->format('yyyy-mm-dd'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

		</div>
		<div class="col-md-3">
			<?php echo e(Form::textGroup('cheque_number', 'Cheque Number', null, ['required' => 'required'])); ?>

		</div>
		<div class="col-md-12">
			<?php echo e(Form::textareaGroup('address', 'Address', null, ['rows'=>'2'])); ?>       
		</div>
	</div>
</div>

<div class="">
	<h3 class="mb-3 mt-3">Account Details</h3>
	<div class="">
		<table class="table table-bordered tabl-input" id="account">
			<thead>
				<tr style="background-color: #f9f9f9;">
					<th width="5%">Actions</th>
					<th width="25%">Account</th>
					<th width="30%">Description</th>
					<th width="20%">Price</th>
					<th width="20%">Total</th>
				</tr>
			</thead>
			<tbody>
				<?php $account_row = 0; ?>
				<tr id="account-row-<?php echo e($account_row); ?>">
					<td>
						<button type="button" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>
					</td>
					<td>
						<select onchange="nameofAccount(<?php echo e($account_row); ?>);addChartofAccount(event)" id="account-id-<?php echo e($account_row); ?>" class="selectpicker" name="account[<?php echo e($account_row); ?>][account_id]" tabindex="-1" aria-hidden="true" data-live-search="true" required="required"> 
						<?php echo Cache::get('account_details_option'); ?>

						</select>
						<input class="form-control"  name="account[<?php echo e($account_row); ?>][name]" type="hidden" id="account-name-<?php echo e($account_row); ?>">
						<input class="form-control" name="account[<?php echo e($account_row); ?>][quantity]" type="hidden" value="1" id="account-quantity-<?php echo e($account_row); ?>">
					</td>
					<td>
						<div class="form-group">
							<input class="form-control "  name="account[<?php echo e($account_row); ?>][description]"  type="text" id="account-description-<?php echo e($account_row); ?>">
							<label class="form-label">Description</label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td>
						<div class="form-group">
							<input class="form-control"  name="account[<?php echo e($account_row); ?>][price]" type="text" id="account-price-<?php echo e($account_row); ?>" required="required">
							<label class="form-label">Price</label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td style="vertical-align: middle;width:30%;">
						<span id="account-total-<?php echo e($account_row); ?>">0</span>
					</td>
				</tr>
				<?php $account_row++; ?>
				<tr id="addAccount">
					<td colspan="3">
						<button type="button" onclick="addAccount();" data-toggle="tooltip" title="<?php echo e(trans('general.add')); ?>" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="<?php echo e(trans('general.add')); ?>"><i class="material-icons">add </i></button>
					</td>
					<td class="text-right"><strong>Sub Total</strong></td>
					<td><span id="sub-total">0</span></td>
				</tr>
				<tr>
					<td colspan="3"></td>
					<td class="text-right"><strong>Total</strong></td>
					<td><span id="grand-total">0</span></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>

<?php echo e(Form::fileGroup('attachment', 'Attachment')); ?>

<!-- /.box-body -->
<div class="row">
	<div class="col-lg-6 col-md-6 col-sm-6 mt-2">
		<?php echo e(Form::textareaGroup('description', 'Description')); ?>

	</div>
	<div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
		<div class="box-footer">
			<?php echo e(Form::saveButton('Save expenses/cheques')); ?>

		</div>
	</div>
</div>
<!-- /.box-footer -->
<?php echo Form::close(); ?>

<div class="modal fade" id="modal-create-vendor" >
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title"><?php echo e(trans('general.title.new', ['type' => 'Person'])); ?></h4>
			</div>
			<div class="modal-body">
				<?php echo Form::open(['id' => 'form-create-vendor', 'role' => 'form']); ?>

				<div class="row">
					<div class="col-md-6">
						<div class="form-group  required">
							<input class="form-control"  required="required" name="name" type="text" id="name">
							<label for="name" class="form-label"><?php echo e(trans('general.name')); ?></label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group ">
							<input class="form-control"  required="required" name="vendor_email" type="text" id="email">
							<label for="email" class="form-label"><?php echo e(trans('general.email')); ?></label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<?php echo Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_cod']); ?>

					<div class="col-md-6">
						<div class="form-group  required">
							<small><?php echo e(trans_choice('general.net_term', 1)); ?></small>
							<?php echo Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker net_term','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])); ?>

						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group   ">
							<input class="form-control" name="phone" id="phone" type="text">
							<label for="phone" class="form-label">Phone</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<div class="col-md-12">
						<div class="form-groupTextArea  ">
							<textarea class="form-ControlTextArea" rows="3" name="address" cols="50" id="address"></textarea>
							<label for="address" class="form-label"><?php echo e(trans('general.address')); ?> </label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<?php echo Form::hidden('enabled', '1', []); ?>

				</div>
				<?php echo Form::close(); ?>

			</div>
			<div class="modal-footer">
				<div class="pull-left">
					<button type="button" id="close-modal-create-vendor" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
					<?php echo Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-vendor', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

				</div>
			</div>
		</div>
	</div>
</div>
<?php echo $__env->make('accounts.common.models.chartofaccount', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script  src="<?php echo e(asset('accounts/chartofaccounts/accounting.js')); ?>">  </script>
<script type="text/javascript">
	var account_row = <?php echo e($account_row); ?>;	
	
	function addAccount() {
	    html  = '<tr id="account-row-' + account_row + '">';
	    html += '  <td style="vertical-align: middle;">';
	    html += '      <button type="button" onclick="$(\'#account-row-' + account_row + '\').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>';
	    html += '  </td>';
	
	    html += '  <td>';
	    html += '      <select class="selectpicker" onchange="nameofAccount('+ account_row +');addChartofAccount(event)" name="account[' + account_row + '][account_id]" id="account-id-' + account_row + '" data-live-search="true">';
	    
	    html += $('#account-id-0').html();
	    
	    html += '      </select>';
	    html += '<input class="form-control"  name="account['+ account_row +'][name]" type="hidden" id="account-name-'+ account_row +'">';
	    html += '<input  name="account['+ account_row +'][quantity]" type="hidden" value="1" id="account-quantity-'+ account_row +'">';
	    html += '  </td>';
	
	    html += '  <td>';
	    html += ' <div class="form-group"><input class="form-control"  name="account[' + account_row + '][description]" type="text" id="account-description-' + account_row + '"><label class="form-label"><?php echo e(trans('general.description')); ?></label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	    html += '  <td>';
	    html += ' <div class="form-group"><input class="form-control" required  name="account[' + account_row + '][price]" type="text" id="account-price-' + account_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	
	    html += '  <td style="vertical-align: middle;">';
	    html += '      <span id="account-total-' + account_row + '">0</span>';
	    html += '  </td>';
	
	    $('#account tbody #addAccount').before(html);
	    $('#account-id-' + account_row).selectpicker('refresh');
	
	    account_row++;
	}	    
	
	$(document).ready(function(){
	    $('#vendor_id').on('change',function(){
	        var val = $(this).val();
	        $.ajax({
	            type: 'GET',
	            dataType: 'JSON',
	            url : '<?php echo e(url('expenses/vendors/')); ?>' +'/' + val,
	            success:function(data){
	                $('#address').val(data.address);
	            },
	            error:function(error){
	                /*console.log(error);*/
	            }
	
	        });
	    });
	    $('#paid_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#paid_at').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
            clearBtn: true
        });
	    
	
	    /*Accounts Event*/
	    $(document).on('change', '#currency_code, #account tbody select', function(){
	        totalItem();
	    });
	
	    $(document).on('keyup', '#account tbody .form-control', function(){
	        totalItem();
	    });
	
	
	    $(document).on('change', '#currency_code, #items tbody select', function(){
	        totalItem();
	    });
	
	    $(document).on('change', '#vendor_id', function (e) {
	        $.ajax({
	            url: '<?php echo e(url("expenses/vendors/currency")); ?>',
	            type: 'GET',
	            dataType: 'JSON',
	            data: 'vendor_id=' + $(this).val(),
	            success: function(data) {
	                $('#currency_code').val(data.currency_code);
	
	                // This event Select2 Stylesheet
	                $('#currency_code').trigger('change');
	            }
	        });
	    });
	
	    
	});
	
	function totalItem() {
	    $.ajax({
	        url: '<?php echo e(url("items/items/totalChequeamount")); ?>',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $('#currency_code,#account input[type=\'text\'],#account input[type=\'hidden\'], #account textarea, #account select'),
	        headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
	        success: function(data) {
	            if (data) {
	                // $.each( data.items, function( key, value ) {
	                //     $('#item-total-' + key).html(value);
	                // });
	
	                $.each( data.account, function( key, value ) {
	                    $('#account-total-' + key).html(value);
	                });
	
	                $('#sub-total').html(data.sub_total);
	                
	                $('#grand-total').html(data.grand_total);
	            }
	        }
	    });
	}
	
	
	    // Account Name Taken Form Dropdown Text.
	function nameofAccount( id ){
	    $('#account-price-'+id).prop('required',true);
	    var account_id = $('#account-id-'+id +' option:selected').text();
	    $('#account-name-'+id).val(account_id.split("---")[0]);
	}
	
	$(document).on('click', '#button-create-vendor', function (e) {
	    $('#modal-create-vendor .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');
	
	    $.ajax({
	        url: '<?php echo e(url("expenses/vendors/vendor")); ?>',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $("#form-create-vendor").serialize(),
	        beforeSend: function () {
	            $('#modal-create-vendor .modal-content').append();
	
	            $(".form-group").removeClass("has-error");
	            $(".help-block").remove();
	        },
	        success: function(data) {
	            $('#span-loader').remove();
	
	            
	
	            $("#person_id").append('<option value="'+data.id+'-'+2+'" selected="selected">' + data.name + '</option>');
	
	            $('#close-modal-create-vendor').trigger('click');
	            $("#person_id").selectpicker('refresh');
	        },
	        error: function(error, textStatus, errorThrown) {
	            $('#span-loader').remove();
	
	            if (error.responseJSON.name) {
	                $("input[name='name']").parent().parent().addClass('has-error');
	                $("input[name='name']").parent().after('<p class="help-block">' + error.responseJSON.name + '</p>');
	            }
	
	            if (error.responseJSON.email) {
	                $("input[name='email']").parent().parent().addClass('has-error');
	                $("input[name='email']").parent().after('<p class="help-block">' + error.responseJSON.email + '</p>');
	            }
	
	            if (error.responseJSON.currency_code) {
	                $("select[name='currency_code']").parent().parent().addClass('has-error');
	                $("select[name='currency_code']").parent().after('<p class="help-block">' + error.responseJSON.currency_code + '</p>');
	            }
	        }
	    });
	});	
	
	$(document).on('click', '#button-account-create', function (e) { 
	$('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');    
	$.ajax({
	    url: '<?php echo e(url("accounting/chartofaccounts_model_data")); ?>',
	    type: 'POST',
	    dataType: 'JSON',
	    data: $("#form-account-create").serialize(),
	        
	    success: function(data) {
	        $('#span-loader').remove(); 
	
	        $('#close-modal-create-account').trigger('click');
	        $("#"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
	        $("#"+ data.present_value_of_dropdown).selectpicker('refresh');
	
	    },
	    error: function(error, textStatus, errorThrown) {
	        $('#span-loader').remove();
	        // $('#close-modal-create-account').trigger('click'); 
	
	    }
	}); 
	}); 
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/cheques/create.blade.php ENDPATH**/ ?>