
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('banking/deposit')); ?>"
	class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans('general.deposit').' List'); ?></a>
<a href="<?php echo e(url('banking/deposit/' . $deposit->id . '/edit')); ?>"
	class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">edit</i>Edit</a>
<a href="<?php echo e(url('banking/deposit/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">add</i> <?php echo e(trans('general.add_new')); ?></a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title',  trans_choice('general.deposit', 1)); ?>
<style>
	.table th{padding:1rem !important;}
</style>
<?php $__env->startSection('content'); ?>
<section class="invoice">
	<div class="card">
		<div class="row mb-3">
			<div class="col-lg-4 col-md-4">
				<span class="depst-head">Deposite To  : </span>  <?php echo e($deposit->account->name_number); ?>

			</div>
			<div class="col-lg-4 col-md-4">
				<span class="depst-head">Deposite at   :</span> <?php echo e(Date::parse($deposit->paid_at)->format($date_format)); ?>

			</div>
			<div class="col-lg-4 col-md-4">
				<span class="depst-head">Deposite Memo :</span>   <?php echo e($deposit->memo); ?> 
			</div>
		</div>
	</div>
	<div class="row m-0">
		<table class="table table-striped">
			<thead>
				<tr>
					<th width="15%"><?php echo e(trans('invoices.received_from')); ?></th>
					<th width="25%"><?php echo e(trans_choice('general.accounting',1)); ?></th>
					<th width="25%"><?php echo e(trans('general.memo')); ?></th>
					<th width="20%"><?php echo e(trans_choice('general.payment_methods', 1)); ?></th>
					<th width="15%"><?php echo e(trans('invoices.price')); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $deposit->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<?php 
				if($item->person_id){
				$person_id = explode('-',$item->person_id)[1];
				if( $person_id === 1 ){
				$person_type = App\Models\Accounts\Income\Customer::find($person_id);
				}else{
				$person_type = App\Models\Accounts\Expense\Vendor::find($person_id);
				}
				}
				?>
				<tr>
					<td width="15%" ><?php echo e(isset($person_type)?$person_type->name:''); ?> </td>
					<td width="25%" ><?php echo e($item->chart->name); ?></td>
					<td width="25%" ><?php echo e($item->memo); ?></td>
					<td width="20%" ><?php echo e($item->payment_custom); ?></td>
					<td width="15%" > <?php echo money($item->price,'USD',true); ?></td>
				</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		</table>
	</div>
	
	<div class="box-footer row no-print">
		<div class="col-md-12">
			
			<div style="display:flex;">
				<?php if($deposit->attachment): ?>
				<span class="attachment">
				<a href="<?php echo e(url('uploads/' . $deposit->attachment->id . '/download')); ?>">
				<span id="download-attachment" class="text-primary">
				<i class="fa fa-file-<?php echo e($deposit->attachment->aggregate_type); ?>-o"></i> <?php echo e($deposit->attachment->basename); ?>

				</span>
				</a>
				</span>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
	var text_yes = '<?php echo e(trans('general.yes')); ?>';
	var text_no = '<?php echo e(trans('general.no')); ?>';
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/banking/deposit/show.blade.php ENDPATH**/ ?>