<?php $__env->startSection('title', trans('general.title.new', ['type' => trans_choice('general.reconciliations', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('banking/reconcile')); ?>" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.reconciliations', 1) . ' List'); ?> </a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <?php echo Form::open(['url' => 'banking/reconcile/create', 'role' => 'form', 'method' => 'GET']); ?>


        <div class="col-md-12">
            <div class="">
                <div class="row">
                    <div class="col-md-3">
                        <?php echo e(Form::textGroup('started_at', trans('reconciliations.start_date'), request('started_at'), ['id' => 'started_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

                    </div>

                    <div class="col-md-3">
                        <?php echo e(Form::textGroup('ended_at', trans('reconciliations.end_date'), request('started_at'), ['id' => 'ended_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

                    </div>

                    <div class="col-md-3">
                        <?php echo e(Form::textGroup('closing_balance', trans('reconciliations.closing_balance'), null, ['required' => 'required', 'autofocus' => 'autofocus'], '0', 'col-md-2')); ?>

                    </div>

                    <div class="col-md-3">
                        <?php echo e(Form::selectGroup('account_id', trans_choice('general.accounts', 1), $accounts, request('account_id', setting('general.default_account')), ['required' => 'required','data-live-search'=>'true'])); ?>

                    </div>

                    <div class="form-group col-md-3">
                        <div class="text-left" >
                            <?php echo Form::button('<span class="fa fa-list"></span> &nbsp;' . trans('reconciliations.list_transactions'), ['type' => 'submit', 'class' => 'btn btn-primary']); ?>

                        </div>
                    </div>
                </div>
                <!-- /.box-body -->
            </div>
        </div>

        <?php echo Form::close(); ?>

       
        <div class="">
            <div class="box-body" >
                <div class="row center-block text-center" >
                    <div class="col-sm-4"><div class="card">
                         <h3 id="statement_ending_balance">$0.00</h3>
                        <h6>STATEMENT CLOSING BALANCE</h6> </div>
                    </div>
                     <div class="col-sm-4"><div class="card">
                         <h3 id="cleared_balance">$0.00</h3>
                        <h6>CLEARED AMOUNT</h6> </div>
                    </div>
                     <div class="col-sm-4"><div class="card">
                         <h3 id="difference_balance">$0.00</h3>
                        <h6>DIFFERENCE</h6> </div>
                    </div>
                </div>
                <div class="row text-center">
                      <div class="col-sm-4"><div class="card">
                        <h3 id="beginning_balance"><?php echo money($opening_balance,'USD',true); ?></h3>
                        <h6>OPENING BALANCE </h6></div>
                    </div>
                      <div class="col-sm-4"><div class="card">
                        <h3 id="deposit_total">$0.00</h3>
                        <h6><label id="deposit_count">0 DEPOSIT</label></h6> </div>
                    </div>
                     <div class="col-sm-4"><div class="card">
                        <h3 id="withdraw_total">$0.00</h3>
                        <h6><label id="withdraw_count">0 WITHDRAWAS</label> </h6></div>
                    </div>
                </div>    
            </div>
        </div>
    </div>    
    <div class="">
            <div class="">
                <h3 class="box-title"><?php echo e(trans_choice('general.transactions', 2)); ?></h3>
            </div>
            <div class="box-body">
                <?php echo Form::open(['url' => 'banking/reconcile', 'role' => 'form', 'class' => 'form-loading-button', 'id' => 'form-reconciliations']); ?>


                <?php echo e(Form::hidden('account_id', $account->id)); ?>

                <?php echo e(Form::hidden('currency_code', 'USD', ['id' => 'currency_code'])); ?>

                <?php echo e(Form::hidden('opening_balance', $opening_balance, ['id' => 'opening_balance'])); ?>

                <?php echo e(Form::hidden('closing_balance', request('closing_balance', '0'), ['id' => 'closing_balance'])); ?>

                <?php echo e(Form::hidden('started_at', request('started_at'))); ?>

                <?php echo e(Form::hidden('ended_at', request('ended_at'))); ?>

                <?php echo e(Form::hidden('reconcile', '0', ['id' => 'hidden-reconcile'])); ?>

                <div class="">
                    <table class="table table-striped table-hover table-bordered" id="tbl-transactions">
                        <thead>
                        <tr>
                            <th width="10%"><?php echo e(trans('general.date')); ?></th>
                            <th width="25%"><?php echo e(trans('general.description')); ?></th>
                            <th width="15%"><?php echo e(trans('general.name')); ?></th>
                            <th width="10%"><?php echo e(trans('general.memo')); ?></th>
                            <th width="10%"><?php echo e(trans_choice('general.type', 1)); ?></th>
                            <th width="10%"><?php echo e(trans_choice('general.deposits', 1)); ?></th>
                            <th width="10%"><?php echo e(trans_choice('general.withdrawals', 1)); ?></th>
                            <th width="10%"><?php echo e(trans('general.clear')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td width="10%"><?php echo e(Date::parse($item->transaction_date)->format($date_format)); ?></td>
                                <td width="25%"><?php echo e($item->description); ?></td>
                                <td width="15%"><?php echo e($item->name); ?></td>
                                <td width="10%"><?php echo e($item->number); ?></td>
                                <td width="10%"><?php if(!empty($item->transaction_type)): ?> <?php echo e($item->transaction_type); ?> <?php else: ?> <?php echo e(trans('general.na')); ?><?php endif; ?></td>

                                <?php if($item->amount_type == 'add'): ?>
                                <td width="10%"><?php echo money($item->amount, $item->currency_code, true); ?></td>
                                <td>&nbsp;</td>

                                <?php else: ?>
                                <td>&nbsp;</td>
                                <td width="10%"><?php echo money($item->amount, $item->currency_code, true); ?></td>
                                <?php endif; ?>
                                <td width="10%">   
                                    <div class="custom-controls-stacked d-block">
                                        <label class="custom-control overflow-checkbox">
                                        <?php echo e(Form::checkbox('transactions['. $item->id . '_'. $item->amount_type . ']',$item->amount, $item->reconciled,['class'=>'overflow-control-input'])); ?><span class="overflow-control-indicator"></span>  </label> 
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php if($transactions->count()): ?>
                    <table class="table">
                        <tbody>
                            <tr>
                                <th class="text-right"><?php echo e(trans('reconciliations.closing_balance')); ?>:</th>
                                <td id="closing-balance" class="col-md-1 text-right"><?php echo money(request('closing_balance', '0'), $account->currency_code, true); ?></td>
                            </tr>
                            <tr>
                                <th class="text-right"><?php echo e(trans('reconciliations.cleared_amount')); ?>:</th>
                                <td id="cleared-amount" class="col-md-1 text-right"><?php echo money('0', $account->currency_code, true); ?></td>
                            </tr>
                            <tr>
                                <th class="text-right"><?php echo e(trans('general.difference')); ?>:</th>
                                <td id="difference" class="col-md-1 text-right"><?php echo money('0', $account->currency_code, true); ?></td>
                            </tr>
                        </tbody>
                    </table>
                    <?php endif; ?>
                </div>
            </div>
            <div class="text-right">
                <?php if($transactions->count()): ?>
                <div class="form-group no-margin">
                    <?php echo Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-default button-submit', 'data-loading-text' => trans('general.loading')]); ?>

                    <?php echo Form::button('<span class="fa fa-check"></span> &nbsp;' . trans('reconciliations.reconcile'), ['type' => 'button', 'id' => 'button-reconcile', 'class' => 'btn btn-success button-submit', 'data-loading-text' => trans('general.loading'), 'disabled' => 'disabled']); ?>

                    <a href="<?php echo e(route('reconcile.index')); ?>" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></a>
                </div>
                <?php else: ?>
                <?php echo e(trans('general.no_records')); ?>

                <?php endif; ?>
            </div>
            <?php echo Form::close(); ?>

    </div>    
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
    var today = new Date();
    
        $(document).ready(function(){
            $('#started_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
            $('#started_at').datepicker({
                format: 'yyyy-mm-dd',
                todayHighlight: true,
                clearBtn: true,
                endDate: today
            });

            $('#ended_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
            $('#ended_at').datepicker({
                format: 'yyyy-mm-dd',
                todayHighlight: true,
                clearBtn: true,
                endDate: today
            });
        });
        $(document).ready(function(){
            $('#tbl-transactions input[type="checkbox"]').trigger('change');
        });

        $(document).on('change', '#tbl-transactions input[type="checkbox"]', function (e) {
            amount = $('#closing_balance').val();

            $('#form-reconciliations #closing_balance').val(amount);

            $.ajax({
                url: '<?php echo e(url("banking/reconcile/calculate")); ?>',
                type: 'POST',
                dataType: 'JSON',
                data: $('#form-reconciliations').serialize(),
                headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                success: function(data) {
                    if (data) {
                        if (data.difference_raw != 0)  {
                            $('#button-reconcile').attr('disabled','disabled');
                            $('#difference').css('background-color', '#f2dede');
                        } else {
                            $('#button-reconcile').removeAttr('disabled');
                            $('#difference').css('background-color', '#d0e9c6');
                        }
                        $('#statement_ending_balance').html(data.closing_balance);
                        $('#closing-balance').html(data.closing_balance);
                        $('#cleared-amount').html(data.cleared_amount);
                        $('#cleared_balance').html(data.cleared_amount);
                        $('#difference').html(data.difference);
                        $('#difference_balance').html(data.difference);
                        
                        $('#deposit_total').html(data.income_total);
                        $('#withdraw_total').html(data.expense_total);
                      //  $('#deposit_count').html(deposit_count +' '+'DEPOSIT');
                       // $('#withdraw_count').html(payments_count +' '+'WITHDRAWAS');

                    }
                }
            });
        });

        $(document).on('click', '#button-reconcile', function (e) {
            $('#hidden-reconcile').val(1);

            $('#form-reconciliations').submit();
        });
    </script>   
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/banking/reconcile/create.blade.php ENDPATH**/ ?>