
<?php $__env->startSection('title', 'Meeting analytics'); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo route('meetings.create'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> add </i> New Meeting
</a>
<a href="<?php echo route('meetings.index'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> list </i> My Meeting
</a>
<?php $__env->stopSection(); ?>
<style>
    .table tbody tr td:last-child {
        white-space: nowrap;
    }

    .green {
        color: green !important;
    }

    .red {
        color: red !important;
    }
</style>
<?php $__env->startSection('content'); ?>
<!-- page content -->
<script src="https://cdn.ckeditor.com/4.6.2/standard/ckeditor.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('accounts/css/daterangepicker.css')); ?>" />

<table
    class="table table-show table-striped table-bordered table-responsive dt-responsive nowrap jambo_table table-filter"
    cellspacing="0" id="abcd">
    <thead>
        <tr>
            <th>Date</th>
            <th>Organised By</th>
            <th>Raised By</th>
            <th>Consultant</th>
            <th>Issue Statement</th>
            <th>Solution Statement</th>
            <th>Resolved ?</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$issue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e(Date::parse($issue->meeting->date)->format($date_format)); ?></td>
            <td><?php echo e(ucfirst($issue->meeting->organiser->name)); ?></td>
            <td><?php echo e(ucfirst($issue->user->name)); ?></td>
            <td><?php echo e(ucfirst($issue->student)); ?></td>
            <td>
                <p title="<?php echo e(ucfirst($issue->issue)); ?>"><?php echo e(ucfirst($issue->issue)); ?></p>
            </td>
            <td>
                <p title="<?php echo e(ucfirst($issue->solution)); ?>"><?php echo e(ucfirst($issue->solution)); ?></p>
            </td>
            <td>
                <?php if($issue->status == 1): ?>
                Yes
                <?php endif; ?>

                <?php if($issue->status == 2): ?>
                No
                <?php endif; ?>
                
                <?php if($issue->status == ''): ?>
                None 
                <?php endif; ?>

            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/meetings/analytics.blade.php ENDPATH**/ ?>