
<?php $__env->startSection('title', trans('bills.bill_payment')); ?>
<?php $__env->startSection('content'); ?>
<style type="text/css">
input[type=number]::-webkit-inner-spin-button, 
input[type=number]::-webkit-outer-spin-button { 
  -webkit-appearance: none; 
}
.tabl-input tbody>tr>td>.form-group .form-control + label.form-label {
    position: absolute;
    top: -15px !important;
}
input[type=number] {
  -moz-appearance: textfield;
}
</style>

<div class="row">
    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div><?php echo e($error); ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</div>

<div class="box box-success">   
    <?php echo Form::open(['url' => 'expenses/bills/payment', 'files' => true, 'id' =>  'payment','role' => 'form']); ?>

    <div class="box-body">
        <div class="card">
            <div class="row">
                <div class="col-md-3">
                    <?php echo e(Form::textGroup('name', trans('general.name'), $bill->vendor_name, ['disabled' => 'disabled'])); ?>

                </div>
                <div class="col-md-3">
                    <?php echo e(Form::textGroup('paid_at', trans('bills.payment_date'), Date::now()->format('Y-m-d'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

                </div>
                <div class="col-md-3">
                    <?php echo e(Form::selectGroup('account_id', trans_choice('general.accounts', 1), $accounts, setting('general.default_account'), ['data-live-search'=>'true'])); ?>

                </div>
                <div class="col-md-3">
                    <?php echo e(Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), $payment_methods, setting('general.default_payment_method'))); ?>

                </div>
                
                <p id="accountbalance" style="margin-left:15px"> </p>

                <?php echo Form::hidden('currency_code', 'USD',['id' => 'currency_code']); ?>

                <?php echo Form::hidden('bill_id', $bill->id, ['id' => 'bill_id']); ?> 
                <?php echo Form::hidden('bill_id_return', 1, ['id' => 'bill_id']); ?> 
                <?php echo e(Form::hidden('account_chart_id',null,['id'=>'account_chart_id'])); ?>

            </div>
        </div>
        <div class="">
            <div class="">
               <h3 class="item-title">Outstanding Transactions</h3>
                <div class=" ">
                    <table class="table table-bordered tabl-bill tabl-input table-striped" id="items">
                        <thead>
                            <tr style="background-color: #f9f9f9;">
                                <th><?php echo e(trans('general.description')); ?></th>
                                <th><?php echo e(trans('invoices.due_date')); ?></th>
                                <th><?php echo e(trans('general.totalamount')); ?></th>
                                <th><?php echo e(trans('general.paidamount')); ?></th>
                                <th><?php echo e(trans_choice('general.balance', 2)); ?></th>
                                <th><?php echo e(trans_choice('general.payments',1)); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                                if(isset($bill->payments_total[0])){
                                    $paid_amount = isset($bill->payments_total[0]['paid_amount'])?($bill->payments_total[0]['paid_amount']):0;
                                }
                                else{
                                        $paid_amount = 0;
                                }
                            ?>

                            <tr>
                                <td><?php echo e($bill->bill_number); ?></td>
                                <td><?php echo e(Date::parse($bill->due_at)->format($date_format)); ?></td>
                                <td><?php echo money($bill->amount,$bill->currency_code,true); ?></td>
                                <td><?php echo money($paid_amount,$bill->currency_code,true); ?></td>
                                <td><?php echo money(($bill->amount - $paid_amount),$bill->currency_code,true); ?></td>
                                <td>
                                    <?php if($bill->amount - $paid_amount != 0): ?>
                                    <div class="form-group">                                
                                        <input type="number" name="amount" min="1" max="<?php echo e(($bill->amount - $paid_amount)); ?>" id="amount_0" class="form-control amount has-value" required> 
                                        <label class="form-label">Amount</label>
                                        <span class="form-controlBrd"></span>
                                        <input type="hidden" id="invoice_amount_0">
                                    </div>
                                    <?php else: ?>
                                    <span class="badge badge-success">Full Paid</span>
                                    <?php endif; ?>
                                    <!--<input type="number" name="amount"  min="0" max="<?php echo e(($bill->amount - $paid_amount)); ?>" id="amount" required="required"  class="" placeholder="0">-->
                               </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <?php echo e(Form::textareaGroup('notes', trans_choice('general.notes', 2))); ?>

        </div>
    </div>
    <?php if($bill->amount - $paid_amount != 0): ?>
    <div class="box-footer">
        <div id="payment_id"></div>
        <?php echo e(Form::saveButton('expenses/bills')); ?>

    </div>
    <?php endif; ?>
    <?php echo Form::close(); ?>

</div>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script type="text/javascript">
    $(document).ready(function(){

        var account_id = $('#account_id').val();
        getChartID(account_id);
        getAccountBalance(account_id);

        window.onload = function() {
            var account_id = '<?php echo e(setting('general.default_account')); ?>';
                $.ajax({
                url  : '<?php echo e(url('/banking/tranfers/chart_id/')); ?>'+'/'+account_id,
                type : 'GET',
                success : function(data){
                    $('#account_chart_id').val(data);
                },
                error:function(data){
                    console.log(data);
                }
            });
        }


        $('#account_id').on('change',function(){               
            let account_id = $(this).val();
            getChartID(account_id);
            getAccountBalance(account_id);
        });


        /*$("#payment_method").select2({
            placeholder: "<?php echo e(trans('general.form.select.field', ['field' => trans_choice('general.payment_methods', 1)])); ?>"
        });

        $("#account_id").select2({
            placeholder: "<?php echo e(trans('general.form.select.field', ['field' => trans_choice('general.accounts', 1)])); ?>"
        });*/
        $('#customerpayment').submit(function() {
            var elements = $("input[name='amount']");
            var validated = false;
            elements.each(function() {
                if ($(this).val() != '' && $(this).val() != 0) {
                    validated = true;
                    return false; // will break the each
                } else {
                    $('#payment_id').html('<p style="color:blue;margin-left:20px"> Please Enter Amount </p>').fadeOut(10000);
                    validated = false;
                }
            });
            return validated;
        });
    });
    function getChartID(account_id){
        $.ajax({
            url  : '<?php echo e(url('/banking/tranfers/chart_id/')); ?>'+'/'+account_id,
            type : 'GET',
            success : function(data){
                $('#account_chart_id').val(data);
            },
            error:function(data){
                console.log(data);
            }
        });
    }
    function getAccountBalance(account_id){
        $('#accountbalance').html(' ');
        $.ajax({
            url  : '<?php echo e(url('/banking/accounts/accountbalance/')); ?>'+'/'+account_id,
            type : 'GET',
            success : function(data){
                $('#accountbalance').html('Account Balance:- $' +data.amount);
            },
            error:function(data){
                console.log(data);
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/bills/payment.blade.php ENDPATH**/ ?>