
<?php $__env->startSection('title', 'Yearly Incentives'); ?>
<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('includes.headers.incentives', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row pl-2">
    <div class="col-md-3">
        <?php echo Form::selectGroup('user_id', 'Select User', $users, null, ['id'=>'userSelect', 'onchange'=>'getDetails()']); ?>

    </div>
    <div class="col-md-3">
        <small>Select Year</small>
        <select name="year_id" id="yearSelect" class="selectpicker" onchange="getDetails()" data-live-search="true">
            <?php for($i=2005; $i<=date('Y'); $i++): ?>
                <option value="<?php echo e($i); ?>" <?php echo e((date('Y')==$i)?'selected':''); ?>><?php echo e($i); ?></option>
            <?php endfor; ?>
        </select>
    </div>
    <div class="col-md-6">
        <div class="searchBox mt-2">
            <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']); ?>

             <span class="search-icn"><i class="material-icons">search</i></span>
             <span class="form-controlBrd"></span>
         </div>
    </div>
</div>
<div class="row pl-2 card ml-2 mr-2" id="dataDiv"></div>


<!-- Button trigger modal -->
<button type="button" class="btn btn-primary hidden" data-toggle="modal" data-target="#exampleModal" id="modalBtn"> Launch demo modal </button>
  
  <!-- Modal -->
  <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Incentive Details</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id="incentiveDetails">
          
        </div>
      </div>
    </div>
  </div>

<script>
    function getDetails() {
        var userId = $("#userSelect").val();
        var year = $("#yearSelect").val();

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'post',
            url: '/yearly_incentives_details',
            data: 'userId='+userId+'&year='+year,
            success: function(result) {
                $("#dataDiv").html(result);
            }
        })
    }

    $(document).ready(function() {
        getDetails();
    });

    function getIncentiveDetails(id) {
        $.ajax({
            url: '/incentive_details',
            data: 'id='+id,
            success: function(result) {
                $("#incentiveDetails").html(result);
            }
        })
        $("#modalBtn").trigger('click');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/incentive-structures/yearly.blade.php ENDPATH**/ ?>