

<?php $__env->startSection('title', trans('general.title.new', ['type' => trans_choice('general.creditmemo', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('incomes/creditmemo')); ?>" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.creditmemo', 1) .' List'); ?> </a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- Default box -->
<?php echo Form::open(['url' => 'incomes/creditmemo', 'files' => true, 'role' => 'form','id'=>'creditmemo']); ?>

    
    <div class="card">
        <div class="row">
            <div class="col-lg-3 col-md-4 col-sm-4 <?php echo e($errors->has('customer_id') ? 'has-error' : ''); ?>">
                <small> Customer</small>
                <select id="customer_id" name="customer_id"  class="selectpicker"tabindex="-98" data-live-search="true" required>
                      <?php echo $__env->make('accounts.common.subloop', ['name' => trans('general.form.select.field', ['field' => 'Customers'])], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>     
                </select>
                <?php echo $errors->first('customer_id', '<p class="help-block">:message</p>'); ?>

            </div> 
            
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group">
                        <input class="form-control"  name="customer_email" id="customer_email" type="text">
                        <label for="customer_email" class="form-label">Email</label>
                        <span class="form-controlBrd"></span>
                    <div class="help-block">
                        <div class="custom-controls-stacked d-block" style="position: absolute; top: 50px;left: 0;">
                            <label class="custom-control overflow-checkbox" >
                            <input type="checkbox" name="sendlater" id="sendlater" value="1" class="overflow-control-input">
                            <span class="overflow-control-indicator" style="top:2px;"></span> <span class="overflow-control-description"> Send Later</span></label>
                        </div> 
                    </div>
                </div>
            </div>
            
            <div class="col-md-3">
                <?php echo e(Form::textGroup('creditmemo_at', 'Credit Memo Date', Date::now()->format('yyyy-mm-dd'), ['id' => 'creditmemo_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'data-mask' => '' ] )); ?>

            </div>
            <?php echo Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']); ?>

        
        </div>
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="form-groupTextArea">
                    <textarea class="form-ControlTextArea"  rows="3" name="address" cols="50" id="address"></textarea>
                    <label for="address" class="form-label"><?php echo e(trans('general.billingaddress')); ?></label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>
        </div>
    </div> 
    
    <div class=" ">
      <h3 class="mb-3">Items</h3>
        <div class=" ">
            <table class="table table-bordered tabl-input table-striped" id="items">
                
                <thead>
                    <tr style="background-color: #f9f9f9;">
                        <th width="5%"><?php echo e(trans('general.actions')); ?></th>
                        <th width="30%"><?php echo e(trans('general.name')); ?></th>
                        <th width="25%"><?php echo e(trans('invoices.quantity')); ?></th>
                        <th width="20%"><?php echo e(trans('invoices.price')); ?></th>
                    
                        <th width="20%"><?php echo e(trans('invoices.total')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $item_row = 0; ?>
                    <tr id="item-row-<?php echo e($item_row); ?>">
                        <td>
                            <button type="button" onclick="jQuery(this).tooltip('destroy'); $('#item-row-<?php echo e($item_row); ?>').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>
                        </td>
                       <td>
                           <select onchange="autoItem(<?php echo e($item_row); ?>)" id="item-id-<?php echo e($item_row); ?>" required="required" class="selectpicker" name="item[<?php echo e($item_row); ?>][item_id]"  data-live-search="true" >
                                <?php echo $__env->make('accounts.common.subitem',['name' => trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </select>
                            <input class="form-control"   name="item[<?php echo e($item_row); ?>][name]" type="hidden" id="item-name-<?php echo e($item_row); ?>">
                            
                            
                            <input class="form-control"   name="item[<?php echo e($item_row); ?>][chartid]" type="hidden" id="item-chartid-<?php echo e($item_row); ?>">
                        </td>
                       <td>
                            <div class="form-group">
                                <input class="form-control" required="required" name="item[<?php echo e($item_row); ?>][quantity]" type="text" id="item-quantity-<?php echo e($item_row); ?>">
                                <label class="form-label">Quantity</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                            <input class="form-control price" required="required" name="item[<?php echo e($item_row); ?>][price]" type="text" id="item-price-<?php echo e($item_row); ?>">
                           <label class="form-label">Price</label>
                                <span class="form-controlBrd"></span>
                        </div>
                        </td>
                        <td>
                            <span id="item-total-<?php echo e($item_row); ?>">0</span>
                        </td>
                    </tr>
                    <?php $item_row++; ?>
                    <tr id="addItem">
                        <td><button type="button" onclick="addItem();" data-toggle="tooltip" title="<?php echo e(trans('general.add')); ?>" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="<?php echo e(trans('general.add')); ?>"><i class="material-icons">add </i></button></td>
                        <td class="text-right" colspan="4"></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="4"><strong><?php echo e(trans('invoices.sub_total')); ?></strong></td>
                        <td><span id="sub-total">0</span></td>
                    </tr>
                    <tr>
                        <td class="text-right"  colspan="4"><strong><?php echo e(trans('invoices.total')); ?></strong></td>
                        <td><span id="grand-total">0</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    
    <div id="invoices_list"></div>
   

    <?php echo e(Form::fileGroup('attachment', trans('general.attachment'))); ?> 

    
<div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
          <?php echo e(Form::textareaGroup('notes', trans_choice('general.notes', 2))); ?>

      </div>

    <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
         <?php echo e(Form::saveButton('Save incomes/creditmemo')); ?>

    </div>
</div>
    <!-- /.box-footer -->
<?php echo Form::close(); ?>


<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script type="text/javascript">

    var item_row = '<?php echo e($item_row); ?>';

    $(document).ready(function(){
        $("#creditmemo_at").inputmask('yyyy-mm-dd', { placeholder: 'YYYY-MM-DD' });
         //Date picker
        $('#creditmemo_at').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true
        });

        $(document).on('keyup', '#items tbody .form-control', function(){
            totalItem();
        });


        var customer_id = $('#customer_id').val();
        if(customer_id != ''){
            autocompletecustomer(customer_id);
        }
        $('#customer_id').on('change',function(){
            var val = $(this).val();
            getInvoices(val);
            autocompletecustomer(val);
        });

        $(document).on('#creditmemo submit',function(){         
            var price = 0;
            var invoice_price = 0;
            $('.price').each(function(){
                price += parseInt($(this).val() || 0);
            });
    
            $('.invoice_price').each(function(){
                invoice_price += parseInt($(this).val() || 0);
            });
   
            if(price === invoice_price){
               return true;
            }else{
                $("body").append('<div class="alertBox alert alert-danger alert-dismissible fade show" role="alert"> <button type="button" class="close" data-dismiss="alert" aria-label="Close"> <span aria-hidden="true">&times;</span> </button> <strong>Invoice Amount and Credit Memo Amount are Not Same</strong> </div>');
                setTimeout(function(){  $('.alertBox').removeClass('show').addClass('hide'); }, 3000);
                return false;
            }
        });
    });

    function getInvoices(id){
        $('#invoices_list').html('');
        $.ajax({
            url:'<?php echo e(url('incomes/creditmemo/getinvoices')); ?>'+'/'+id,
            success:function(data){
                $('#invoices_list').html(data);
            },error:function(){
                console.log('ERROR 404');
            }
        });
    }
    
    function addItem() {
        html  = '<tr id="item-row-' + item_row + '">';
        html += '  <td style="vertical-align: middle;">';
        html += '      <button type="button" onclick="$(\'#item-row-' + item_row + '\').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>';
        html += '  </td>';

        html += '  <td>';
        html += '<select class="selectpicker" onchange="autoItem('+ item_row +')" name="item[' + item_row + '][item_id]" required="required" id="item-id-' + item_row + '"  data-live-search="true">';
        html += $('#item-id-0').html();
        html += '</select>';
        html += '<input class="form-control"  name="item['+ item_row +'][name]"        type="hidden" id="item-name-'+ item_row + '">';
        html += '<input class="form-control"   name="item['+ item_row +'][chartid]" type="hidden" id="item-chartid-'+item_row +'">';
        html += '  </td>';

        html += '  <td>';
        html += ' <div class="form-group"><input class="form-control text-left" required="required" name="item[' + item_row + '][quantity]" type="text" id="item-quantity-' + item_row + '"><label class="form-label">Quantity</label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';
        html += '  <td>';
        html += '<div class="form-group"><input class="form-control text-left" required="required" name="item[' + item_row + '][price]" type="text" id="item-price-' + item_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';
        html += '  <td style="vertical-align: middle;">';
        html += '      <span id="item-total-' + item_row + '">0</span>';
        html += '  </td></tr>';

        $('#items tbody #addItem').before(html);

        $('#item-id-'+ item_row).selectpicker('refresh');

        item_row++;
    }
    var autocomplete_path = "<?php echo e(url('items/items/autocompletebill')); ?>";
    function autoItem (id){
        var item_id = $("#item-id-"+id).val();
        
        $.ajax({
            url: autocomplete_path,
            type: 'GET',
            dataType: 'JSON',
            data: 'query=' + item_id + '&type=invoice&currency_code=' + $('#currency_code').val(),
            success: function(data) {
             
                $('#item-name-'+id).val(data.name);
                $('#item-quantity-' + id).val('1');
                $('#item-price-' + id).val(data.sale_price);
                $('#item-chartid-' +id).val(data.income_account);
                $('#item-total-' + id).html(data.total);
                totalItem();
                
            }
        });
    }
    function totalItem() {
        $.ajax({
            url: '<?php echo e(url("items/items/totalItem")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $('#currency_code, #items input[type=\'text\'],#items input[type=\'hidden\'], #items textarea, #items select,#account input[type=\'text\'],#account input[type=\'hidden\'], #account textarea, #account select'),
            headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
            success: function(data) {
                if (data) {
                    $.each( data.items, function( key, value ) {
                        $('#item-total-' + key).html(value);
                    });

                    $('#sub-total').html(data.sub_total);
                    $('#grand-total').html(data.grand_total);
                }
            }
        });
    }

    function autocompletecustomer(customer_id){
        $.ajax({
                type: 'GET',
                dataType: 'JSON',
                data: 'customer_id=' +customer_id,
                url : '<?php echo e(url('incomes/customers/autocompletecustomer')); ?>',
                success:function(data){
                   $('#select2-customer_id-container').html(data.full_details.original.full_name);
            
                   $('#customer_email').val(data.customer.customer_email).addClass('has-value');
                   $('#address').val(data.customer.address).addClass('has-value');
                   if(data.customer.bill_to==='parent'){
                        $('#customer_invoice_parent_id').val(data.parent_id);
                    }else{
                        $('#customer_invoice_parent_id').val(data.customer.id);
                    }
                },
                error:function(error){
                    console.log(error);
                }
            });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/incomes/creditmemo/create.blade.php ENDPATH**/ ?>