

<?php $__env->startSection('title', trans('reports.standard.journal')); ?>

<?php $__env->startSection('new_button'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
    .red-text {
        color: red;
    }

    .text-right {
        text-align: right;
    }

    .table-show tbody {
        height: auto !important;
    }

    .profit-content {
        display: none;
    }

    .profit-link .material-icons {
        position: relative;
        top: 6px;
    }

    .first-step {
        padding-left: 1% !important;
    }

    .second-step {
        padding-left: 2% !important;
    }
</style>
<!-- Default box -->
<div class="box box-success">
    <div class="card">
        <?php echo Form::open(['url'=>'/reports/standard/journal']); ?>

        <?php echo $__env->make('accounts.reports.standard.date-filter-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo Form::close(); ?>

    </div>
    <div class="box-body">
        <div class="row m-0">
            <h3><strong><?php echo e(trans('reports.standard.profitandlossdetails')); ?></strong></h3>
        </div>
        <table class="table table-show table-striped table-hover table-bordered " id="">
            <thead>
                <tr>
                    <th>DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>NAME</th>
                    <th>DESCRIPTION</th>
                    <th>ACCOUNT</th>
                    <th>DEBIT</th>
                    <th>CREDIT</th>
                </tr>
            </thead>
        </table>
        
        <?php
        $incometotal = 0;
        ?>
        <?php $__currentLoopData = $lists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(count($list->items) > 0): ?>
                <p><a class="profit-link" data-toggle="collapse" href="#jrnls<?php echo e($list->id); ?>" role="button" aria-expanded="false" aria-controls="jrnls<?php echo e($list->id); ?>"><i class="material-icons">keyboard_arrow_down</i><?php echo e(Carbon\Carbon::parse($list->journal_date)->format($date_format)); ?></a></p>
                <div class="collapse second-step show" id="jrnls<?php echo e($list->id); ?>">
                    <div class="inner-accord">
                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <?php
                                    $ctotal = 0;
                                    $dtotal = 0;
                                    $items = $list->items;
                                ?>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $ctotal = $ctotal + $item->credit;
                                    $dtotal = $ctotal + $item->debit;
                                    $accnt = $item->account;
                                ?>
                                <tr>
                                    <td><?php echo e(Carbon\Carbon::parse($item->created_at)->format($date_format)); ?></td>
                                    <td><?php echo e($item->transaction_type); ?></td>
                                    <td><?php echo e($item->number); ?></td>
                                    <td><?php echo e($item->description); ?></td>
                                    <td><?php echo e(isset($accnt)?$accnt->name:''); ?></td>
                                    <td><?php echo e(($item->debit!='')?money($item->debit, 'USD', true):''); ?></td>
                                    <td><?php echo e(($item->credit!='')?money($item->credit, 'USD', true):''); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <table class="table table-show table-striped table-hover table-bordered" id="">
                    <tbody>
                        <tr class="first-table">
                            <td colspan="5"><?php echo e($list->name); ?></td>
                            <td><?php echo money($dtotal, 'USD', true); ?></td>
                            <td><?php echo money($ctotal, 'USD', true); ?></td>
                        </tr>
                    </tbody>
                </table>
                <?php
                    $ctotal = 0;
                    $dtotal = 0;
                ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php echo $__env->make('accounts.reports.standard.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/reports/standard/accountant/journal.blade.php ENDPATH**/ ?>