use Carbon\Carbon;


<?php $__env->startSection('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.openinvoices')])); ?>

<?php $__env->startSection('new_button'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
  .no-margin {
    margin: 0px;
  }
  .table-show tbody {
  height: auto !important;
  }
</style>
  
<div class="box box-success">
  <div class="card">
  <div class="box-header">
    
      <?php echo Form::open(['url'=>'/reports/standard/open-invoices']); ?>

      <?php echo $__env->make('accounts.reports.standard.date-filter-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <?php echo Form::close(); ?>

    </div>
  </div>

 <div class="box-body">
  <div class="col-md-12 col-sm-12 col-xs-12">
      <h3 class="text-center">ASAS <strong><?php echo e(trans('reports.standard.openinvoices')); ?></strong></h3>
      <hr>
  </div>
  <table id="fullFeatures" class="table table-bordered table-striped">
    <thead>
      <tr>
        <th>DATE</th>
        <th>TRANSACTION TYPE</th>
        <th>NUM</th>
        <th>TERMS</th>          
        <th>DUE DATE</th>
        <th>OPEN BALANCE</th>
      </tr>
    </thead>
  </table>
  <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
    $invoices = $customer->invoices;
    ?>
    <?php if(count($invoices)>0): ?>
    <p><a class="profit-link" data-toggle="collapse" href="#customer<?php echo e($customer->id); ?>" role="button" aria-expanded="false" aria-controls="customer<?php echo e($customer->id); ?>"><i class="material-icons">keyboard_arrow_down</i><?php echo e($customer->name); ?></a></p>
    <div class="collapse first-step show" id="customer<?php echo e($customer->id); ?>">
      <div class="inner-accord">
        <table id="fullFeatures" class="table table-bordered table-striped">
          <tbody>
            <?php
                $total = 0;
            ?>
            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php
                  $ptm = $invoice->payments_total;
                  $ptl = isset($ptm->paid_amount)?$ptm->paid_amount:0;
                  $bal = $invoice->amount - $ptl;
                  $total = $total + $bal;
              ?>
              <tr>
                <td><?php echo e(Carbon\Carbon::parse($invoice->invoiced_at)->format($date_format)); ?></td>
                <td>Invoice</td>
                <td><?php echo e($invoice->invoice_number); ?></td>
                <td></td>
                <td><?php echo e(Carbon\Carbon::parse($invoice->due_at)->format($date_format)); ?></td>
                <td><?php echo money($bal, 'USD', true); ?></td>
              </tr>           
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    
    <table class="table table-show table-striped table-hover table-bordered table-responsive">
      <tbody>
        <tr>
          <td colspan="5">Income Total</td>
          <td><?php echo money($total, 'USD', true); ?></td>
        </tr>
      </tbody>
    </table>
    <?php endif; ?>
    <?php
        $total = 0;
    ?>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>
</div>
<!-- /.box -->
<?php echo $__env->make('accounts.reports.standard.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/reports/standard/owes/open-invoices.blade.php ENDPATH**/ ?>