
<?php $__env->startSection('title', 'Apply consultants for job'); ?>

<?php $__env->startSection('new_button'); ?>
<div class="searchBox mr-2 ml-35">
    <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm',
    'placeholder' => 'Search here']); ?>

    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="<?php echo URL::to('/vs_consultants'); ?>"
    class="btn btn-info btn-Rcircle-iconic waves-effect waves-light d-flex align-items-center"><i
        class="material-icons"> list </i>Consultant list</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo e(Form::open(['url'=>'save_consultant_job', 'id'=>'saveForm'])); ?>

<div class="row">
    <div class="col-lg-12 col-md-12">
        <?php echo e(Form::hidden('consultant_id', $consultant->id)); ?>

        <table class="table table-striped table-bordered table-filter">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Location</th>
                    <th>Employment Type</th>
                    <th>Experience</th>
                    <th>Pay Rate</th>
                    <th>Client Name</th>
                    <th>Job Status</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $applied; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $li): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="applied">
                    <td data-toggle="tooltip" title="<?php echo e(ucwords($li->title)); ?>"><?php echo e(ucwords(Str::limit($li->title, 15))); ?></td>
                    <td><?php echo e(ucwords($li->country?->name)); ?></td>
                    <td><?php echo e(ucwords(str_replace('_', ' ' , $li->employment_type))); ?></td>
                    <td><?php echo e($li->min_experience); ?> - <?php echo e($li->max_experience); ?></td>
                    <td><?php echo e($li->min_payrate); ?> - <?php echo e($li->max_payrate); ?></td>
                    <td><?php echo e($li->client?->name); ?></td>
                    <td><?php echo e(ucwords($li->status)); ?></td>
                    <td><?php echo e(ucwords('Applied')); ?></td>
                    <td></td>
                </tr>             
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php $__currentLoopData = $notapplied; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $li): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="applied">
                    <td data-toggle="tooltip" title="<?php echo e(ucwords($li->title)); ?>"><?php echo e(ucwords(Str::limit($li->title, 15))); ?></td>
                    <td><?php echo e(ucwords($li->country?->name)); ?></td>
                    <td><?php echo e(ucwords(str_replace('_', ' ' , $li->employment_type))); ?></td>
                    <td><?php echo e($li->min_experience); ?> - <?php echo e($li->max_experience); ?></td>
                    <td><?php echo e($li->min_payrate); ?> - <?php echo e($li->max_payrate); ?></td>
                    <td><?php echo e($li->client?->name); ?></td>
                    <td><?php echo e(ucwords($li->status)); ?></td>
                    <td><?php echo e(ucwords('Not Applied')); ?></td>
                    <td>
                        <?php echo Form::checkbox('job_id[]', $li->id); ?>
                    </td>
                </tr>             
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <div class="col-md-12" style="display: inline-flex;">
        <div class="col-md-3"></div>
        <div class="col-md-4"></div>
        <div class="col-md-3">
            <?php echo e(Form::numberGroup('payrate', 'Payrate', null, ['id'=>'payrate', 'required'=>'required'])); ?>

        </div>
        <div class="col-md-2 text-right">
            <button class="btn btn-sm btn-primary pull-right" onclick="applyJob()">Click to Apply</button>
        </div>
    </div>
</div>
<?php echo e(Form::close()); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/vendor-submissions/consultant-jobs.blade.php ENDPATH**/ ?>