
<?php $__env->startSection('title', 'Create new user'); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('users')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light">
	Users List
</a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
	h4 {
		text-decoration: underline;
	}
</style>
<div class=" card col-md-12">
	<?php echo Form::open(['url'=>'users', 'autocomplete'=>'off', 'id'=>'createForm', 'files'=>'true']); ?>	
	<h4>Marketing Information</h4>
	<div class="row">
        <div class="col-md-3">
            <?php echo Form::textGroup('name', 'Name', null, ['required'=>'required']); ?>

        </div>
        <div class="col-md-3">
            <?php echo Form::emailGroup('email', 'Email', null, ['required'=>'required']); ?>

        </div>
		<div class="col-lg-3 col-md-4 col-sm-6">
			<div class="form-group">
				<input type="text" class="form-control" id="mobile" name="mobile"
						pattern="^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$"
						data-pattern-error="Format. Example:(011) 123-4567" required maxlength="14">
				<label class="form-label"><?php echo e('Mobile Number'); ?><span class="RED-Star">*</span></label>
				<span class="form-controlBrd"></span>
				<div class="help-block with-errors"></div>
			</div>
		</div>
        <div class="col-md-3">
            <?php echo Form::fileGroup('profile_pic', 'Profile pic'); ?>

        </div>
        <div class="col-md-3">
		<?php echo e(Form::selectGroup('country_id', 'Country', $countries, null, ['data-live-search'=>'true', 'onchange'=>'getStates(1)', 'id'=>'country_1'])); ?>

        </div>
        <div class="col-md-3">
		<?php echo e(Form::selectGroup('state_id', 'State', $states, null, ['data-live-search'=>'true', 'onchange'=>'getCities(1)', 'id'=>'state_1'])); ?>

        </div>
        <div class="col-md-3">
		<?php echo e(Form::selectGroup('city_id', 'City', $cities, null, ['data-live-search'=>'true', 'id'=>'city_1'])); ?>

        </div>
	</div>

	
	<h4 class="mt-5">Personal Information</h4>
	<div class="row">
        <div class="col-md-3">
		<?php echo e(Form::textGroup('mark_name', 'Name', null, [])); ?>

        </div>

        <div class="col-md-3">
		<?php echo e(Form::textGroup('mark_email', 'Email', null, [])); ?>

        </div>

		<div class="col-lg-3 col-md-4 col-sm-6">
			<div class="form-group">
				<input type="text" class="form-control" id="mark_mobile" name="mark_mobile"
					pattern="^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$"
					data-pattern-error="Format. Example:(011) 123-4567" required maxlength="14">
				<label class="form-label">Mobile <span class="RED-Star">*</span></label>
				<span class="form-controlBrd"></span>
				<div class="help-block with-errors"></div>
			</div>
		</div>
        
        <div class="col-md-3">
            <?php echo e(Form::selectGroup('mark_country_id', 'Country', $countries, null, ['data-live-search'=>'true', 'id'=>'country_2', 'onchange'=>'getStates(2)'])); ?>

        </div>

        <div class="col-md-3">
		<?php echo e(Form::selectGroup('mark_state_id', 'State', $states, null, ['data-live-search'=>'true', 'id'=>'state_2', 'onchange'=>'getCities(2)'])); ?>

        </div>

        <div class="col-md-3">
		<?php echo e(Form::selectGroup('mark_city_id', 'City', $cities, null, ['data-live-search'=>'true', 'id'=>'city_2'])); ?>

        </div>
	</div>

	
	<h4 class="mt-5">User Information</h4>
	<div class="row">
        <div class="col-md-3">
		    <?php echo Form::selectGroup('company_id', 'Company', $companies, null, ['class'=>'selectpicker','data-live-search'=>'true' ,'required'=>'required', 'id'=>'companySelect']); ?>

        </div>
        <div class="col-md-3">
		    <?php echo Form::selectGroup('department_id', 'Department', $departments, null, ['class'=>'selectpicker','data-live-search'=>'true', 'title'=>'Select Department']); ?>

        </div>
        <div class="col-md-3">
            <small>Select Role</small>
            <select name="role_id" id="" class="selectpicker">
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rid=>$role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($rid); ?>"><?php echo e(ucwords($role)); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
		<div class="col-md-3 col-lg-3 col-sm-12">
			<small>Reporting Person</small>
			<select name="parent_id" class="selectpicker" id="parentSelect" data-live-search="true"
				title="Select Reporting Person" id="parent_id">
				<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role=>$child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $urs_role = App\Models\User::find($role)->getRoleNames()[0];
                    ?>
                    <optgroup label="Role: <?php echo e($urs_role); ?> ">
                        <option value="<?php echo e($role); ?>"><?php echo e(ucwords($child)); ?></u></option>
                    </optgroup>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</select>
		</div>
	</div>
	<div class="col-md-12">
		<div class="form-group no-margin text-right">
			<a href="<?php echo e(url('/')); ?>" class="btn btn-default waves-effect waves-light"><span
					class="fa fa-times-circle"></span> &nbsp; Cancel</a>
			<?php echo Form::submit('Save', ['type' => 'submit', 'class' =>
			'btn btn-primary waves-effect waves-light']); ?>

		</div>
	</div>

	<?php echo Form::close(); ?>

</div>

<script>
	$("#mobile").mask("(000) 000-0000");
	$("#mark_mobile").mask("(000) 000-0000");


// Get States By Country
function getStates(id) {
    var country = $("#country_" + id).val();
    $("#state_" + id).empty().selectpicker('refresh');
    $("#city_" + id).empty().selectpicker('refresh');
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: '/get_states',
        data: 'country_id=' + country,
        success: function(result) {
            $("#state_" + id).append(result);
            $("#state_" + id).selectpicker('refresh');
        }
    });
}

// Get Citites By State
function getCities(id) {
    var state = $("#state_" + id).val();
    $("#city_" + id).empty().selectpicker('refresh');
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: '/get_cities',
        data: 'state_id=' + state,
        success: function(result) {
            $("#city_" + id).append(result);
            $("#city_" + id).selectpicker('refresh');
        }
    });
}
	
	$(function() {
		$("form[id='createForm']").validate({
			// Specify validation rules
			rules: {
				name: "required",
				email: {
					required: true,
					email: true
				},
				role_id: "required",
			},
			// Specify validation error messages
			messages: {
				name: "Please enter your name",
				email: "Please enter a valid email address",
				role_id: "Please select user role",
			},
			// Make sure the form is submitted to the destination defined
			submitHandler: function(form) {
				form.submit();
			}
		});
	});
</script>
<style>
	.dropdown-header > span {
		text-decoration: underline !important;
	}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/users/create.blade.php ENDPATH**/ ?>