
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('new_button'); ?>
<?php if($meeting->organised_by == auth()->user()->id && $meeting->status != 3): ?>
<a href="/meetings/<?php echo e($meeting->id); ?>/edit" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
            class="material-icons left"> create </i>Edit Meeting
    </a>
<?php endif; ?>
<a href="<?php echo route('meetings.index'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> list </i>My Meetings List
</a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    .right-bar {
        border-right: solid blue 1px;
    }
</style>

<!-- page content -->
<div class="card">
    <h3 style="text-decoration: underline;">Meeting Info</h3>
    <div class="row mb-3">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Organised By:-</strong> <?php echo e(ucfirst($meeting->organiser->name)); ?>

        </div>
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Meeting Topic:-</strong> <?php echo e(ucfirst($meeting->subject)); ?>

        </div>
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Meeting On:-</strong> <?php echo e(Date::parse($meeting->date)->format($date_format)); ?>

        </div>
        <div class="col-lg-12 col-md-12 col-sm-12">
            <strong>Meeting Timings & Duration:-</strong> <?php echo e($meeting->time.':'.$meeting->time1); ?> <?php echo e(($meeting->time2==1)?'AM':'PM'); ?> <?php echo e($meeting->duration); ?>min
        </div>
    </div>

    <h3 style="text-decoration: underline;">Participants</h3>
    <div class="row mb-3">
    <?php $__currentLoopData = $mparticipants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($p->user_id != auth()->user()->id): ?>
        <div class="col-lg-4 col-md-4 col-sm-12 right-bar">
            <span class="pull-left"><?php echo e(ucwords($p->user->name)); ?> <input type="hidden" name="pids[]"
                    value="<?php echo e($p->user_id); ?>" disabled /></span>
            <span class="pull-right"> <?php echo e(($p->status == 1)?'Attended':'Not attended'); ?> <input type="checkbox" name="sts[]" value="<?php echo e($p->user_id); ?>" <?php if($p->status == 1): ?> checked <?php endif; ?> disabled /></span>
        </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <h3 style="text-decoration: underline;">Meeting Agenda</h3>
    <div class="row pl-3 mb-3">
        <?php echo $meeting->agenda; ?>

    </div>

    <h3 style="text-decoration: underline;">Discussion Points</h3>
    <div class="row pl-3 mb-3">
        <?php echo $meeting->dpoints; ?>

    </div>

    <h3 style="text-decoration: underline;">Issue Statements</h3>
    <?php $__currentLoopData = $issues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$issue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($meeting->organised_by == auth()->user()->id): ?>
        <h4>Issue Statement <?php echo e($key+1); ?></h4>
        <div class="row pl-3">
            <div class="col-md-3 col-lg-3 col-sm-12">
                <?php echo e(ucwords($issue->user->name)); ?>

            </div>
            <div class="col-md-6 col-lg-6 col-sm-12">
                <div class="row"><strong>Issue Statement:-</strong> <?php echo e(ucfirst($issue->issue)); ?></div>
                <div class="row"><strong>Solution Statement:-</strong> <?php echo e(ucfirst($issue->solution)); ?></div>
            </div>
            <div class="vol-lg-3 col-md-3 col-sm-12">
                <strong>Status:-</strong> <?php echo e(($issue->status==1)?'Yes':'No'); ?>

            </div>
        </div>
        <?php else: ?>
            <?php if($issue->user_id == auth()->user()->id): ?>
            <h4>Issue Statement <?php echo e($key+1); ?></h4>
            <div class="row pl-3">
                <div class="col-md-3 col-lg-3 col-sm-12">
                    <?php echo e(ucwords($issue->user->name)); ?>

                </div>
                <div class="col-md-6 col-lg-6 col-sm-12">
                    <div class="row"><strong>Issue Statement:-</strong> <?php echo e(ucfirst($issue->issue)); ?></div>
                    <div class="row"><strong>Solution Statement:-</strong> <?php echo e(ucfirst($issue->solution)); ?></div>
                </div>
                <div class="vol-lg-3 col-md-3 col-sm-12">
                    <strong>Status:-</strong> <?php echo e(($issue->status==1)?'Yes':'No'); ?>

                </div>
            </div>
            <?php endif; ?>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<!-- /page content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/meetings/show.blade.php ENDPATH**/ ?>