 
<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('accounts.incomes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', 'Invoices List'); ?>

<?php $__env->startSection('new_button'); ?>
<div class="searchBox mr-2">
   <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']); ?>

    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a  href="<?php echo e(url('common/import/incomes/invoices')); ?>" class="btn mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left rotate90deg"> last_page </i>Import Invoices</a>

<a href="<?php echo e(url('incomes/invoices/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Invoices"><i class="material-icons left">add</i> Invoice </a>

<?php $__env->stopSection(); ?>
<style>
   .card-DboardStats {
    min-height:70px !important;
}  
</style>
<?php $__env->startSection('content'); ?>
 
    <div class="row mt-2 mb-2">
        <div class="col-lg-3 col-md-3 col-sm-3">
            <a href="<?php echo e(url('incomes/invoices')); ?>">
                <div class="card-DboardStats flex-column mb-0 text-center">
                    <div class="row">
                        <div class="col-lg-4 col-md-4">
                            <span class="icon24 icon-income"></span>
                        </div>
                        <div class="col-lg-8 col-md-8">
                        <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip">
                            <span class="inv-amount"><?php echo money(isset($invoice_amount)?$invoice_amount:0,'USD' , true); ?></span>
                            <span class="inv-text">TOTAL INVOICE </span>
                        </div>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-3 col-sm-3" onClick="index_search( 'receved_amount' )">

               <a href="#"> <div class="card-DboardStats flex-column mb-0 text-center">
                 <div class="row">
                        <div class="col-lg-4 col-md-4">
                            <span class="icon24 icon-invoice"></span>
                        </div>
                        <div class="col-lg-8 col-md-8">
                    <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip">
                        <span class="inv-amount"><?php echo money(isset($payments_amount)?$payments_amount:0 ,'USD' , true); ?></span>
                        <span class="inv-text">INVOICE RECEIVED</span>
                    </div>
                </div>
            </div>
               </div></a>
        </div>
        <div class="col-lg-3 col-md-3 col-sm-3" onClick="index_search( 'over_due' )">
           <a href="#"> <div class="card-DboardStats flex-column mb-0 text-center">
             <div class="row">
                        <div class="col-lg-4 col-md-4">
                            <span class="icon24 icon-income"></span>
                        </div>
                        <div class="col-lg-8 col-md-8">
                <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip">
                    <span class="due-amount"><?php echo money(isset($overdue_amount)?$overdue_amount:0,'USD',true); ?></span>
                   <span class="due-text">OVERDUE</span>
                </div>
            </div>
        </div>
            </div></a>
        </div>
        <div class="col-lg-3 col-md-3 col-sm-3" onClick="index_search('not_due_yet')">
                <a href="#"><div class="card-DboardStats flex-column mb-0 text-center">
                     <div class="row">
                        <div class="col-lg-4 col-md-4">
                            <span class="icon24 icon-income"></span>
                        </div>
                        <div class="col-lg-8 col-md-8">
                    <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip">
                         <span class="due-amount"><?php echo money(isset($unpaid_amount)?$unpaid_amount:0,'USD',true); ?></span>
                        <span class="due-text">NOT DUE YET</span>
                    </div>
                </div>
            </div>
                </div></a>
        </div>
    </div>   

<!-- Default box -->

    <div id="content">
        <div class="wid100-Hidden">
            <table class="table table-invoice table-striped table-hover table-bordered table-filter" id="tbl-invoices">
              
                <thead>
                    <tr>
                        <th width="10%">Number</th>
                        <th width="30%">Customer </th>
                        <th width="7%">Total Amount</th>
                        <th width="7%">Received Amouont </th>
                        <th width="7%">balance Amount</th>
                        <th width="10%">Invoice Date</th>
                        <th width="10%">Cue Date</th>
                        <th width="7%">Status </th>
                        <th width="7%">Actions</th>
                        <th width="5%">&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($invoices as $item){
                    
                        if( !($item->payments_total->isEmpty()) ){
     
                           $paid_amount = isset($item->payments_total[0]['paid_amount'])?$item->payments_total[0]['paid_amount']:0;
                        }
                        else{
                            $paid_amount = 0;
                        }
                    ?>
                        <tr> 
                            <td width="10%"><a href="<?php echo e(url('incomes/invoices/' . $item->id . ' ')); ?>"><?php echo e($item->invoice_number); ?></a></td>
                            <td width="30%">
                                    <?php echo e($item->customer_name_with_parent); ?>

                            </td>

                            <td width="7%"><?php echo money($item->amount, $item->currency_code, true); ?></td>
                            
                            <td width="7%"><?php echo money($paid_amount, $item->currency_code, true); ?></td>
                           
                            <td width="7%"><?php echo money(($item->amount - $paid_amount),$item->currency_code, true); ?></td>
                            <td width="10%"><?php echo e(Date::parse($item->invoiced_at)->format($date_format)); ?></td>
                            <td width="10%"><?php echo e(Date::parse($item->due_at)->format($date_format)); ?></td>
                            <td width="7%"><span class="badge <?php echo e($item->status->label); ?>"><?php echo e($item->status->name); ?></span></td>
                            <input type="hidden" name="customer_email" id="customer_email<?php echo e($item->id); ?>"  value="<?php echo e($item->customer_email); ?>"> 
                            <input type="hidden" name="customer_name" id="customer_name<?php echo e($item->id); ?>" value="<?php echo e($item->customer_name); ?>"> 
                            <input type="hidden" name="invoice_number" id="invoice_number<?php echo e($item->id); ?>"  value="<?php echo e($item->invoice_number); ?>"> 
                            <input type="hidden" name="cc_email"  value="<?php echo e($item->cc_email); ?>" id="cc_email<?php echo e($item->id); ?>">
                            <input type="hidden" name="bcc_email" value="<?php echo e($item->bcc_email); ?>" id="bcc_email<?php echo e($item->id); ?>">
                            <td width="7%">
                                <div>
                                    <?php if($item->status->code != 'paid'): ?>
                                    <a href="<?php echo e(url('incomes/customers/receivepayment/'.$item->customer_id.'/'.$item->id)); ?>"><?php echo e(trans('invoices.receive_payment')); ?></a>
                                    <?php else: ?>
                                    <a href="<?php echo e(url('incomes/invoices/' . $item->id . '/print')); ?>" >
                                       <?php echo e(trans('general.print')); ?></a>
                                    <?php endif; ?>
                                   
                                </div>
                            </td>
                            <td width="5%">
                                <div class="position-relative">
                                    <div class="btn-group">
                                        <div class="dropdown moreIcon">
                                            <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>
                                            <ul class="dropdown-menu dropdown-menu-left">
                                                <li><a href="<?php echo e(url('incomes/invoices/' . $item->id)); ?>"><?php echo e(trans('general.show')); ?></a></li>
                                                <li><a href="<?php echo e(url('incomes/invoices/' . $item->id . '/edit')); ?>"><?php echo e(trans('general.edit')); ?></a></li>
                                                
                                                <?php if($item->status->code == 'paid'): ?>
                                                <li > <a  href="#" onclick="EmailInvoice(<?php echo e($item->id); ?>);" > <?php echo e(trans('invoices.send_mail')); ?></a>
                                                </li>
                                                <?php endif; ?>
                                                <li> <a href="<?php echo e(url('incomes/invoices/' . $item->id . '/pdf')); ?>"><?php echo e(trans('invoices.download_pdf')); ?></a>
                                                </li>
                                                <?php if($item->status->code == 'partial'): ?>
                                                
                                                <?php endif; ?>
                                                <?php if($item->status->code != 'paid'): ?>
                                                <li > <a  href="#" onclick="EmailReminder(<?php echo e($item->id); ?>);"> <?php echo e(trans('invoices.send_reminder')); ?></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo e(url('incomes/invoices/' . $item->id . '/print')); ?>" >
                                                   <?php echo e(trans('general.print')); ?>

                                                    </a>
                                                </li>
                                               
                                                <li><?php echo Form::deleteLink($item, 'incomes/invoices'); ?></li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Holds your page information!! -->
   


    <!-- Model For Reminders  -->
    <div class="modal fade" id="modal-reminder-email"  >
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                  <h4 class="modal-title"><?php echo e(trans('invoices.email_reminder')); ?> <span id="invoice_number_append"></span></h4>
                </div>
                <div class="modal-body">
                <?php echo Form::open(['id' => 'form-reminder-email', 'role' => 'form']); ?>

                    
                <?php echo Form::close(); ?>

                </div>
                <div class="modal-footer">
                    <div class="pull-left">
                      <button type="button" id="close-modal-create-customer" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"> <span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
                      <?php echo Form::button('SEND', ['type' => 'button', 'id' =>'button-reminder-email', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="modal-send-invoice"  >
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                  <h4 class="modal-title"><?php echo e(trans('invoices.send_mail')); ?> </h4>
                </div>
                <div class="modal-body">
                    <?php echo Form::open(['id' => 'form-send-invoice', 'role' => 'form']); ?>

                    
                    <?php echo Form::close(); ?>

                </div>
                <div class="modal-footer">
                    <div class="pull-left">
                      <button type="button" id="close-modal-send-invoice" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"> <span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
                      <?php echo Form::button('SEND', ['type' => 'button', 'id' =>'button-send-invoice', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- /.box -->
<script type="text/javascript">


    function EmailInvoice(invoice_id) {

        $('#form-send-invoice').html(''); 

        var customer_email = $('#customer_email'+invoice_id).val();
        var customer_name  = $('#customer_name'+invoice_id).val(); 
        var invoice_number = $('#invoice_number'+invoice_id).val();
        var cc_email       = $('#cc_email'+invoice_id).val();
        var bcc_email      = $('#bcc_email'+invoice_id).val();

         $('body').append('<button type="button" id="modal-send-invoice_button"  data-toggle="modal" data-target="#modal-send-invoice">');
         html = ' <div class="row"> <div class="col-md-6"> <div class="form-group  required "> <input class="form-control" required="required" name="customer_email" value="'+customer_email+'"  type="text" id="customer_email"> <label for="name" class="form-label"><?php echo e(trans('general.email')); ?></label> <span class="form-controlBrd"></span> </div> </div> <div class="col-md-6"> <div class="form-group  required "> <input class="form-control has-value" required="required"  name="subject" value="Invoice ['+invoice_number+']" type="text" id="subject"> <label for="name" class="form-label"><?php echo e(trans('invoices.subject')); ?></label> <span class="form-controlBrd"></span> </div> </div> <input type="hidden" name="invoice_id" id="invoice_id" value="'+invoice_id+'"> <div class="col-md-6" id="cc_email_div'+invoice_id+'" style="display:none"> <div class="form-group  required "> <input class="form-control" required="required"  name="cc_email" value="" type="text" id="cc_email"> <label for="name" class="form-label">CC</label> <span class="form-controlBrd"></span> </div> </div> <div class="col-md-6" id="bcc_email_div'+invoice_id+'" style="display:none"> <div class="form-group  required "> <input class="form-control" required="required"  name="bcc_email" value="" type="text" id="bcc_email"> <label for="name" class="form-label">BCC</label> <span class="form-controlBrd"></span> </div> </div> <div class="col-md-12"> <div class="form-groupTextArea"> <textarea class="form-ControlTextArea" placeholder="Enter Message" rows="3" name="message" cols="50" id="message">Dear '+ customer_name +', \nHere\'s your invoice! &nbsp We appreciate your prompt payment.\nThanks for your business!</textarea> <label for="name" class="form-label">Message</label> <span class="form-controlBrd"></span> </div> </div> </div>';


        $('#form-send-invoice').html(html); 
        $('#modal-send-invoice_button').trigger('click'); 
        $('#modal-send-invoice_button').remove(); 

 
    }
    function index_search(slug){
        $('#tbl-invoices tbody').append('<div class="loaderSmall"> </div>');
        url = "<?php echo e(url('incomes/invoices/search/')); ?>"+'/'+slug;
        $.ajax({
            type : "GET",
            url : url,
            beforeSend: function(){
                $('#tbl-invoices tbody tr').append('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');
            },
            complete: function(){ 
                $('#span-loader').remove();
            },
            success: function(html) {
                console.log(html);
                $('#tbl-invoices tbody tr').remove();   
                $('#tbl-invoices').append(html);
                $('#tbl-invoices tbody .loaderSmall').remove();
            }
        });

    }
    function EmailReminder(invoice_id) {

            $('body').append('<button type="button" id="modal-reminder-email_button"  data-toggle="modal" data-target="#modal-reminder-email">');

           
            $('#form-reminder-email').html('');
            var customer_email = $('#customer_email'+invoice_id).val();
            var customer_name  = $('#customer_name'+invoice_id).val();
            var invoice_number = $('#invoice_number'+invoice_id).val();
            var cc_email       = $('#cc_email'+invoice_id).val();
            var bcc_email      = $('#bcc_email'+invoice_id).val();

            var html = ' <div class="row"> <div class="col-md-6"> <div class="form-group"> <input class="form-control" required="required" name="customer_email" value="" type="text" id="customer_email"> <label for="name" class="form-label"><?php echo e(trans('general.email')); ?></label> <span class="form-controlBrd"></span> </div> </div> <div class=" col-md-6 "> <div class="form-group  required "> <input class="form-control" required="required" name="subject" value="Reminder: Invoice ['+invoice_number+'] " type="text" id="customer_email"> <label for="name" class="form-label"><?php echo e(trans('invoices.subject')); ?></label> <span class="form-controlBrd"></span> </div> </div> <div class="col-md-6" id="cc_email_div'+invoice_id+'" style="display:none"> <div class="form-group  required "> <input class="form-control" required="required" name="cc_email" value="" type="text" id="cc_email"> <label for="name" class="form-label">CC</label> <span class="form-controlBrd"></span> </div> </div> <div class="col-md-6" id="bcc_email_div'+invoice_id+'" style="display:none"> <div class="form-group  required "> <input class="form-control" required="required" name="bcc_email" value="" type="text" id="bcc_email"> <label for="name" class="form-label">BCC</label> <span class="form-controlBrd"></span> </div> </div> <input type="hidden" name="invoice_id" id="invoice_id" value="'+invoice_id+'"> <div class="col-md-12"> <div class="form-groupTextArea"> <textarea class="form-ControlTextArea" placeholder="Enter Message" rows="3" name="message" cols="50" id="message">Dear '+ customer_name +', \nHere\'s your invoice! &nbsp We appreciate your prompt payment.\nThanks for your business! </textarea> <label for="name" class="control-label">Message</label> <span class="form-controlBrd"></span> </div> </div> </div>';
            $('#form-reminder-email').html(html); 
            $('#modal-reminder-email_button').trigger('click'); 
            $('#modal-reminder-email_button').remove(); 
            
            if(cc_email){
                var cc_count       = $('#cc_email'+invoice_id).val().split(',');
                $('#cc_count'+invoice_id).html( '(' + cc_count.length + ')' );
                
            }if(bcc_email){
                var bcc_count      = $('#bcc_email'+invoice_id).val().split(',');
                $('#bcc_count'+invoice_id).html( '(' + bcc_count.length + ')' );
            }
    }
    $(document).on('click', '#button-send-invoice', function (e) {
        $('#modal-send-invoice .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

        var invoice_id = $("#form-send-invoice input[name=invoice_id]").val();
            
        $.ajax({
            url: '<?php echo e(url("incomes/invoices/")); ?>'+ '/'+ invoice_id +'/email',
            type: 'GET',
            dataType: 'JSON',
            data: $("#form-send-invoice").serialize(),
            beforeSend: function () {
                $(".form-group").removeClass("has-error");
                $(".help-block").remove();
            },
            success: function(data) {
                $('#span-loader').remove();
                if (data['success']) {
                        $('#modal-send-invoice .modal-body').before('<div class="alert alert-success">' + data['message'] + '</div>');
                        $('div.alert-success').delay(3000).fadeOut(350);
                        $('#close-modal-send-invoice').trigger('click');
                }
            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
            }
        });
    });
    $(document).on('click', '#button-reminder-email', function (e) {
        $('#modal-reminder-email .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

        var invoice_id = $("#form-reminder-email input[name=invoice_id]").val();
            
        $.ajax({
            url: '<?php echo e(url("incomes/invoices/")); ?>'+ '/'+ invoice_id +'/email',
            type: 'GET',
            dataType: 'JSON',
            data: $("#form-reminder-email").serialize(),
            beforeSend: function () {
                $(".form-group").removeClass("has-error");
                $(".help-block").remove();
            },
            success: function(data) {
                $('#span-loader').remove();

                if (data['success']) {
                        $('#modal-reminder-email .modal-body').before('<div class="alert alert-success">' + data['message'] + '</div>');
                        $('div.alert-success').delay(3000).fadeOut(350);
                        $('#close-modal-create-customer').trigger('click');
                }
                
            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
                console.log(error);
            }
        });
    });

    function showCCMail(invoice_id){
        $('#cc_email_div'+invoice_id).show();
        $('#bcc_email_div'+invoice_id).show();
        $('#ccbcc_anchor').hide();
    }

    $('#report_deposite').on('change',function(){
        alert($(this).val());
    })


</script>


<script type="text/javascript">

//Ajax call to get your new invoices
    
function getTableData(current_page){
    $.ajax({
        type: "GET",
        data : 'JSON',
        url: "<?php echo e(url('incomes/invoices?page=')); ?>"+current_page, // whatever your URL is
        beforeSend: function(){ //This is your loading message ADD AN ID
            $('#tbl-invoices').append('<div class="spinner"> </div>');
        },
        complete: function(){ //remove the loading message
          $('.spinner').remove();
        },
        success: function(html) {// success! YAY!! Add HTML to content container
            $('#tbl-invoices').append(html);
        }
    });

} 
//end of getPosts function


function searchData(search){
        if(search.value.length > 2){
            url = "<?php echo e(url('incomes/invoices/search/')); ?>"+'/'+search.value;
        }else{
            url = "<?php echo e(url('incomes/invoices/search/')); ?>"+'/'+null;
        }
        $.ajax({
            type : "GET",
            url : url,
            beforeSend: function(){
                $('#tbl-accounts').append('<div class="spinner"> <span class="">Loading...</span> </div>');
            },
            complete: function(){ 
             $('.spinner').remove();
            },
            success: function(html) {
                console.log(html);
                $('#tbl-invoices tbody tr').remove();   
                $('#tbl-invoices').append(html);
            }
        });

 }
</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/incomes/invoices/index.blade.php ENDPATH**/ ?>