
<?php  echo Tree($items); ?>

<?php /* Starts here */
    // Total Items as elements
    function Tree($elements, $prefix = 10) {
        // Each element
        foreach ($elements as $k=> $element) { 
            
                if(isset($element['invoice_customer'][0])){
                    // dd($element['invoice_customer'][0]);
                    $total_amount = 0;
                    $paid_amount = 0;

                    foreach($element['invoice_customer'] as $total_amount_loop){
                        if(isset($total_amount_loop['invoices_total']['amount'])) {
                            $total_amount += $total_amount_loop['invoices_total']['amount'];
                        }
                        $paid_amount += isset($total_amount_loop['payments_total'][0]['paid_amount'])?$total_amount_loop['payments_total'][0]['paid_amount']:0;
                    }
                }
                else{
                    $total_amount = 0;
                    $paid_amount = 0;
                }
                if(isset($element['creditmemo_customer'])){
                    $credit_amount = 0;
                    foreach($element['creditmemo_customer'] as $creditmemo){
                        $credit_amount += $creditmemo['creditmemo']['remaining_balance'];
                    }
                }
?> 
            <tr>
            	<td  style = "padding-left:<?php echo e($prefix); ?>px" >
                <a href="<?php echo e(url('incomes/customers/' . $element['id'])); ?>">
            		<?php echo e($element['name']); ?> </a>
    	            
                </td>
                <td class="hidden-xs"><?php echo e(!empty($element['customer_email']) ? $element['customer_email'] : trans('general.na')); ?></td>
                <td><?php echo e($element['phone']); ?></td>
                <td><?php echo money($total_amount + $credit_amount, $element['currency_code'], true); ?></td>
                <td><?php echo money($paid_amount + $credit_amount, $element['currency_code'], true); ?></td>
                <td><?php echo money(($total_amount-($paid_amount + $credit_amount)),$element['currency_code'], true); ?></td>
                <td class="hidden-xs">
                    <?php if($element['enabled']): ?>
                        <span class="label label-success"><?php echo e(trans('general.enabled')); ?></span>
                    <?php else: ?>
                        <span class="label label-danger"><?php echo e(trans('general.disabled')); ?></span>
                    <?php endif; ?>
                </td>
                <input type="hidden" name="customer_name" id="customer_name<?php echo e($element['id']); ?>"  value="<?php echo e($element['name']); ?>">
                <input type="hidden" name="customer_email" id="customer_email<?php echo e($element['id']); ?>"  value="<?php echo e($element['customer_email']); ?>">
                <td class="text-center">
                    <div class="pull-center">
                        <a href="<?php echo e(url('incomes/invoices/create/'.$element['id'])); ?>"><?php echo e(trans('invoices.create_invoice')); ?></a>
                    </div>
                </td>
                <td>
                    <div class="pull-right">
                            <div class="btn-group">
                                <div class="dropdown moreIcon">
                                    
                                     <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>

                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a href="<?php echo e(url('incomes/customers/' . $element['id'] . '/edit')); ?>"><?php echo e(trans('general.edit')); ?></a></li>
                                        <li><a href="#" onclick='EmailReminder(<?php echo e($element['id']); ?>)';><?php echo e(trans('general.sendreminder')); ?></a></li>
                                        <li><a href="<?php echo e(url('incomes/customers/collectioncenter/'.$element['id'] )); ?>"><?php echo e(trans('customers.collection_center')); ?></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                </td>
            </tr>
            <?php if(isset($element['children'])): ?>
                <?php Tree($element['children'], $prefix+20 );  ?>
            <?php endif; ?>
        <?php  } 
    }
?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/common/subtable.blade.php ENDPATH**/ ?>