<?php $__env->startSection('title', trans('general.title.new', ['type' => trans_choice('general.bills', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('expenses/bills')); ?>" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.bills', 1) . ' List'); ?> </a>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo Form::open(['url' => 'expenses/bills', 'files' => true, 'role' => 'form' , 'id' =>  'billcreate']); ?>

<div class="card">
    <div class="row">
        <div class="col-lg-3 col-md-4 col-sm-6  required <?php echo e($errors->has('vendor_id') ? 'has-error' : ''); ?>">
            
            <div class="row">
                <div class="col-lg-10 col-md-10 col-sm-10">
                    <small><?php echo e(trans_choice('general.vendors', 1)); ?></small>
                        <?php echo Form::select('vendor_id', $vendors, isset($vendor)?$vendor:null , array_merge(['id' => 'vendor_id','required', 'class' => 'selectpicker', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.vendors', 1)]),'data-live-search'=>'true'])); ?>

                        <?php echo $errors->first('vendor_id', '<p class="help-block">:message</p>'); ?>

                </div>
                <div class="col-lg-2 col-md-2 col-sm-2">
                    <div class="add-bttn pr-2">
                        <button type="button" data-toggle="modal" data-target="#modal-create-vendor"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;">add </i>
                        </button>
                    </div>
                   </div>
                </div>
        </div>

        <div class="col-md-3">
            <?php echo e(Form::textGroup('vendor_email', trans('general.email'), null, [])); ?>

        </div>

        <?php echo e(Form::hidden('currency_code', setting('general.default_currency'), ['id' => 'currency_code'])); ?>


        <div class="col-lg-3 col-md-4 col-sm-6 required <?php echo e($errors->has('net_term') ? 'has-error' : ''); ?>">               
            <div class="row">
                <div class="col-lg-10 col-md-10 col-sm-10">
                    <small><?php echo e(trans_choice('general.net_term', 1)); ?></small>
                        <?php echo Form::select('net_term', $terms, setting('general.default_netterm'), array_merge(['class' => 'selectpicker','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)]), 'id'=>'net_term'])); ?>            
                        <?php echo $errors->first('net_term', '<p class="help-block">:message</p>'); ?>

                </div>
                <div class="col-lg-2 col-md-2 col-sm-2">
                    <div class="add-bttn pr-2">
                        <button type="button" data-toggle="modal" data-target="#modal-create-term"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;">add </i>
                        </button>
                    </div>
                   </div>
                </div>
        </div>

        <div class="col-md-3">
            <?php echo e(Form::textGroup('billed_at', 'Bill Date', Date::now()->format('Y-m-d'), ['id' => 'billed_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

        </div>
        <div class="col-md-3">
            <?php echo e(Form::textGroup('due_at', 'Due Date', Date::now()->format('Y-m-d'), ['id' => 'due_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\''])); ?>

        </div>
        <div class="col-md-3">
            <?php echo e(Form::textGroup('bill_number', trans('bills.bill_number'), null, ['required'=>'required'])); ?>

        </div>
        <div class="col-md-3">
            <?php echo e(Form::textGroup('order_number', trans('bills.order_number'),null, [])); ?>

        </div>

        <div class="col-lg-6 col-md-6 col-sm-6">
            <div class="form-groupTextArea">
                <textarea class="form-ControlTextArea" rows="3" name="address" cols="50" id="address"></textarea>
                <label for="address" class="form-label"><?php echo e(trans('general.billingaddress')); ?></label>
                <span class="form-controlBrd"></span>
            </div>
        </div>
    </div>
</div>

<div class="">
    <h3 class="mb-3">Account Details</h3>
    <div class=" ">
        <table class="table table-bordered tabl-input table-striped" id="account">
            <thead>
                <tr style="background-color: #f9f9f9;">
                    <th width="5%" ><?php echo e(trans('general.actions')); ?></th>
                    <th width="30%"><?php echo e(trans_choice('general.accounting',1)); ?></th>
                    <th width="20%" ><?php echo e(trans('general.description')); ?></th>
                    <th width="15%" ><?php echo e(trans('bills.quantity')); ?></th>
                    <th width="15%" ><?php echo e(trans('bills.price')); ?></th>
                    <th width="15%" ><?php echo e(trans('bills.total')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $account_row = 0; ?>
                <tr id="account-row-<?php echo e($account_row); ?>">
                    <td style="vertical-align: middle;">
                        <button type="button" onclick="$('#account-row-<?php echo e($account_row); ?>').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>
                    </td>
                    <td>
                        <select onchange="nameofAccount(<?php echo e($account_row); ?>);addChartofAccount(event)" id="account-id-<?php echo e($account_row); ?>" class="selectpicker" name="account[<?php echo e($account_row); ?>][account_id]" tabindex="-1" aria-hidden="true" data-live-search="true" required="required">
                            <?php echo Cache::get('account_details_option'); ?>

                        </select>

                        <input class="form-control"  name="account[<?php echo e($account_row); ?>][name]" type="hidden" id="account-name-<?php echo e($account_row); ?>">
    
                    </td>
                    <td>
                        <div class="form-group">
                        <input class="form-control "  name="account[<?php echo e($account_row); ?>][description]"  type="text" id="account-description-<?php echo e($account_row); ?>" required>
                        <label class="form-label"><?php echo e(trans('general.description')); ?></label>
                        <span class="form-controlBrd"></span>
                        </div>
                    </td>
                    <td>
                        <div class="form-group">
                            <input class="form-control quantity" required="required" name="account[<?php echo e($account_row); ?>][quantity]" type="text" id="account-quantity-<?php echo e($account_row); ?>" value="1" min="1">
                            <label class="form-label">Quantity</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </td>
                    <td>
                        <div class="form-group">
                        <input class="form-control price" required="required" name="account[<?php echo e($account_row); ?>][price]" type="text" id="account-price-<?php echo e($account_row); ?>" value="0" min="1">
                        <label class="form-label">Price</label>
                        <span class="form-controlBrd"></span>
                    </div>
                        
                    </td>
                    <td class=" " style="vertical-align: middle;">
                        <span id="account-total-<?php echo e($account_row); ?>">0</span>
                    </td>
                </tr>
                <?php $account_row++; ?>
                <tr id="addAccount">
                    <td><button type="button" onclick="addAccount();" data-toggle="tooltip" title="<?php echo e(trans('general.add')); ?>" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="<?php echo e(trans('general.add')); ?>"><i class="material-icons">add </i></button></td>
                    <td class="text-right" colspan="5"></td>
                </tr>
                <tr>
                    <td class="text-right" colspan="5"><strong><?php echo e(trans('bills.sub_total')); ?></strong></td>
                    <td class="text-right"><span id="sub-total">0</span></td>
                </tr>
                <tr>
                    <td class="text-right" colspan="5"><strong><?php echo e(trans('bills.total')); ?></strong></td>
                    <td class="text-right"><span id="grand-total">0</span></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>


<?php echo e(Form::fileGroup('attachment', trans('general.attachment'))); ?>

<div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
          <?php echo e(Form::textareaGroup('notes', trans_choice('general.notes', 2))); ?>

      </div>

    <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
        <div id="itemoraccount"></div>
      <?php echo e(Form::saveButton('Save expenses/bills')); ?>

    </div>
</div>

<?php echo Form::close(); ?>

  
<div class="modal fade" id="modal-create-vendor" >
    <div class="modal-dialog  modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?php echo e(trans('general.title.new', ['type' => trans_choice('general.vendors',1)])); ?></h4>
            </div>
            <div class="modal-body">
                <?php echo Form::open(['id' => 'form-create-vendor', 'role' => 'form']); ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group  required">
                            <input class="form-control"  required="required" name="name" type="text" id="name">
                            <label for="name" class="form-label"><?php echo e(trans('general.name')); ?></label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group ">
                            <input class="form-control"  required="required" name="vendor_email" type="text" id="email">
                            <label for="email" class="form-label"><?php echo e(trans('general.email')); ?></label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group  required">
                            <small><?php echo e(trans_choice('general.net_term', 1)); ?></small>
                            <?php echo Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker net_term','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])); ?>

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group   ">
                            <input class="form-control" name="phone" id="phone" type="text">
                            <label for="phone" class="form-label">Phone</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>


                    <?php echo Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_cod']); ?>

                    <div class="col-md-12">
                      <div class="form-groupTextArea  ">
                        <textarea class="form-ControlTextArea" rows="3" name="address" cols="50" id="address"></textarea>
                         <label for="address" class="form-label"><?php echo e(trans('general.address')); ?> </label>
                         <span class="form-controlBrd"></span>
                      </div>
                    </div>
                  <?php echo Form::hidden('enabled', '1', []); ?>

                </div>
              <?php echo Form::close(); ?>

            </div>
            <div class="modal-footer">
              <div class="pull-left">
              <button type="button" id="close-modal-create-vendor" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
              <?php echo Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-vendor', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

              </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-create-term" >
  <div class="modal-dialog ">
      <div class="modal-content">
          <div class="modal-header">
              <h4 class="modal-title"><?php echo e(trans('general.title.new', ['type' => trans_choice('general.net_term', 1)])); ?></h4>
          </div>
          <div class="modal-body">
              <?php echo Form::open(['id' => 'form-create-term', 'role' => 'form']); ?>

              <div class="row">
                    <div class="col-md-6 "> 
                      <div class="form-group required">      
                            <input class="form-control" required name="name" type="text" id="name">
                            <label for="name" class="form-label"><?php echo e(trans('general.name')); ?></label>
                            <span class="form-controlBrd"></span>
                      </div>
                    </div>
                    <div class="col-md-6 required">
                        <div class="form-group ">
                            <input class="form-control" required name="term_days" placeholder="day" type="text" id="term_days"> 
                            <label for="name" class="form-label">Due in fixed number of days</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
              </div>
              <?php echo Form::close(); ?>

          </div>
          <div class="modal-footer">
              <div class="pull-left">
               <button type="button" id="close-modal-create-term" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;<?php echo e(trans('general.cancel')); ?></button>
              <?php echo Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-term', 'class' => 'btn btn-primary waves-effect waves-light']); ?>

              </div>
          </div>
      </div>
  </div>
</div>

<?php echo $__env->make('accounts/common/models/chartofaccount', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 
<script  src="<?php echo e(asset('accounts/chartofaccounts/accounting.js')); ?>">  </script>
<!--affix script  -->
<script type="text/javascript">
    var today = new Date();

    window.Laravel = $('meta[name="csrf-token"]').attr('content');
    $(".alert").fadeTo(2000, 500).slideUp(500, function(){
        $(".alert").slideUp(4000);
    });
    function getWeekData() { }            
    // Table Header affix
    $(document).ready(function() {
        var toggleAffix = function(affixElement, scrollElement, wrapper) {  
            var height = affixElement.outerHeight(),
            top = wrapper.offset().top;    
            if (scrollElement.scrollTop() >= top){
                wrapper.height(height);
                affixElement.addClass("affix");
                $( "table" ).addClass("affixTable");
            }
            else {
                affixElement.removeClass("affix");
                wrapper.height('auto');
            }      
        }  

        $('[data-toggle="affix"]').each(function() {
            var ele = $(this),
            wrapper = $('<div></div>');

            ele.before(wrapper);
            $(window).on('scroll resize', function() {
                toggleAffix(ele, $(this), wrapper);
            });

            // init
            toggleAffix(ele, $(window), wrapper);
        });
    });    
</script>
<!-- end -->

<script type="text/javascript">
    var account_row = <?php echo e($account_row); ?>;
    function addAccount() {
        html  = '<tr id="account-row-' + account_row + '">';
        html += '  <td style="vertical-align: middle;">';
        html += '      <button type="button" onclick="$(\'#account-row-' + account_row + '\').remove(); totalItem();" data-toggle="tooltip" title="<?php echo e(trans('general.delete')); ?>" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>';
        html += '  </td>';

        html += '  <td>';
        html += '      <select class="selectpicker" data-live-search="true" onchange="nameofAccount('+ account_row +');addChartofAccount(event)" name="account[' + account_row + '][account_id]" id="account-id-' + account_row + '" required="required">'; 

        html += $('#account-id-0').html();

        html += '      </select>';
        html += ' <input class="form-control"  name="account['+ account_row +'][name]" type="hidden" id="account-name-'+ account_row +'">'
        
        html += '  </td>';

        html += '  <td>';
        html += '    <div class="form-group"><input class="form-control"  name="account[' + account_row + '][description]" type="text"  id="account-description-' + account_row + '" required><label class="form-label"><?php echo e(trans('general.description')); ?></label> <span class="form-controlBrd"></span> </div>';
        html += '  </td>';
        html += '  <td>';
        html += '     <div class="form-group"><input class="form-control" name="account[' + account_row + '][quantity]" type="text" id="account-quantity-' + account_row + '" value="1" min="1" required><label class="form-label">Price</label> <span class="form-controlBrd"></span> </div>';
        html += '  </td>';
        html += '  <td>';
        html += '     <div class="form-group"><input class="form-control" name="account[' + account_row + '][price]" type="text" id="account-price-' + account_row + '" value="0" min="1" required><label class="form-label">Price</label> <span class="form-controlBrd"></span> </div>';
        html += '  </td>';

        html += '  <td style="vertical-align: middle;">';
        html += '      <span id="account-total-' + account_row + '">0</span>';
        html += '  </td>';

        $('#account tbody #addAccount').before(html);
        $('#account-id-'+account_row).selectpicker('refresh');

        account_row++;
    }

    // Account Name Taken Form Dropdown Text.
    function nameofAccount( id ){
        $('#account-price-'+id).prop('required',true);
        var account_id = $('#account-id-'+id +' option:selected').text();
        $('#account-name-'+id).val(account_id.split("---")[0]);
    }

    $(document).ready(function(){

        $('#net_term').on('change',function(){
            var term_id = $(this).val();
            $.ajax({
                type: 'GET',
                dataType: 'JSON',
                url : '<?php echo e(url('netterms/get_netterms/')); ?>' +'/'+term_id,
                success:function(data){
                    var dt = new Date();
                    dt.setDate(dt.getDate() + +data.term_days); //console.log(dt);
                    var date = gj.core.formatDate(dt,'<?php echo e($date_format); ?>');
                    $("#due_at").val(date);
                },
                error:function(error){
                    console.log(error);
                }

            });
        });

        $('#billcreate').submit(function() {
            var element_account = $("input[name='account[0][name]']").val();
            var element_item   = $("input[name='item[0][name]']").val(); 
            if (element_account === "" && element_item === "") {
                $('#itemoraccount').html('<p style="color:red"> Please Select Account Details or Products and Services </p>');
                return false;
            } else{
                return true;
            } 
        });

        var vendor_id = $('#vendor_id').val();
        if(vendor_id != ''){
                VendorAjax(vendor_id);
        }

        //Date picker
        $('#billed_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#billed_at').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
            clearBtn: true,
            endDate: today
        });

        //Date picker
        $('#due_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#due_at').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
            clearBtn: true,
            endDate: today
        });

        /*Accounts Event*/
        $(document).on('change', '#currency_code, #account tbody select', function(){
            totalItem();
        });

        $(document).on('keyup', '#account tbody .form-control', function(){
            totalItem();
        });

        /* Items Events */
        $(document).on('change', '#currency_code, #items tbody select', function(){
            totalItem();
        });

        $(document).on('keyup', '#items tbody .form-control', function(){
            totalItem();
        });

        $('#vendor_id').on('change',function(){
            var val = $(this).val();
            VendorAjax(val);
        });

    });

    function VendorAjax(val){
        $.ajax({
            type: 'GET',
            dataType: 'JSON',
            data: 'vendor_id=' + val,
            url : '<?php echo e(url('expenses/vendors/autocompletevendor')); ?>',
            success:function(data){
                $('#net_term').val(data.net_term);
                // This event Select2 Stylesheet
                $('#net_term').trigger("change");
                $('#vendor_email').val(data.vendor_email);
                $('#address').val(data.address);
                var dt = new Date();
                dt.setDate(dt.getDate() + +data.terms.term_days); //console.log(dt);
                var date = gj.core.formatDate(dt,'<?php echo e($date_format); ?>');
                $("#due_at").val(date);
            },
            error:function(error){
                console.log(error);
            }
        });
    }

    function totalItem() {
        $.ajax({
            url: '<?php echo e(url("items/items/totalBillamount")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $('#currency_code, #account input[type=\'text\'], #account input[type=\'hidden\'], #account textarea, #account select'),
            headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
            success: function(data) {
                if (data) {
                    $.each( data.items, function( key, value ) {
                        $('#item-total-' + key).html(value);
                    });
                    $.each( data.account, function( key, value ) {
                        $('#account-total-' + key).html(value);
                    });

                    $('#sub-total').html(data.sub_total);
                    
                    $('#grand-total').html(data.grand_total);
                }
            }
        });
    }
    
    $(document).on('click', '#button-create-vendor', function (e) {
        $('#modal-create-vendor .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '<?php echo e(url("expenses/vendors/vendor")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-create-vendor").serialize(),
            beforeSend: function () {
                $('#modal-create-vendor .modal-content').append();

                $(".form-group").removeClass("has-error");
                $(".help-block").remove();
            },
            success: function(data) {
                
                $('#span-loader').remove();

                $('#close-modal-create-vendor').trigger('click');

                $("#vendor_id").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
                //$("#vendor_id").select2('refresh');

                VendorAjax(data.id);
            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();

                if (error.responseJSON.name) {
                    $("input[name='name']").parent().parent().addClass('has-error');
                    $("input[name='name']").parent().after('<p class="help-block">' + error.responseJSON.name + '</p>');
                }

                if (error.responseJSON.email) {
                    $("input[name='email']").parent().parent().addClass('has-error');
                    $("input[name='email']").parent().after('<p class="help-block">' + error.responseJSON.email + '</p>');
                }

                if (error.responseJSON.currency_code) {
                    $("select[name='currency_code']").parent().parent().addClass('has-error');
                    $("select[name='currency_code']").parent().after('<p class="help-block">' + error.responseJSON.currency_code + '</p>');
                }
            }
        });
    });
    
    function format(input) {
        var date = new Date(input);
        return [
            date.getFullYear(),
            ("0" + (date.getMonth()+1)).slice(-2),
            ("0" + date.getDate()).slice(-2)
        ].join('-');
    }

    $(document).on('click', '#button-create-term', function (e) {
        $('#modal-create-customer .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

        $.ajax({
            url: '<?php echo e(url("/netterms/terms")); ?>',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-create-term").serialize(),
            beforeSend: function () {
                $(".form-group").removeClass("has-error");
                $(".help-block").remove();
            },
            success: function(data) {
                $('#span-loader').remove();

                $('#close-modal-create-term').trigger('click');

                $("#net_term").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
                // $("#net_term").select2('refresh');

                
            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
            }
        });
    });

 

        $(document).on('click', '#button-account-create', function (e) { 
             $('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="<?php echo e(url('acs/custom/images/loader.gif')); ?>" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>'); 
                
            $.ajax({
                url: '<?php echo e(url("accounting/chartofaccounts_model_data")); ?>',
                type: 'POST',
                dataType: 'JSON',
                data: $("#form-account-create").serialize(),
                 
                success: function(data) {
                    $('#span-loader').remove(); 

                    $('#close-modal-create-account').trigger('click');
                    $("#account-id-"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
                    $("#account-id-"+ data.present_value_of_dropdown).selectpicker('refresh');

                },
                error: function(error, textStatus, errorThrown) {
                    $('#span-loader').remove();  
                }
            });
            
        }); 
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/bills/create.blade.php ENDPATH**/ ?>