
<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('accounts.banking.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title', 'Cheques List'); ?>

<?php $__env->startSection('new_button'); ?>
<div class="searchBox mr-2">
   <?php echo Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']); ?>

    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a  href="<?php echo e(url('expenses/cheques/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Cheque"><i class="material-icons left">add</i> Cheque</a>
 

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Default box -->
<div class="box box-success">

    <table class="table table-show table-striped  table-bordered table-filter" id="tbl-cheques">       
        <thead>
            <tr>
                <th>Number</th>
                <th>Payee</th>
                <th>Amount</th>
                <th>Payment Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $cheques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><a href="<?php echo e(url('expenses/cheques/' . $item->id . ' ')); ?>"><?php echo e($item->cheque_number); ?></a></td>
                <td><?php echo e($item->person_name); ?> (<?php echo e(ucwords($item->person_type)); ?>)</td>
                <td><?php echo money($item->amount, $item->currency_code, true); ?></td>
                <td><?php echo e(Date::parse($item->paid_at)->format($date_format)); ?></td>
                <td >

                    <a  class="btn btn-outline-info btn-circle-iconic btn34" href="<?php echo e(url('expenses/cheques/' . $item->id . '/edit')); ?>"><i class="material-icons">create</i>
                    </a>
                    <a class="btn btn-outline-info btn-circle-iconic btn34" href="<?php echo e(url('expenses/cheques/' . $item->id)); ?>"><i class="material-icons"> remove_red_eye </i>
                    </a>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if(count($cheques) == 0): ?>
        <tr>
            <td colspan="6" class="text-center">No Data</td>
        </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/cheques/index.blade.php ENDPATH**/ ?>