
<?php $__env->startSection('title', 'Send agreement to consultant'); ?>
<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('includes.headers.agreements', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('/agreements')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i
        class="material-icons left">list</i> Agreements list</a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- page content -->
<div class="card">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <form class="mui-form" id="" action="<?php echo e(url('/send_agreement')); ?>" method="post"
                data-toggle="validator" role="form" autocomplete="off" enctype='multipart/form-data'>
                <div class="row">
                    <div class="col-lg-3 col-md-3 col-sm-12">
                        <?php echo Form::selectGroup('consultant_id', 'Consultant', $consultants, null, ['id'=>'consultant_id', 'required'=>'required']); ?>

                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        <?php echo e(Form::emailGroup('email', 'Email', '', ['id'=>'email'])); ?>

                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        <?php echo e(Form::textGroup('mobile', 'Mobile', '', ['id'=>'mobile', 'readonly'])); ?>

                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        <?php echo e(Form::textGroup('ssn','SSN', '', ['id'=>'ssn', 'readonly'])); ?>

                    </div>
                    
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group">
                        <?php echo e(Form::selectGroup('payrate_type', 'Payrate Type', ['fixed'=>'Fixed', 'percentage'=>'Percentage'], null, ['id'=>'payrate_type', 'title'=>'Payrate type'])); ?>

                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group" style="display: :none;" id="fixed_div">
                        <?php echo e(Form::textGroup('fixed_rate','Fixed rate', '', ['id'=>'fixed_rate'])); ?>

                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12 mui-textfield mui-textfield--float-label form-group" id="percentage_div" style="display:none;">
                        <?php echo e(Form::selectGroup('percentage_rate', 'Percentage rate', [1=>'80% - 20%', 2=>'75% - 25%'], null, ['id'=>'percentage_rate'])); ?>

                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12">
                        <?php echo Form::selectGroup('agreement_id', 'Agreement', $agreements, null, ['id'=>'agreement_id', 'required'=>'required']); ?>

                    </div>
                </div>
                <?php echo e(csrf_field()); ?>

                <!-- Agreement Div -->
                <div id="new_agreement_div_id" style="display: none;"></div>
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-xs-12 text-right">
                        <button class="btn btn-default mr-2" type="reset">Reset</button>
                        <button type="submit" id="btn_send_mail" class="btn btn-primary">Send Mail</button>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-md-12 col-sm-12 col-xs-12">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>Consultant</th>
                        <th>Payrate Type</th>
                        <th>Payrate</th>
                        <th>Agreement</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $agreement_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($item->consultant->name); ?></td>
                        <td><?php echo e($item->payrate_type); ?></td>
                        <?php if($item->payrate_type == 'fixed'): ?>
                        <td><?php echo e($item->fixed_rate); ?></td>
                        <?php else: ?>
                        <td><?php echo e($item->percentage_rate); ?></td>
                        <?php endif; ?>
                        <td><?php echo e($item->agreement->name); ?>

                            <a href="/download/<?php echo e($item->agreement->filename); ?>" class="btn btn34 btn-default btn-circle-iconic waves-effect waves-blue" target="_blank"><span class="icon24 icon-Attachments"></span></a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>

<script type="text/javascript">
    $('#consultant_id').change(function() {
		var id = $(this).val();
		$.ajax({
			url: '/consultant_details/'+id,
			success:function(data){
                var obj = jQuery.parseJSON(data);
				$('#email').val(obj.email).addClass('has-value');
				$('#mobile').val(obj.mobile).addClass('has-value');
				$('#ssn').val(obj.ssn).addClass('has-value');
			},
			error:function(data){
				$('#email').val('').addClass('has-value');
				$('#mobile').val('').addClass('has-value');
				$('#ssn').val('').addClass('has-value');
			}
		});
	});

    $('#payrate_type').change(function() {
        var type = $(this).val();
        if(type == 'fixed') {
            $("#fixed_div").show();
            $("#percentage_div").hide();
            $("#percentage_rate").val('');
        } else {
            $("#fixed_div").hide();
            $("#fixed_rate").val('');
            $("#percentage_div").show();
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/agreements/send-agreement.blade.php ENDPATH**/ ?>