
<table class="table table-striped table-hover table-bordered tabl-input" id="tbl-invoices" style="table-layout:auto;">
<thead >
    <tr>
        <th><?php echo e(trans_choice('general.numbers', 1)); ?></th>
        <th><?php echo e(trans_choice('general.customers', 1)); ?> </th>
        <th><?php echo e(trans('general.totalamount')); ?> </th>
        <th><?php echo e(trans('general.recivedamount')); ?> </th>
        <th><?php echo e(trans_choice('general.balance',2)); ?> </th>
        <th><?php echo e(trans('invoices.invoice_date')); ?> </th>
        <th><?php echo e(trans('invoices.due_date')); ?> </th>
        <th><?php echo e(trans_choice('general.statuses', 1)); ?> </th>
        <th><?php echo e(trans('general.actions')); ?></th>
    </tr>
</thead>
<tbody>
        <?php foreach($invoices as $item){
        
            if( !($item->payments_total->isEmpty()) ){

               $paid_amount = isset($item->payments_total[0]['paid_amount'])?$item->payments_total[0]['paid_amount']:0;
            }
            else{
                $paid_amount = 0;
            }
        ?>
            <tr> 
                <td><a href="<?php echo e(url('incomes/invoices/' . $item->id . ' ')); ?>"><?php echo e($item->invoice_number); ?></a></td>
                <td>
                        <?php echo e($item->customer_name_with_parent); ?>

                </td>

                <td><?php echo money($item->amount, $item->currency_code, true); ?></td>
                
                <td><?php echo money($paid_amount, $item->currency_code, true); ?></td>
               
                <td><?php echo money(($item->amount - $paid_amount),$item->currency_code, true); ?></td>
                <td><?php echo e(Date::parse($item->invoiced_at)->format($date_format)); ?></td>
                <td><?php echo e(Date::parse($item->due_at)->format($date_format)); ?></td>
                <td><span class="badge <?php echo e($item->status->label); ?>"><?php echo e($item->status->name); ?></span></td>
                <td class="text-center">
                    <div class="form-group">
                        <input type="hidden" name="invoice[<?php echo e($item->id); ?>][invoice_id]" value="<?php echo e($item->id); ?>">
                        <input class="form-control invoice_price"  name="invoice[<?php echo e($item->id); ?>][invoice_amount]" id="invoice_amount" type="number" min="1" max="<?php echo e(($item->amount - $paid_amount)); ?>">
                        <label for="invoice_amount" class="form-label">Amount</label>
                        <span class="form-controlBrd"></span>
                    </div>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table><?php /**PATH C:\xampp\htdocs\resources\views/accounts/incomes/creditmemo/getinvoices.blade.php ENDPATH**/ ?>