

<?php $__env->startSection('title', trans('reports.standard.title.standardreports', ['type' =>
trans('reports.standard.profitandlossdetails')])); ?>

<?php $__env->startSection('new_button'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
    .red-text {
        color: red;
    }

    .text-right {
        text-align: right;
    }

    .table-show tbody {
        height: auto !important;
    }

    .profit-content {
        display: none;
    }

    .profit-link .material-icons {
        position: relative;
        top: 6px;
    }

    .first-step {
        padding-left: 1% !important;
    }

    .second-step {
        padding-left: 2% !important;
    }
</style>
<!-- Default box -->
<div class="box box-success">
    <div class="card">
        <?php echo Form::open(['url'=>'/reports/standard/profit-loss-details']); ?>

        <?php echo $__env->make('accounts.reports.standard.date-filter-view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo Form::close(); ?>

    </div>
    <div class="box-body">
        <div class="row m-0">
            <h3><strong><?php echo e(trans('reports.standard.profitandlossdetails')); ?></strong></h3>
        </div>
        <table class="table table-show table-striped table-hover table-bordered " id="">
            <thead>
                <tr>
                    <th>ACCOUNT / DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>NAME</th>
                    <th>DESCRIPTION</th>
                    <th>AMOUNT</th>
                </tr>
            </thead>
        </table>
        
        <p><a class="profit-link" data-toggle="collapse" href="#incomes" role="button" aria-expanded="false"
                aria-controls="incomes"><i class="material-icons">keyboard_arrow_down</i>Incomes</a></p>
        <div class="collapse first-step" id="incomes">
            <div class="inner-accord">
                <?php
                $incometotal = 0;
                ?>
                <?php $__currentLoopData = $incomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $income): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(count($income->chartofhistory) > 0): ?>
                        <p><a class="profit-link" data-toggle="collapse" href="#innerIncomes<?php echo e($income->id); ?>" role="button" aria-expanded="false" aria-controls="innerIncomes<?php echo e($income->id); ?>"><i class="material-icons">keyboard_arrow_down</i><?php echo e($income->name); ?></a></p>
                        <div class="collapse second-step" id="innerIncomes<?php echo e($income->id); ?>">
                            <div class="inner-accord">
                                <table class="table table-show table-striped table-hover table-bordered " id="">
                                    <tbody>
                                        <?php
                                            $total = 0;
                                            $charts = $income->chartofhistory;
                                        ?>
                                        <?php $__currentLoopData = $charts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if($item->amount_type == 'add') {
                                                $total = $total + $item->amount;
                                            } else {
                                                $total = $total - $item->amount;
                                            }
                                        ?>
                                        <tr>
                                            <td><?php echo e(Carbon::parse($item->created_at)->format($date_format)); ?></td>
                                            <td><?php echo e($item->transaction_type); ?></td>
                                            <td><?php echo e($item->number); ?></td>
                                            <td><?php echo e($item->name); ?></td>
                                            <td><?php echo e($item->description); ?></td>
                                            <td><?php echo e(($item->amount_type=='add')?'+':'-'); ?><?php echo money($item->amount, 'USD', true); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <tr class="first-table">
                                    <td colspan="5"><?php echo e($income->name); ?></td>
                                    <td><?php echo money($total, 'USD', true); ?></td>
                                </tr>
                            </tbody>
                        </table>
                        <?php
                            $incometotal = $incometotal + $total;
                            $total = 0;
                        ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        
        <table class="table table-show table-striped table-hover table-bordered table-responsive">
            <tbody>
                <tr>
                    <td>Income Total</td>
                    <td><?php echo money($incometotal, 'USD', true); ?></td>
                </tr>
            </tbody>
        </table>

        
        <p><a class="profit-link" data-toggle="collapse" href="#expenses" role="button" aria-expanded="false"
                aria-controls="expenses"><i class="material-icons">keyboard_arrow_down</i>Expenses</a></p>
        <div class="collapse first-step" id="expenses">
            <div class="inner-accord">
                <?php
                $expensetotal = 0;
                ?>
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(count($expense->chartofhistory) > 0): ?>
                        <p><a class="profit-link" data-toggle="collapse" href="#innerExpense<?php echo e($expense->id); ?>" role="button" aria-expanded="false" aria-controls="innerExpense<?php echo e($expense->id); ?>"><i class="material-icons">keyboard_arrow_down</i><?php echo e($expense->name); ?></a></p>
                        <div class="collapse second-step" id="innerExpense<?php echo e($expense->id); ?>">
                            <div class="inner-accord">
                                <table class="table table-show table-striped table-hover table-bordered " id="">
                                    <tbody>
                                        <?php
                                            $etotal = 0;
                                            $charts = $expense->chartofhistory;
                                        ?>
                                        <?php $__currentLoopData = $charts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if($item->amount_type == 'add') {
                                                $etotal = $etotal + $item->amount;
                                            } else {
                                                $etotal = $etotal - $item->amount;
                                            }
                                        ?>
                                        <tr>
                                            <td><?php echo e(Carbon::parse($item->created_at)->format($date_format)); ?></td>
                                            <td><?php echo e($item->transaction_type); ?></td>
                                            <td><?php echo e($item->number); ?></td>
                                            <td><?php echo e($item->name); ?></td>
                                            <td><?php echo e($item->description); ?></td>
                                            <td><?php echo e(($item->amount_type=='add')?'+':'-'); ?><?php echo money($item->amount, 'USD', true); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <tr class="first-table">
                                    <td colspan="5"><?php echo e($expense->name); ?></td>
                                    <td><?php echo money($etotal, 'USD', true); ?></td>
                                </tr>
                            </tbody>
                        </table>
                        <?php
                            $expensetotal = $expensetotal + $etotal;
                            $etotal = 0;
                        ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        
        <table class="table table-show table-striped table-hover table-bordered ">
            <tbody>
                <tr>
                    <td>Expeses Total</td>
                    <td><?php echo money($expensetotal, 'USD', true); ?></td>
                </tr>
                <tr>
                    <td>NET INCOME</td>
                    <td><?php echo money($incometotal - $expensetotal, 'USD', true); ?></td>
                </tr>
            </tbody>
        </table>

        <div class="box-footer">
        </div>
        <!-- /.box-body -->
    </div>

    <?php echo $__env->make('accounts.reports.standard.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.datepicker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/reports/standard/business/profit-loss-details.blade.php ENDPATH**/ ?>