
<?php $__env->startSection('title', 'Import files'); ?>
<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('includes.headers.consultants', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card" role="main">
    <?php echo e(Form::open(['url'=>'/save_import_consultants', 'method'=>'post', 'enctype'=>'multipart/form-data'])); ?>

    <div class="row">
        <div class="col-lg-3 col-md-3 col-sm-12">
            <?php echo e(Form::label('csv_file', 'Select CSV File')); ?>

            <?php echo e(Form::file('csv_file', null, ['class'=>'form-control', 'required'=>'required'])); ?>

        </div>
        <div class="col-lg-3 col-md-3 col-sm-12 mt-3">
            <button type="submit" class="btn btn-sm btn-primary">Click To Import files</button>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-12 text-right pt-3">
            <a href="<?php echo e(url('/save_sample_csv')); ?>" class="btn btn-default btn-xs">Download sample CSV file</a>
        </div>
    </div>
    <?php echo e(Form::close()); ?>

</div>

<div class="card">
    <h3>Previously imported files list</h3>
    <div class="row" id="dataDiv">
        <table class="table table-show table-striped table-bordered dt-responsive nowrap jambo_table table-filter" cellspacing="0" id="abcd">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>User Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(Date::parse($file->created_at)->format(env('APP_DATE'))); ?></td>
                        <td><?php echo e($file->user?->name); ?></td>
                        <td><a href="<?php echo e(url('/save_imported_file')); ?>/<?php echo e($file->id); ?>" class="btn btn-default btn-xs">Download</a></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(count($list) == 0): ?>
                <tr>
                    <td colspan="3" class="text-center">No Data</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/consultants/import/create.blade.php ENDPATH**/ ?>