
<?php $__env->startSection('title', 'Create Incentive Structure'); ?>
<?php $__env->startSection('new_button'); ?>
	<a  href="<?php echo URL::to('/incentive_structures'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left"> list
</i>Incentive Structure List</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
	<?php echo Form::model($incentiveStructure, ['route'=>['incentive_structures.update', $incentiveStructure->id], 'id'=>'incentive_structure_form', 'autocomplete'=>'off', 'data-toggle'=>'validator', 'method'=>'PUT']); ?>

	    <div class="row">
            <div class="col-md-7">
                <div class="row">
                    <div class="col">
                        <?php echo Form::textGroup('title', 'Structure Name', null, ['maxlength'=>'100']); ?>

                    </div>
                </div>

                <div class="row">
                    <div class="col pt-4">
                        <?php echo Form::checkbox('_active', 1, ($incentiveStructure->marketing != '')?true:false, ['id'=>'checkbox1', 'onchange'=>'changeActive(1)']); ?> <label for=""> Marketing</label>
                    </div>

                    <div class="col">
                        <?php echo Form::textGroup('marketing', 'Amount', null, ['id'=>'input1', 'maxlength'=>'100', 'required'=>'required', 'maxlength'=>'6']); ?>

                    </div>

                    <div class="col pt-4">
                        <?php echo Form::checkbox('marketing_recurr', 1, null); ?> Recurring
                    </div>
                </div>

                <div class="row">
                    <div class="col pt-4">
                        <?php echo Form::checkbox('_active', 1, ($incentiveStructure->in_job != '')?true:false, ['id'=>'checkbox2', 'onchange'=>'changeActive(2)']); ?> <label for=""> In Job</label>
                    </div>

                    <div class="col">
                        <?php echo Form::textGroup('in_job', 'Amount', null, ['id'=>'input2', 'maxlength'=>'100', 'required'=>'required',  'maxlength'=>'6']); ?>

                    </div>

                    <div class="col pt-4">
                        <?php echo Form::checkbox('in_job_recurr', 1, null); ?> Recurring
                    </div>
                </div>

                <div class="row">
                    <div class="col pt-4">
                        <?php echo Form::checkbox('_active', 1, ($incentiveStructure->job_bonus != '')?true:false, ['id'=>'checkbox3', 'onchange'=>'changeActive(3)']); ?> <label for=""> Job Bonus</label>
                    </div>

                    <div class="col">
                        <?php echo Form::textGroup('job_bonus', 'Amount', null, ['id'=>'input3', 'maxlength'=>'100', 'required'=>'required', 'maxlength'=>'6']); ?>

                    </div>

                    <div class="col pt-4">
                        <?php echo Form::checkbox('job_bonus_recurr', 1, null); ?> Recurring
                    </div>
                </div>

                <div class="row">
                    <div class="col pt-4">
                        <?php echo Form::checkbox('_active', 1, ($incentiveStructure->yearly != '')?true:false, ['id'=>'checkbox4', 'onchange'=>'changeActive(4)']); ?> <label for=""> Yearly</label>
                    </div>

                    <div class="col">
                        <?php echo Form::textGroup('yearly', 'Amount', null, ['id'=>'input4', 'maxlength'=>'100', 'required'=>'required', 'maxlength'=>'6']); ?>

                    </div>

                    <div class="col pt-4">
                        <?php echo Form::checkbox('yearly_recurr', 1, null); ?> Recurring
                    </div>
                </div>
            </div>

            <div class="col-md-5 text-center">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <td style="font-size: 2rem;">Incentive Users List</td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $incentiveStructure->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(ucwords($user->user?->name)); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="form-group no-margin text-right">
            <div class="col-md-3">
                <?php echo Form::saveButton('Save'); ?>

            </div>
        </div>
	<?php echo Form::close(); ?>

</div>

<script>
    function changeActive(id) {
        if($('#checkbox'+id).is(':checked')) {
            $("#input"+id).prop('disabled', false);
        } else {
            $("#input"+id).val('');
            $("#input"+id).removeClass('has-value');
            $("#input"+id).prop('disabled', true);
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/incentive-structures/edit.blade.php ENDPATH**/ ?>