
<?php $__env->startSection('title', 'Meetings List - '.count($list)); ?>
<?php $__env->startSection('header-links'); ?>
    <?php echo $__env->make('includes.headers.meetings', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('new_button'); ?>
<a title="Meeting Analytics" href="<?php echo e(route('meetings.analytics')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> analytics </i> Meeting Analytics
</a>
<a href="<?php echo route('meetings.create'); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> <i
        class="material-icons left"> add </i> New Meeting
</a>
<?php $__env->stopSection(); ?>
<style>
    .table tbody tr td:last-child {
        white-space: nowrap;
    }

    .green{
        color: green !important;
    }

    .red{
        color: red !important;
    }
</style>
<?php $__env->startSection('content'); ?>
<!-- page content -->
<script src="https://cdn.ckeditor.com/4.6.2/standard/ckeditor.js"></script>

<div class="right_col" role="main">
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <table class="table table-show table-striped table-bordered table-responsive dt-responsive nowrap jambo_table table-filter"
                cellspacing="0" id="abcd">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Time & Duration</th>
                        <th>Topic</th>
                        <th>Venue</th>
                        <th>Conduct By</th>
                        <th>Participants</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $li): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(Date::parse($li->date)->format(env('APP_DATE'))); ?></td>
                            <td><?php echo e($li->time); ?>:<?php echo e($li->time1); ?> <?php echo e(($li->time2==1)?'AM':'PM'); ?> <?php if($li->duration!=''): ?> , <?php echo e($li->duration); ?>min <?php endif; ?></td>
                            <td title="<?php echo e(ucwords($li->subject)); ?>"><a title="View Details" href="<?php echo e(url('/meetings')); ?>/<?php echo e($li->id); ?>"><?php echo e(ucwords($li->subject)); ?></a></td>
                            <td>
                                <?php if($li->venue == 1): ?>
                                    Conference Room
                                <?php else: ?>
                                    Online
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(ucwords($li->organiser->name)); ?></td>
                            <td>                                
                                <div class="dropdown">
                                    <button class="btn btn-xs btn-default dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown"
                                        aria-haspopup="true" aria-expanded="false">
                                        Participants
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <?php $__currentLoopData = $li->participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if($p->status == 1) {
                                                $clr = 'green';
                                            } else {
                                                $clr = 'red';
                                            }
                                        ?>
                                        <a class="dropdown-item <?php echo e($clr); ?>"><?php echo e($p->user->name); ?></a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php if($li->status == 1): ?>
                                    <a class="btn btn-xs btn-info">Scheduled</a>
                                <?php elseif($li->status == 2): ?>
                                    <a class="btn btn-xs btn-warning">Mail Sent</a>
                                <?php else: ?>
                                    <a class="btn btn-xs btn-success">Completed</a>
                                <?php endif; ?>
                            </td>
                            <td>    
                                <a title="View Details" href="<?php echo e(url('meetings')); ?>/<?php echo e($li->id); ?>"
                                    class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">visibility</i></a>   
                                <?php if($li->organised_by == auth()->user()->id): ?>
                                <a title="Copy Meeting" onclick="return confirm('Are you sure? You want to copy the same meeting')" href="<?php echo e(route('meetings.copy', ['id'=>$li->id])); ?>"
                                    class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">copy_all</i></a>
                                <?php endif; ?>                         
                                <?php if($li->status == 1): ?>
                                    <?php if($li->organised_by == auth()->user()->id): ?>
                                    <a title="Edit" href="<?php echo e(url('meetings')); ?>/<?php echo e($li->id); ?>/edit"
                                        class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                                    <?php endif; ?>                                    
                                <?php elseif($li->status == 2): ?>
                                    <?php if($li->organised_by == auth()->user()->id): ?>
                                    <a title="Edit" href="<?php echo e(url('meetings')); ?>/<?php echo e($li->id); ?>/edit"
                                        class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                                    <?php endif; ?>                                    
                                <?php elseif($li->status == 3): ?>
                                    <a title="Meeting Completed"
                                        class="btn btn-outline-success btn-circle-iconic btn34"> <i class="material-icons" disabled>check</i></a>                                    
                                <?php elseif($li->status != 3 && $li->organised_by == auth()->user()->id): ?>
                                    <a title="Edit" href="<?php echo e(url('meetings')); ?>/<?php echo e($li->id); ?>/edit"
                                        class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if(count($list) == 0): ?>
                    <tr>
                        <td colspan="8" class="text-center">No Data</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/meetings/index.blade.php ENDPATH**/ ?>