<?php $__env->startSection('title', trans('general.title.edit', ['type' => trans_choice('general.vendors', 1)])); ?>
<?php $__env->startSection('new_button'); ?>
<a href="<?php echo e(url('expenses/vendors')); ?>" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i><?php echo e(trans_choice('general.vendors', 1) . ' List'); ?> </a>

<a href="<?php echo e(url('expenses/vendors/create')); ?>" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Vendors"><i class="material-icons left">add</i> <?php echo e(trans_choice('general.vendors', 2)); ?></a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Default box -->
    <div class="card">
        <?php echo Form::model($vendor, [
            'method' => 'PATCH',
            'files' => true,
            'url' => ['expenses/vendors', $vendor->id],
            'role' => 'form'
        ]); ?>


        <div class="row">
            <div class="col-md-3">
                <?php echo e(Form::textGroup('name', trans('general.name'), null, ['required'=>'required'])); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('company',  'Vendor Company Name', null)); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('vendor_email', trans('general.email'), null, ['required'=>'required'])); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('cc_email', trans('general.ccemail'), null)); ?>

            </div>
            <div class="col-md-3"> 
                <?php echo e(Form::textGroup('phone', trans('general.phone'), null)); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('mobile', trans('general.mobile'), null)); ?>

            </div>
            <div class="col-md-3">
                <?php echo e(Form::textGroup('website', trans('general.website'), null)); ?>

            </div>

            <?php echo e(Form::hidden('currency_code', setting('general.default_currency'), ['id' => 'currency_code'])); ?>


            <div class="col-lg-3 col-md-4 col-sm-6 required <?php echo e($errors->has('net_term') ? 'has-error' : ''); ?>">
                <small><?php echo e(trans_choice('general.net_term', 1)); ?></small>
              
                    <?php echo Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])); ?>

               
                <?php echo $errors->first('net_term', '<p class="help-block">:message</p>'); ?>

            </div>



            <?php echo e(Form::textareaGroup('address', trans('general.billingaddress') ,null,['rows' => '3'],'col-md-6' )); ?>

            <!-- <label style="margin-left: 5px;  " for="same_as_billing">
                <input type="checkbox" <?php echo e(($vendor->same_as_billing=='1') ? 'checked="checked" ' : ''); ?>  name="same_as_billing" id="same_as_billing" >Same as billing address 
            </label>  -->
            <div class="col-md-6">
                <div class="form-groupTextArea ">                        
                    <?php echo e(Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea' , 'id'=> 'shipping_address' ,'rows' => 3])); ?>

                        <label class="form-label">Shipping Address</label>
                        <span class="form-controlBrd"></span>
                </div>
            </div>

            <?php echo e(Form::radioGroup('enabled', trans('general.status'))); ?>

        </div>
        <!-- /.box-body -->
        
        <div class="box-footer">
            <?php echo e(Form::saveButton('expenses/vendors')); ?>

        </div>
        <!-- /.box-footer -->
        <?php echo Form::close(); ?>

    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        var text_yes = '<?php echo e(trans('general.yes')); ?>';
        var text_no = '<?php echo e(trans('general.no')); ?>';

        $(document).ready(function(){


        $(window).on("load", function(){
            if($('#same_as_billing').is(':checked') == true){
                $('#shipping_address').prop('disabled', true);
            }
        });


            /*$("#net_term").select2({
                placeholder: "<?php echo e(trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])); ?>"
            });*/

            $('#same_as_billing').change(function(){
                var c = this.checked;
                $('#shipping_address').prop('disabled', c);
                if(c){
                $('#shipping_address').val($('#address').val());
                }else{
                 $('#shipping_address').val('');
                }
            });
           

            <?php if($vendor->logo): ?>
            logo_html  = '<span class="logo">';
            logo_html += '    <a href="<?php echo e(url('uploads/' . $vendor->logo->id . '/download')); ?>">';
            logo_html += '        <span id="download-logo" class="text-primary">';
            logo_html += '            <i class="fa fa-file-<?php echo e($vendor->logo->aggregate_type); ?>-o"></i> <?php echo e($vendor->logo->basename); ?>';
            logo_html += '        </span>';
            logo_html += '    </a>';
            logo_html += '    <?php echo Form::open(['id' => 'logo-' . $vendor->logo->id, 'method' => 'DELETE', 'url' => [url('uploads/' . $vendor->logo->id)], 'style' => 'display:inline']); ?>';
            logo_html += '    <a id="remove-logo" href="javascript:void();">';
            logo_html += '        <span class="text-danger"><i class="fa fa fa-times"></i></span>';
            logo_html += '    </a>';
            logo_html += '    <?php echo Form::close(); ?>';
            logo_html += '</span>';

            $('.fancy-file .fake-file').append(logo_html);

            $(document).on('click', '#remove-logo', function (e) {
                confirmDelete("#logo-<?php echo $vendor->logo->id; ?>", "<?php echo trans('general.attachment'); ?>", "<?php echo trans('general.delete_confirm', ['name' => '<strong>' . $vendor->logo->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]); ?>", "<?php echo trans('general.cancel'); ?>", "<?php echo trans('general.delete'); ?>");
            });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/expenses/vendors/edit.blade.php ENDPATH**/ ?>