
<?php  echo Tree($items); ?>
<?php 
    function Tree($items, $prefix = 10) {
        foreach ($items as $k=> $item) {
                switch ($item['source_type']) {
                    case '0':
                        $label = 'Inventory';
                        break;
                    case '1':
                        $label = 'Non - Inventory';
                        break;
                    case '2':
                        $label = 'Service';
                        break;
                    case '3':
                        $label = 'Bundle';
                        break;
                    default:
                        $label = '';
                        break;
                    }
        	?>
            <tr>
            	<td style = "padding-left:<?php echo e($prefix); ?>px"><a href="<?php echo e(url('items/items/' . $item['id'] . '/edit')); ?>"><?php echo e($item['name']); ?></a></td>
                
                <td class="hidden-xs"><?php echo e($label); ?></td>
                <td><?php echo e(money($item['sale_price'], setting('general.default_currency'), true)); ?></td>
                <td class="hidden-xs">
                    <?php if($item['enabled']): ?>
                        <span class="label label-success"><?php echo e(trans('general.enabled')); ?></span>
                    <?php else: ?>
                        <span class="label label-danger"><?php echo e(trans('general.disabled')); ?></span>
                    <?php endif; ?>
                </td>
                <td>
                    <a  class="btn btn-outline-info btn-circle-iconic btn34" href="<?php echo e(url('items/items/' . $item['id'] . '/edit')); ?>"><i class="material-icons">create</i></a>
                </td>
            </tr>
            <?php if(isset($item['children'])): ?>
                <?php Tree($item['children'], $prefix+20 );  ?>
            <?php endif; ?>
        <?php  } 
    }
?><?php /**PATH C:\xampp\htdocs\resources\views/accounts/common/subtableitem.blade.php ENDPATH**/ ?>